/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.decorator.Decorator;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.IllegalProductException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Scope;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.ApplicationScopeLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.DependentScopeLiteral;
import org.apache.webbeans.annotation.NewLiteral;
import org.apache.webbeans.annotation.RequestedScopeLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.BeanManagerBean;
import org.apache.webbeans.component.ConversationBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.EventBean;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.InjectionTargetWrapper;
import org.apache.webbeans.component.InstanceBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.NewManagedBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.AnnotatedTypeBeanCreatorImpl;
import org.apache.webbeans.component.creation.ManagedBeanCreatorImpl;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.EJBWebBeansConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.conversation.ConversationImpl;
import org.apache.webbeans.decorator.DecoratorUtil;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.helper.ViolationMessageBuilder;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.exception.inject.DeploymentException;
import org.apache.webbeans.exception.inject.InconsistentSpecializationException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.plugins.OpenWebBeansEjbLCAPlugin;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.creation.InjectionTargetProducer;
import org.apache.webbeans.portable.creation.ProducerBeansProducer;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.portable.events.generics.GProcessBean;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.portable.events.generics.GProcessManagedBean;
import org.apache.webbeans.portable.events.generics.GProcessObservableMethod;
import org.apache.webbeans.portable.events.generics.GProcessProducer;
import org.apache.webbeans.portable.events.generics.GProcessProducerField;
import org.apache.webbeans.portable.events.generics.GProcessProducerMethod;
import org.apache.webbeans.portable.events.generics.GProcessSessionBean;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.InjectionExceptionUtils;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.SortedListHelper;

public final class WebBeansUtil {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansUtil.class);
    private static volatile Boolean enforceCheckedException;
    public static final String USE_ANNOTATED_TYPE = "com.ibm.ws.cdi.useAnnotatedType";
    private static final Class<Instance<?>> INSTANCE_TYPE;
    private static final Class<Provider<?>> PROVIDER_TYPE;
    private static final Class<Event<?>> EVENT_TYPE;
    private final WebBeansContext webBeansContext;
    private static Map<Class<? extends Annotation>, Boolean> isScopeTypeNormalCache;

    public WebBeansUtil(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    private boolean isNoCheckedExceptionEnforced() {
        if (enforceCheckedException == null) {
            enforceCheckedException = Boolean.parseBoolean(this.webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.forceNoCheckedExceptions", "true"));
        }
        return enforceCheckedException;
    }

    public static ClassLoader getCurrentClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = WebBeansUtil.class.getClassLoader();
                }
                return cl;
            }
        });
    }

    public static ClassLoader setCurrentClassLoader(final ClassLoader cl) {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                return old;
            }
        });
    }

    public static void checkGenericType(Bean<?> bean) {
        Asserts.assertNotNull(bean);
        Class clazz = bean.getBeanClass();
        if (ClassUtil.isDefinitionContainsTypeVariables(clazz) && !bean.getScope().equals(Dependent.class)) {
            throw new WebBeansConfigurationException("Generic type may only defined with scope @Dependent for ManagedBean class : " + clazz.getName());
        }
    }

    public static void checkProducerGenericType(Bean<?> bean, Member member) {
        Asserts.assertNotNull(bean, "Bean is null");
        Type type = null;
        if (bean instanceof ProducerMethodBean) {
            type = ((ProducerMethodBean)bean).getCreatorMethod().getGenericReturnType();
        } else if (bean instanceof ProducerFieldBean) {
            type = ((ProducerFieldBean)bean).getCreatorField().getGenericType();
        } else {
            throw new IllegalArgumentException("Bean must be Producer Field or Method Bean instance : " + bean);
        }
        String messageTemplate = "Producer Field/Method Bean with name : %s in bean class : %s";
        String memberName = member.getName();
        String declaringClassName = member.getDeclaringClass().getName();
        if (WebBeansUtil.checkGenericForProducers(type, messageTemplate, memberName, declaringClassName) && !bean.getScope().equals(Dependent.class)) {
            String message = WebBeansUtil.format(messageTemplate, memberName, declaringClassName);
            throw new WebBeansConfigurationException(message + " scope must bee @Dependent");
        }
    }

    private static boolean checkGenericForProducers(Type type, String messageTemplate, Object ... errorMessageArgs) {
        boolean result = false;
        if (type instanceof TypeVariable) {
            String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
            throw new WebBeansConfigurationException(message + " return type can not be type variable");
        }
        if (ClassUtil.isParametrizedType(type)) {
            Type[] actualTypes = ClassUtil.getActualTypeArguments(type);
            if (actualTypes.length == 0) {
                String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
                throw new WebBeansConfigurationException(message + " return type must define actual type arguments or type variable");
            }
            for (Type actualType : actualTypes) {
                if (ClassUtil.isWildCardType(actualType)) {
                    String message = WebBeansUtil.format(messageTemplate, errorMessageArgs);
                    throw new WebBeansConfigurationException(message + " return type can not define wildcard actual type argument");
                }
                if (!ClassUtil.isTypeVariable(actualType)) continue;
                result = true;
            }
        }
        return result;
    }

    public void isManagedBeanClass(Class<?> clazz) {
        Asserts.nullCheckForClass(clazz, "Class is null");
        int modifier = clazz.getModifiers();
        if (!Modifier.isStatic(modifier) && ClassUtil.isInnerClazz(clazz)) {
            throw new WebBeansConfigurationException("Bean implementation class : " + clazz.getName() + " can not be non-static inner class");
        }
        if (!ClassUtil.isConcrete(clazz) && !AnnotationUtil.hasClassAnnotation(clazz, Decorator.class)) {
            throw new WebBeansConfigurationException("Bean implementation class : " + clazz.getName() + " have to be concrete if not defines as @Decorator");
        }
        if (!this.isConstructureOk(clazz)) {
            throw new WebBeansConfigurationException("Bean implementation class : " + clazz.getName() + " must define at least one Constructor");
        }
        if (Extension.class.isAssignableFrom(clazz)) {
            throw new WebBeansConfigurationException("Bean implementation class can not implement javax.enterprise.inject.spi.Extension.!");
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            for (Class<?> intr : interfaces) {
                if (!intr.getName().equals("javax.ejb.EnterpriseBean")) continue;
                throw new WebBeansConfigurationException("Bean implementation class can not implement javax.ejb.EnterpriseBean");
            }
        }
        List<OpenWebBeansPlugin> plugins = this.webBeansContext.getPluginLoader().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            try {
                plugin.isManagedBean(clazz);
            }
            catch (Exception e) {
                PluginLoader.throwsException(e);
            }
        }
    }

    public boolean supportsJavaEeComponentInjections(Class<?> clazz) {
        if (clazz.isInterface() || clazz.isAnnotation() || clazz.isEnum()) {
            return false;
        }
        List<OpenWebBeansPlugin> plugins = this.webBeansContext.getPluginLoader().getPlugins();
        for (OpenWebBeansPlugin plugin : plugins) {
            if (plugin instanceof OpenWebBeansEjbPlugin || !plugin.supportsJavaEeComponentInjections(clazz)) continue;
            return true;
        }
        return false;
    }

    public <T> Constructor<T> defineConstructor(Class<T> clazz) throws WebBeansConfigurationException {
        Asserts.nullCheckForClass(clazz);
        Constructor[] constructors = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredConstructors(clazz);
        return this.defineConstructor(constructors, clazz);
    }

    public <T> Constructor<T> defineConstructor(Constructor<?>[] constructors, Class<T> clazz) {
        Annotation[][] parameterAnns;
        Constructor<Object> result = null;
        boolean inAnnotation = false;
        for (Constructor<?> constructor : constructors) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            if (inAnnotation) {
                throw new WebBeansConfigurationException("There are more than one Constructor with Initializer annotation in class " + clazz.getName());
            }
            inAnnotation = true;
            result = constructor;
        }
        if (result == null && (result = this.getNoArgConstructor(clazz)) == null) {
            throw new WebBeansConfigurationException("No constructor is found for the class : " + clazz.getName());
        }
        Annotation[][] annotationArray = parameterAnns = result.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] parameters;
            for (Annotation param : parameters = annotationArray[i]) {
                if (param.annotationType().equals(Disposes.class)) {
                    throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Disposes annotation in class : " + clazz.getName());
                }
                if (!param.annotationType().equals(Observes.class)) continue;
                throw new WebBeansConfigurationException("Constructor parameter annotations can not contain @Observes annotation in class : " + clazz.getName());
            }
        }
        return result;
    }

    public boolean isConstructureOk(Class<?> clazz) throws WebBeansConfigurationException {
        Constructor[] constructors;
        Asserts.nullCheckForClass(clazz);
        if (this.getNoArgConstructor(clazz) != null) {
            return true;
        }
        for (Constructor constructor : constructors = this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredConstructors(clazz)) {
            if (constructor.getAnnotation(Inject.class) == null) continue;
            return true;
        }
        return false;
    }

    public static void checkProducerMethodForDeployment(Method method, String parentImplClazzName) {
        Asserts.assertNotNull(method, "Method argument can not be null");
        if (AnnotationUtil.hasMethodAnnotation(method, Inject.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Disposes.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Observes.class)) {
            throw new WebBeansConfigurationException("Producer Method Bean with name : " + method.getName() + " in bean class : " + parentImplClazzName + " can not be annotated with @Initializer/@Destructor annotation or has a parameter annotated with @Disposes/@Observes");
        }
    }

    public static void checkProducerMethodDisposal(Method disposalMethod, String definedBeanClassName) {
        if (AnnotationUtil.hasMethodMultipleParameterAnnotation(disposalMethod, Disposes.class)) {
            throw new WebBeansConfigurationException("Disposal method : " + disposalMethod.getName() + " in class " + definedBeanClassName + " has multiple @Disposes annotation parameter");
        }
        if (AnnotationUtil.hasMethodAnnotation(disposalMethod, Inject.class) || AnnotationUtil.hasMethodParameterAnnotation(disposalMethod, Observes.class) || AnnotationUtil.hasMethodAnnotation(disposalMethod, Produces.class)) {
            throw new WebBeansConfigurationException("Disposal method : " + disposalMethod.getName() + " in the class : " + definedBeanClassName + " can not be annotated with @Initializer/@Destructor/@Produces annotation or has a parameter annotated with @Observes");
        }
    }

    public <T> NewManagedBean<T> createNewComponent(Class<T> clazz, Type apiType) {
        NewManagedBean<T> comp;
        Asserts.nullCheckForClass(clazz);
        DefinitionUtil definitionUtil = this.webBeansContext.getDefinitionUtil();
        if (this.webBeansContext.getManagedBeanConfigurator().isManagedBean(clazz)) {
            comp = new NewManagedBean<T>(clazz, WebBeansType.MANAGED, this.webBeansContext);
            comp.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
            comp.setConstructor(this.defineConstructor(clazz));
            definitionUtil.addConstructorInjectionPointMetaData(comp, comp.getConstructor());
            definitionUtil.defineInjectedFields(comp);
            definitionUtil.defineInjectedMethods(comp);
            definitionUtil.defineBeanInterceptorStack(comp);
        } else if (EJBWebBeansConfigurator.isSessionBean(clazz, this.webBeansContext)) {
            comp = new NewManagedBean<T>(clazz, WebBeansType.ENTERPRISE, this.webBeansContext);
            comp.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        } else {
            throw new WebBeansConfigurationException("@New annotation on type : " + clazz.getName() + " must defined as a simple or an enterprise web bean");
        }
        comp.addQualifier((Annotation)((Object)new NewLiteral(clazz)));
        comp.setName(null);
        if (apiType == null) {
            comp.addApiType(clazz);
        } else {
            comp.getTypes().add(apiType);
        }
        comp.addApiType(Object.class);
        return comp;
    }

    public <T> ExtensionBean<T> createExtensionComponent(Class<T> clazz) {
        Asserts.nullCheckForClass(clazz);
        ExtensionBean<T> comp = null;
        comp = new ExtensionBean<T>(clazz, this.webBeansContext);
        comp.setEnabled(true);
        DefinitionUtil definitionUtil = this.webBeansContext.getDefinitionUtil();
        DefinitionUtil.defineApiTypes(comp, clazz);
        comp.setImplScopeType((Annotation)((Object)new ApplicationScopeLiteral()));
        comp.addQualifier((Annotation)((Object)new DefaultLiteral()));
        definitionUtil.defineObserverMethods(comp, clazz);
        return comp;
    }

    public BeanManagerBean getManagerBean() {
        BeanManagerBean managerComponent = new BeanManagerBean(this.webBeansContext);
        managerComponent.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        managerComponent.addQualifier((Annotation)((Object)new DefaultLiteral()));
        managerComponent.addQualifier((Annotation)((Object)new AnyLiteral()));
        managerComponent.addApiType(BeanManager.class);
        managerComponent.addApiType(Object.class);
        return managerComponent;
    }

    public <T> InstanceBean<T> getInstanceBean() {
        InstanceBean instanceBean = new InstanceBean(this.webBeansContext);
        instanceBean.getTypes().add(INSTANCE_TYPE);
        instanceBean.getTypes().add(PROVIDER_TYPE);
        instanceBean.addApiType(Object.class);
        instanceBean.addQualifier((Annotation)((Object)new AnyLiteral()));
        instanceBean.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        instanceBean.setName(null);
        return instanceBean;
    }

    public <T> EventBean<T> getEventBean() {
        EventBean eventBean = new EventBean(this.webBeansContext);
        eventBean.getTypes().add(EVENT_TYPE);
        eventBean.addApiType(Object.class);
        eventBean.addQualifier((Annotation)((Object)new AnyLiteral()));
        eventBean.setImplScopeType((Annotation)((Object)new DependentScopeLiteral()));
        eventBean.setName(null);
        return eventBean;
    }

    public ConversationBean getConversationBean() {
        ConversationBean conversationComp = new ConversationBean(this.webBeansContext);
        conversationComp.addApiType(Conversation.class);
        conversationComp.addApiType(ConversationImpl.class);
        conversationComp.addApiType(Object.class);
        conversationComp.setImplScopeType((Annotation)((Object)new RequestedScopeLiteral()));
        conversationComp.addQualifier((Annotation)((Object)new DefaultLiteral()));
        conversationComp.addQualifier((Annotation)((Object)new AnyLiteral()));
        conversationComp.setName("javax.enterprise.context.conversation");
        WebBeansDecoratorConfig.configureDecorators(conversationComp);
        return conversationComp;
    }

    public InjectionPointBean getInjectionPointBean() {
        return new InjectionPointBean(this.webBeansContext);
    }

    public Method checkCommonAnnotationCriterias(Class<?> clazz, Class<? extends Annotation> commonAnnotation, boolean invocationContext) {
        Asserts.nullCheckForClass(clazz);
        Method[] methods = ClassUtil.getDeclaredMethods(clazz);
        Method result = null;
        boolean found = false;
        for (Method method : methods) {
            if (!AnnotationUtil.hasMethodAnnotation(method, commonAnnotation)) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotation is declared more than one method in the class : " + clazz.getName());
            }
            found = true;
            result = method;
            if (ClassUtil.isMethodHasParameter(method)) {
                Class<?>[] params = ClassUtil.getMethodParameterTypes(method);
                if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                    throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments other than InvocationContext");
                }
            } else if (invocationContext) {
                return null;
            }
            if (!ClassUtil.getReturnType(method).equals(Void.TYPE)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must return void type");
            }
            if (this.isNoCheckedExceptionEnforced() && ClassUtil.isMethodHasCheckedException(method)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not throw any checked exception");
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not be static");
        }
        return result;
    }

    public <T> Method checkCommonAnnotationCriterias(AnnotatedType<T> annotatedType, Class<? extends Annotation> commonAnnotation, boolean invocationContext) {
        Class clazz = annotatedType.getJavaClass();
        Method result = null;
        boolean found = false;
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod methodB = methodA;
            Method method = methodB.getJavaMember();
            if (!method.isAnnotationPresent(commonAnnotation) || ClassUtil.isMoreThanOneMethodWithName(method.getName(), clazz)) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotation is declared more than one method in the class : " + clazz.getName());
            }
            found = true;
            result = method;
            if (methodB.getParameters().isEmpty()) {
                if (!invocationContext) {
                    throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments");
                }
                List parameters = methodB.getParameters();
                ArrayList clazzParameters = new ArrayList();
                for (AnnotatedParameter parameter : parameters) {
                    clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
                }
                Class[] params = clazzParameters.toArray(new Class[clazzParameters.size()]);
                if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                    throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments other than InvocationContext");
                }
            } else if (invocationContext) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must take a parameter with class type javax.interceptor.InvocationContext.");
            }
            if (!ClassUtil.getReturnType(method).equals(Void.TYPE)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must return void type");
            }
            if (this.isNoCheckedExceptionEnforced() && ClassUtil.isMethodHasCheckedException(method)) {
                throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not throw any checked exception");
            }
            if (!Modifier.isStatic(method.getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + commonAnnotation.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not be static");
        }
        return result;
    }

    public static Method checkAroundInvokeAnnotationCriterias(Class<?> clazz, Class<? extends Annotation> annot) {
        Asserts.nullCheckForClass(clazz);
        Method[] methods = ClassUtil.getDeclaredMethods(clazz);
        Method result = null;
        boolean found = false;
        for (Method method : methods) {
            if (!AnnotationUtil.hasMethodAnnotation(method, annot) || ClassUtil.isMoreThanOneMethodWithName(method.getName(), clazz)) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotation is declared more than one method in the class : " + clazz.getName());
            }
            found = true;
            result = method;
            Class<?>[] params = ClassUtil.getMethodParameterTypes(method);
            if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not take any formal arguments other than InvocationContext");
            }
            if (!ClassUtil.getReturnType(method).equals(Object.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " must return Object type");
            }
            if (!Modifier.isStatic(method.getModifiers()) && !ClassUtil.isFinal(method.getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getName() + " in class : " + clazz.getName() + " can not be static or final");
        }
        return result;
    }

    public static <T> Method checkAroundInvokeAnnotationCriterias(AnnotatedType<T> annotatedType, Class<? extends Annotation> annot) {
        Method result = null;
        boolean found = false;
        Set methods = annotatedType.getMethods();
        for (AnnotatedMethod methodA : methods) {
            AnnotatedMethod method = methodA;
            if (!method.isAnnotationPresent(annot) || ClassUtil.isMoreThanOneMethodWithName(method.getJavaMember().getName(), annotatedType.getJavaClass())) continue;
            if (found) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotation is declared more than one method in the class : " + annotatedType.getJavaClass().getName());
            }
            found = true;
            result = method.getJavaMember();
            List parameters = method.getParameters();
            ArrayList clazzParameters = new ArrayList();
            for (AnnotatedParameter parameter : parameters) {
                clazzParameters.add(ClassUtil.getClazz(parameter.getBaseType()));
            }
            Class[] params = clazzParameters.toArray(new Class[clazzParameters.size()]);
            if (params.length != 1 || !params[0].equals(InvocationContext.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getJavaMember().getName() + " in class : " + annotatedType.getJavaClass().getName() + " can not take any formal arguments other than InvocationContext");
            }
            if (!ClassUtil.getReturnType(method.getJavaMember()).equals(Object.class)) {
                throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getJavaMember().getName() + " in class : " + annotatedType.getJavaClass().getName() + " must return Object type");
            }
            if (!Modifier.isStatic(method.getJavaMember().getModifiers()) && !ClassUtil.isFinal(method.getJavaMember().getModifiers())) continue;
            throw new WebBeansConfigurationException("@" + annot.getSimpleName() + " annotated method : " + method.getJavaMember().getName() + " in class : " + annotatedType.getJavaClass().getName() + " can not be static or final");
        }
        return result;
    }

    public void configureInterceptorMethods(javax.enterprise.inject.spi.Interceptor<?> webBeansInterceptor, Class<?> interceptorClass, Class<? extends Annotation> interceptionType, boolean definedInInterceptorClass, boolean definedInMethod, List<InterceptorData> stack, Method annotatedInterceptorClassMethod, boolean defineWithInterceptorBinding) {
        Constructor<?> ct;
        InterceptorDataImpl intData = null;
        Method method = null;
        OpenWebBeansEjbLCAPlugin ejbPlugin = null;
        Class<? extends Annotation> prePassivateClass = null;
        Class<? extends Annotation> postActivateClass = null;
        ejbPlugin = this.webBeansContext.getPluginLoader().getEjbLCAPlugin();
        if (ejbPlugin != null) {
            prePassivateClass = ejbPlugin.getPrePassivateClass();
            postActivateClass = ejbPlugin.getPostActivateClass();
        }
        if (webBeansInterceptor == null && definedInInterceptorClass && (ct = this.getNoArgConstructor(interceptorClass)) == null) {
            throw new WebBeansConfigurationException("class : " + interceptorClass.getName() + " must have no-arg constructor");
        }
        if (interceptionType.equals(AroundInvoke.class) || interceptionType.equals(AroundTimeout.class)) {
            method = WebBeansUtil.checkAroundInvokeAnnotationCriterias(interceptorClass, interceptionType);
        } else if (interceptionType.equals(PostConstruct.class) || postActivateClass != null && interceptionType.equals(postActivateClass) || interceptionType.equals(PreDestroy.class) || prePassivateClass != null && interceptionType.equals(prePassivateClass)) {
            method = this.checkCommonAnnotationCriterias(interceptorClass, interceptionType, definedInInterceptorClass);
        }
        if (method != null) {
            intData = new InterceptorDataImpl(defineWithInterceptorBinding, this.webBeansContext);
            intData.setDefinedInInterceptorClass(definedInInterceptorClass);
            intData.setDefinedInMethod(definedInMethod);
            intData.setInterceptorBindingMethod(annotatedInterceptorClassMethod);
            intData.setWebBeansInterceptor(webBeansInterceptor);
            if (definedInInterceptorClass) {
                intData.setInterceptorClass(interceptorClass);
            }
            intData.setInterceptorMethod(method, interceptionType);
            stack.add(intData);
        }
    }

    public <T> void configureInterceptorMethods(javax.enterprise.inject.spi.Interceptor<?> webBeansInterceptor, AnnotatedType<T> annotatedType, Class<? extends Annotation> annotation, boolean definedInInterceptorClass, boolean definedInMethod, List<InterceptorData> stack, Method annotatedInterceptorClassMethod) {
        InterceptorDataImpl intData = null;
        Method method = null;
        OpenWebBeansEjbLCAPlugin ejbPlugin = null;
        Class<? extends Annotation> prePassivateClass = null;
        Class<? extends Annotation> postActivateClass = null;
        ejbPlugin = this.webBeansContext.getPluginLoader().getEjbLCAPlugin();
        if (ejbPlugin != null) {
            prePassivateClass = ejbPlugin.getPrePassivateClass();
            postActivateClass = ejbPlugin.getPostActivateClass();
        }
        if (annotation.equals(AroundInvoke.class) || annotation.equals(AroundTimeout.class)) {
            method = WebBeansUtil.checkAroundInvokeAnnotationCriterias(annotatedType, annotation);
        } else if (annotation.equals(PostConstruct.class) || postActivateClass != null && annotation.equals(postActivateClass) || annotation.equals(PreDestroy.class) || prePassivateClass != null && annotation.equals(prePassivateClass)) {
            method = this.checkCommonAnnotationCriterias(annotatedType, annotation, definedInInterceptorClass);
        }
        if (method != null) {
            intData = new InterceptorDataImpl(true, this.webBeansContext);
            intData.setDefinedInInterceptorClass(definedInInterceptorClass);
            intData.setDefinedInMethod(definedInMethod);
            intData.setInterceptorBindingMethod(annotatedInterceptorClassMethod);
            intData.setWebBeansInterceptor(webBeansInterceptor);
            intData.setInterceptorMethod(method, annotation);
            intData.setInterceptorClass(webBeansInterceptor.getBeanClass());
            stack.add(intData);
        }
    }

    public <T> T newInstanceForced(Class<T> clazz) throws WebBeansConfigurationException {
        Constructor<T> ct = this.getNoArgConstructor(clazz);
        if (ct == null) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " must have no-arg constructor");
        }
        if (!ct.isAccessible()) {
            this.webBeansContext.getSecurityService().doPrivilegedSetAccessible(ct, true);
        }
        try {
            return ct.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
        catch (IllegalAccessException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
        catch (InvocationTargetException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
        catch (InstantiationException e) {
            throw new WebBeansConfigurationException("class : " + clazz.getName() + " is not constructable", e);
        }
    }

    public static boolean isContainsInterceptorMethod(List<InterceptorData> stack, InterceptionType type) {
        if (stack.size() > 0) {
            Iterator<InterceptorData> it = stack.iterator();
            while (it.hasNext()) {
                Method m = null;
                InterceptorData data = it.next();
                if (type.equals((Object)InterceptionType.AROUND_INVOKE)) {
                    m = data.getAroundInvoke();
                } else if (type.equals((Object)InterceptionType.AROUND_TIMEOUT)) {
                    m = data.getAroundTimeout();
                } else if (type.equals((Object)InterceptionType.POST_CONSTRUCT)) {
                    m = data.getPostConstruct();
                } else if (type.equals((Object)InterceptionType.POST_ACTIVATE)) {
                    m = data.getPostActivate();
                } else if (type.equals((Object)InterceptionType.PRE_DESTROY)) {
                    m = data.getPreDestroy();
                } else if (type.equals((Object)InterceptionType.PRE_PASSIVATE)) {
                    m = data.getPrePassivate();
                }
                if (m == null) continue;
                return true;
            }
        }
        return false;
    }

    public static String getManagedBeanDefaultName(String clazzName) {
        Asserts.assertNotNull(clazzName);
        if (clazzName.length() > 0) {
            StringBuilder name = new StringBuilder(clazzName);
            name.setCharAt(0, Character.toLowerCase(name.charAt(0)));
            return name.toString();
        }
        return clazzName;
    }

    public static String getProducerDefaultName(String methodName) {
        StringBuilder buffer = new StringBuilder(methodName);
        if (buffer.length() > 3 && (buffer.substring(0, 3).equals("get") || buffer.substring(0, 3).equals("set"))) {
            if (Character.isUpperCase(buffer.charAt(3))) {
                buffer.setCharAt(3, Character.toLowerCase(buffer.charAt(3)));
            }
            return buffer.substring(3);
        }
        if (buffer.length() > 2 && buffer.substring(0, 2).equals("is")) {
            if (Character.isUpperCase(buffer.charAt(2))) {
                buffer.setCharAt(2, Character.toLowerCase(buffer.charAt(2)));
            }
            return buffer.substring(2);
        }
        buffer.setCharAt(0, Character.toLowerCase(buffer.charAt(0)));
        return buffer.toString();
    }

    protected static boolean isDirectlySpecializedBeanSet(Set<Bean<?>> beans) {
        ArrayList<AbstractOwbBean> beanList = new ArrayList<AbstractOwbBean>();
        for (Bean<?> bb : beans) {
            AbstractOwbBean bean = (AbstractOwbBean)bb;
            beanList.add(bean);
        }
        Collections.sort(beanList, new Comparator(){

            public int compare(Object o1, Object o2) {
                AbstractOwbBean b1 = (AbstractOwbBean)o1;
                AbstractOwbBean b2 = (AbstractOwbBean)o2;
                Class c1 = b1.getReturnType();
                Class c2 = b2.getReturnType();
                if (c2.isAssignableFrom(c1)) {
                    return 1;
                }
                if (c1.isAssignableFrom(c2)) {
                    return -1;
                }
                throw new InconsistentSpecializationException(c1 + " and " + c2 + "are not assignable to each other.");
            }
        });
        for (int i = 0; i < beanList.size() - 1; ++i) {
            if (((AbstractOwbBean)beanList.get(i)).getReturnType().equals(((AbstractOwbBean)beanList.get(i + 1)).getReturnType().getSuperclass())) continue;
            return false;
        }
        return true;
    }

    public void configureSpecializations(List<Class<?>> beanClasses) {
        for (Class<?> clazz : beanClasses) {
            this.configureSpecializations(clazz, beanClasses);
        }
    }

    protected void configureSpecializations(Class<?> specializedClass, List<Class<?>> beanClasses) {
        Asserts.nullCheckForClass(specializedClass);
        Bean<?> superBean = null;
        Bean<?> specialized = null;
        Set<Bean<?>> resolvers = this.isConfiguredWebBeans(specializedClass, true);
        AlternativesManager altManager = this.webBeansContext.getAlternativesManager();
        if (resolvers != null) {
            if (resolvers.isEmpty()) {
                throw new InconsistentSpecializationException("Specialized bean for class : " + specializedClass + " is not enabled in the deployment.");
            }
            specialized = resolvers.iterator().next();
            if (resolvers.size() > 1) {
                if (!WebBeansUtil.isDirectlySpecializedBeanSet(resolvers)) {
                    throw new InconsistentSpecializationException("More than one specialized bean for class : " + specializedClass + " is enabled in the deployment.");
                }
                for (Bean<?> bean : resolvers) {
                    if (bean == specialized || !((AbstractOwbBean)bean).getReturnType().isAssignableFrom(((AbstractOwbBean)specialized).getReturnType())) continue;
                    specialized = bean;
                }
            }
            Class<?> superClass = specializedClass.getSuperclass();
            resolvers = this.isConfiguredWebBeans(superClass, false);
            for (Bean<?> candidates : resolvers) {
                AbstractOwbBean candidate = (AbstractOwbBean)candidates;
                if (candidate instanceof NewBean || !candidate.getReturnType().equals(superClass)) continue;
                superBean = candidates;
                break;
            }
            if (superBean != null) {
                if (beanClasses.contains(superClass) && ((AbstractOwbBean)superBean).isEnabled()) {
                    this.configureSpecializations(superClass, beanClasses);
                }
                if (!AnnotationUtil.hasClassAnnotation(specializedClass, Alternative.class)) {
                    ((AbstractOwbBean)superBean).setEnabled(false);
                } else if (altManager.isClassAlternative(specializedClass)) {
                    ((AbstractOwbBean)superBean).setEnabled(false);
                }
                AbstractOwbBean abstractOwbBean = (AbstractOwbBean)specialized;
                if (abstractOwbBean.isSpecializedBean()) {
                    return;
                }
                if (abstractOwbBean.getClass() != superBean.getClass()) {
                    throw new DefinitionException("@Specialized Class : " + specializedClass.getName() + " and its super class may be the same type of bean,i.e, ManagedBean, SessionBean etc.");
                }
                if (superBean.getName() != null) {
                    if (abstractOwbBean.getName() != null) {
                        throw new DefinitionException("@Specialized Class : " + specializedClass.getName() + " may not explicitly declare a bean name");
                    }
                    abstractOwbBean.setName(superBean.getName());
                    abstractOwbBean.setSpecializedBean(true);
                }
                specialized.getQualifiers().addAll(superBean.getQualifiers());
            } else {
                throw new InconsistentSpecializationException("WebBean component class : " + specializedClass.getName() + " is not enabled for specialized by the " + specializedClass + " class");
            }
        }
    }

    protected void configSpecializedProducerMethodBeans(List<ProducerMethodBean> sortedProducerBeans) {
        if (sortedProducerBeans.isEmpty()) {
            return;
        }
        AlternativesManager altManager = this.webBeansContext.getAlternativesManager();
        Method superMethod = sortedProducerBeans.get(0).getCreatorMethod();
        for (int i = 1; i < sortedProducerBeans.size(); ++i) {
            ProducerMethodBean bean = sortedProducerBeans.get(i);
            ProducerMethodBean superBean = sortedProducerBeans.get(i - 1);
            Set<Annotation> qualifiers = superBean.getQualifiers();
            for (Annotation an : qualifiers) {
                bean.addQualifier(an);
            }
            boolean isSuperHasName = this.configuredProducerSpecializedName(bean, bean.getCreatorMethod(), superMethod);
            if (bean.getCreatorMethod().getAnnotation(Alternative.class) == null) {
                superBean.setEnabled(false);
            } else if (altManager.isClassAlternative(bean.getBeanClass())) {
                superBean.setEnabled(false);
            }
            if (isSuperHasName) continue;
            superMethod = bean.getCreatorMethod();
        }
    }

    public void configureProducerMethodSpecializations() {
        Set<Bean<?>> beans = this.webBeansContext.getBeanManagerImpl().getBeans();
        ArrayList<ProducerMethodBean> producerBeans = new ArrayList<ProducerMethodBean>();
        for (Bean<?> b : beans) {
            if (!(b instanceof ProducerMethodBean)) continue;
            producerBeans.add((ProducerMethodBean)b);
        }
        SortedListHelper<ProducerMethodBean> producerBeanListHelper = new SortedListHelper<ProducerMethodBean>(new ArrayList(), new Comparator<ProducerMethodBean>(){

            @Override
            public int compare(ProducerMethodBean e1, ProducerMethodBean e2) {
                if (e1.getBeanClass().isAssignableFrom(e2.getBeanClass())) {
                    return -1;
                }
                if (e1.equals(e2)) {
                    return 0;
                }
                return 1;
            }
        });
        while (true) {
            boolean bl;
            ProducerMethodBean<Object> pRight;
            ProducerMethodBean<Object> pbean = null;
            Method method = null;
            producerBeanListHelper.clear();
            for (ProducerMethodBean<Object> producerMethodBean : producerBeans) {
                if (!producerMethodBean.isSpecializedBean()) continue;
                pbean = producerMethodBean;
                method = producerMethodBean.getCreatorMethod();
                producerBeanListHelper.add(producerMethodBean);
                break;
            }
            if (pbean == null) break;
            ProducerMethodBean<Object> pLeft = pRight = pbean;
            boolean pLeftContinue = true;
            boolean bl2 = true;
            while (pLeftContinue || bl) {
                bl = false;
                pLeftContinue = false;
                for (ProducerMethodBean<Object> producerMethodBean : producerBeans) {
                    Method superMethod;
                    if (pLeft != null && pLeft.getBeanClass().getSuperclass().equals(producerMethodBean.getBeanClass())) {
                        superMethod = ClassUtil.getClassMethodWithTypes(producerMethodBean.getBeanClass(), method.getName(), Arrays.asList(method.getParameterTypes()));
                        if (superMethod != null && superMethod.equals(producerMethodBean.getCreatorMethod())) {
                            producerBeanListHelper.add(producerMethodBean);
                            pLeft = producerMethodBean.isSpecializedBean() ? producerMethodBean : null;
                        } else {
                            pLeft = null;
                        }
                        if (pLeft != null) {
                            pLeftContinue = true;
                        }
                    }
                    if (pRight == null || !producerMethodBean.getBeanClass().getSuperclass().equals(pRight.getBeanClass())) continue;
                    if (!producerMethodBean.isSpecializedBean()) {
                        pRight = null;
                    } else {
                        superMethod = ClassUtil.getClassMethodWithTypes(producerMethodBean.getBeanClass(), method.getName(), Arrays.asList(method.getParameterTypes()));
                        if (superMethod != null && superMethod.equals(producerMethodBean.getCreatorMethod())) {
                            producerBeanListHelper.add(producerMethodBean);
                            pRight = producerMethodBean;
                        } else {
                            pRight = null;
                        }
                    }
                    if (pRight == null) continue;
                    bl = true;
                }
            }
            for (ProducerMethodBean<Object> producerMethodBean : producerBeanListHelper.getList()) {
                producerBeans.remove(producerMethodBean);
            }
            this.configSpecializedProducerMethodBeans(producerBeanListHelper.getList());
        }
    }

    public Set<Bean<?>> isConfiguredWebBeans(Class<?> clazz, boolean annotate) {
        Asserts.nullCheckForClass(clazz);
        HashSet beans = new HashSet();
        Set<Bean<?>> components = this.webBeansContext.getBeanManagerImpl().getComponents();
        for (AbstractOwbBean abstractOwbBean : components) {
            boolean enterprise = false;
            if (abstractOwbBean instanceof EnterpriseBeanMarker) {
                enterprise = true;
            }
            if (!abstractOwbBean.getTypes().contains(clazz) && (!enterprise || !abstractOwbBean.getBeanClass().equals(clazz))) continue;
            if (annotate) {
                if (!abstractOwbBean.getReturnType().isAnnotationPresent(Specializes.class) || abstractOwbBean instanceof NewBean) continue;
                beans.add(abstractOwbBean);
                continue;
            }
            beans.add(abstractOwbBean);
        }
        return beans;
    }

    public void checkUnproxiableApiType(Bean<?> bean, Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull("bean", "bean parameter can not be null");
        Asserts.assertNotNull(scopeType, "scopeType parameter can not be null");
        if (this.isScopeTypeNormal(scopeType)) {
            ViolationMessageBuilder violationMessage = ViolationMessageBuilder.newViolation();
            Class beanClass = bean instanceof OwbBean ? ((OwbBean)bean).getReturnType() : bean.getBeanClass();
            if (!beanClass.isInterface() && beanClass != Object.class) {
                if (beanClass.isPrimitive()) {
                    violationMessage.addLine("It isn't possible to proxy a primitive type (" + beanClass.getName(), ")");
                }
                if (ClassUtil.isArray(beanClass)) {
                    violationMessage.addLine("It isn't possible to proxy an array type (", beanClass.getName(), ")");
                }
                if (!violationMessage.containsViolation()) {
                    Method[] methods;
                    if (ClassUtil.isFinal(beanClass.getModifiers())) {
                        violationMessage.addLine(beanClass.getName(), " is a final class! CDI doesn't allow to proxy that.");
                    }
                    for (Method m : methods = SecurityUtil.doPrivilegedGetDeclaredMethods(beanClass)) {
                        int modifiers = m.getModifiers();
                        if (!ClassUtil.isFinal(modifiers) || Modifier.isPrivate(modifiers) || m.isSynthetic() || m.isBridge()) continue;
                        violationMessage.addLine(beanClass.getName(), " has final method " + m + " CDI doesn't allow to proxy that.");
                    }
                    Constructor cons = this.getNoArgConstructor(beanClass);
                    if (cons == null) {
                        violationMessage.addLine(beanClass.getName(), " has no explicit no-arg constructor!", "A public or protected constructor without args is required!");
                    } else if (Modifier.isPrivate(cons.getModifiers())) {
                        violationMessage.addLine(beanClass.getName(), " has a >private< no-arg constructor! CDI doesn't allow to proxy that.");
                    }
                }
                if (violationMessage.containsViolation()) {
                    InjectionExceptionUtils.throwUnproxyableResolutionException(violationMessage);
                }
            }
        }
    }

    private <T> Constructor<T> getNoArgConstructor(Class<T> clazz) {
        return this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredConstructor(clazz, new Class[0]);
    }

    public static void configureProducerSpecialization(AbstractOwbBean<?> component, Method method, Class<?> superClass) {
        Method superMethod = ClassUtil.getClassMethodWithTypes(superClass, method.getName(), Arrays.asList(method.getParameterTypes()));
        if (superMethod == null) {
            throw new WebBeansConfigurationException("Producer method specialization is failed. Method " + method.getName() + " not found in super class : " + superClass.getName());
        }
        if (!AnnotationUtil.hasAnnotation(superMethod.getAnnotations(), Produces.class)) {
            throw new WebBeansConfigurationException("Producer method specialization is failed. Method " + method.getName() + " found in super class : " + superClass.getName() + " is not annotated with @Produces");
        }
        component.setSpecializedBean(true);
    }

    public boolean configuredProducerSpecializedName(AbstractOwbBean<?> component, Method method, Method superMethod) {
        return this.webBeansContext.getAnnotationManager().configuredProducerSpecializedName(component, method, superMethod);
    }

    public static void checkInjectedMethodParameterConditions(Method method, Class<?> clazz) {
        Asserts.assertNotNull(method, "method parameter can not be null");
        Asserts.nullCheckForClass(clazz);
        if (AnnotationUtil.hasMethodParameterAnnotation(method, Disposes.class) || AnnotationUtil.hasMethodParameterAnnotation(method, Observes.class)) {
            throw new WebBeansConfigurationException("Initializer method parameters in method : " + method.getName() + " in class : " + clazz.getName() + " can not be annotated with @Disposes or @Observers");
        }
    }

    public static boolean checkObtainsInjectionPointConditions(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        Class candidateClazz = null;
        if (type instanceof Class) {
            candidateClazz = (Class)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            candidateClazz = (Class)pt.getRawType();
        }
        if (!candidateClazz.isAssignableFrom(Instance.class)) {
            return false;
        }
        if (ClassUtil.isParametrizedType(injectionPoint.getType())) {
            ParameterizedType pt = (ParameterizedType)injectionPoint.getType();
            Class rawType = (Class)pt.getRawType();
            Type[] typeArgs = pt.getActualTypeArguments();
            if (!rawType.isAssignableFrom(Instance.class)) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must have type javax.inject.Instance");
            }
            if (typeArgs.length != 1) {
                throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must not have more than one actual type argument");
            }
        } else {
            throw new WebBeansConfigurationException("<Instance> field injection " + injectionPoint.toString() + " must be defined as ParameterizedType with one actual type argument");
        }
        return true;
    }

    public <T> void defineInterceptor(ManagedBeanCreatorImpl<T> managedBeanCreator, ProcessInjectionTarget<T> injectionTargetEvent) {
        Class clazz = injectionTargetEvent.getAnnotatedType().getJavaClass();
        AnnotatedType annotatedType = injectionTargetEvent.getAnnotatedType();
        if (this.webBeansContext.getInterceptorsManager().isInterceptorEnabled(clazz)) {
            this.webBeansContext.getInterceptorUtil().checkInterceptorConditions(annotatedType);
            ManagedBean<T> component = this.defineManagedBean(managedBeanCreator, injectionTargetEvent, false);
            if (component != null) {
                Annotation[] anns = annotatedType.getAnnotations().toArray(new Annotation[annotatedType.getAnnotations().size()]);
                this.webBeansContext.getWebBeansInterceptorConfig().configureInterceptorClass(component, this.webBeansContext.getAnnotationManager().getInterceptorBindingMetaAnnotations(anns));
            } else {
                throw new DeploymentException("Cannot create Interceptor for class" + injectionTargetEvent.getAnnotatedType());
            }
        }
    }

    public <T> void defineDecorator(ManagedBeanCreatorImpl<T> creator, ProcessInjectionTarget<T> processInjectionTargetEvent) {
        Class clazz = processInjectionTargetEvent.getAnnotatedType().getJavaClass();
        if (this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(clazz)) {
            ManagedBean<T> delegate = null;
            DecoratorUtil.checkDecoratorConditions(clazz);
            delegate = Modifier.isAbstract(clazz.getModifiers()) ? this.defineAbstractDecorator(creator, processInjectionTargetEvent) : this.defineManagedBean(creator, processInjectionTargetEvent, false);
            if (delegate != null) {
                WebBeansDecoratorConfig.configureDecoratorClass(delegate);
            } else {
                throw new DeploymentException("Cannot create Decorator for class" + processInjectionTargetEvent.getAnnotatedType());
            }
        }
    }

    public boolean isScopeTypeNormal(Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(scopeType, "scopeType argument can not be null");
        Boolean isNormal = isScopeTypeNormalCache.get(scopeType);
        if (isNormal != null) {
            return isNormal;
        }
        if (scopeType.isAnnotationPresent(NormalScope.class)) {
            isScopeTypeNormalCache.put(scopeType, Boolean.TRUE);
            return true;
        }
        if (scopeType.isAnnotationPresent(Scope.class)) {
            isScopeTypeNormalCache.put(scopeType, Boolean.FALSE);
            return false;
        }
        List<ExternalScope> additionalScopes = this.webBeansContext.getBeanManagerImpl().getAdditionalScopes();
        for (ExternalScope additionalScope : additionalScopes) {
            if (!additionalScope.getScope().equals(scopeType)) continue;
            isNormal = additionalScope.isNormal() ? Boolean.TRUE : Boolean.FALSE;
            isScopeTypeNormalCache.put(scopeType, isNormal);
            return isNormal;
        }
        throw new IllegalArgumentException("scopeType argument must be annotated with @Scope or @NormalScope");
    }

    public static void checkNullInstance(Object instance, Class<?> scopeType, String errorMessage, Object ... errorMessageArgs) {
        if (instance == null && !scopeType.equals(Dependent.class)) {
            String message = WebBeansUtil.format(errorMessage, errorMessageArgs);
            throw new IllegalProductException(message);
        }
    }

    public void checkSerializableScopeType(Class<? extends Annotation> scopeType, boolean isSerializable, String errorMessage, Object ... errorMessageArgs) {
        if (this.webBeansContext.getBeanManagerImpl().isPassivatingScope(scopeType) && !isSerializable) {
            String message = WebBeansUtil.format(errorMessage, errorMessageArgs);
            throw new IllegalProductException(message);
        }
    }

    public static Bean<?> getMostSpecializedBean(BeanManager manager, Bean<?> component) {
        Set<Bean<?>> beans;
        if (component instanceof EnterpriseBeanMarker) {
            beans = new HashSet();
            Set<Bean<?>> allBeans = ((BeanManagerImpl)manager).getBeans((Type)((Object)Object.class), AnnotationUtil.getAnnotationsFromSet(component.getQualifiers()));
            for (Bean<?> candidateBean : allBeans) {
                Class candidateSuperClass;
                if (!(candidateBean instanceof EnterpriseBeanMarker) || !(candidateSuperClass = candidateBean.getBeanClass().getSuperclass()).equals(component.getBeanClass())) continue;
                beans.add(candidateBean);
            }
        } else {
            beans = manager.getBeans((Type)component.getBeanClass(), AnnotationUtil.getAnnotationsFromSet(component.getQualifiers()));
        }
        for (Bean bean : beans) {
            Bean find = bean;
            if (find.equals(component) || !AnnotationUtil.hasClassAnnotation(find.getBeanClass(), Specializes.class)) continue;
            return WebBeansUtil.getMostSpecializedBean(manager, find);
        }
        return component;
    }

    public <T> GProcessAnnotatedType fireProcessAnnotatedTypeEvent(AnnotatedType<T> annotatedType) {
        GProcessAnnotatedType processAnnotatedEvent = new GProcessAnnotatedType((AnnotatedType)annotatedType);
        this.webBeansContext.getBeanManagerImpl().fireEvent(processAnnotatedEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        if (processAnnotatedEvent.isModifiedAnnotatedType()) {
            this.webBeansContext.getAnnotatedElementFactory().setAnnotatedType(processAnnotatedEvent.getAnnotatedType());
        }
        return processAnnotatedEvent;
    }

    public <T> GProcessInjectionTarget fireProcessInjectionTargetEvent(AbstractInjectionTargetBean<T> bean) {
        GProcessInjectionTarget processInjectionTargetEvent = this.createProcessInjectionTargetEvent(bean);
        return this.fireProcessInjectionTargetEvent(processInjectionTargetEvent);
    }

    public GProcessInjectionTarget fireProcessInjectionTargetEvent(GProcessInjectionTarget processInjectionTargetEvent) {
        this.webBeansContext.getBeanManagerImpl().fireEvent(processInjectionTargetEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return processInjectionTargetEvent;
    }

    public <T> GProcessInjectionTarget createProcessInjectionTargetEvent(AbstractInjectionTargetBean<T> bean) {
        AnnotatedType annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(bean.getReturnType());
        InjectionTargetProducer<T> injectionTarget = new InjectionTargetProducer<T>(bean);
        return new GProcessInjectionTarget((InjectionTarget<?>)injectionTarget, (AnnotatedType<?>)annotatedType);
    }

    public <T> GProcessInjectionTarget fireProcessInjectionTargetEventForJavaEeComponents(Class<T> componentClass) {
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(componentClass);
        InjectionTarget<T> injectionTarget = this.webBeansContext.getBeanManagerImpl().createInjectionTarget(annotatedType);
        GProcessInjectionTarget processInjectionTargetEvent = new GProcessInjectionTarget(injectionTarget, annotatedType);
        return this.fireProcessInjectionTargetEvent(processInjectionTargetEvent);
    }

    public GProcessProducer fireProcessProducerEventForMethod(ProducerMethodBean<?> producerMethod, AnnotatedMethod<?> method) {
        GProcessProducer producerEvent = new GProcessProducer((Producer<?>)new ProducerBeansProducer((AbstractProducerBean<?>)producerMethod), (AnnotatedMember<?>)method);
        this.webBeansContext.getBeanManagerImpl().fireEvent(producerEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return producerEvent;
    }

    public GProcessProducer fireProcessProducerEventForField(ProducerFieldBean<?> producerField, AnnotatedField<?> field) {
        GProcessProducer producerEvent = new GProcessProducer((Producer<?>)new ProducerBeansProducer((AbstractProducerBean<?>)producerField), (AnnotatedMember<?>)field);
        this.webBeansContext.getBeanManagerImpl().fireEvent(producerEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        return producerEvent;
    }

    public void fireProcessProducerMethodBeanEvent(Map<ProducerMethodBean<?>, AnnotatedMethod<?>> annotatedMethods, AnnotatedType<?> annotatedType) {
        WebBeansContext webBeansContext = this.webBeansContext;
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        for (Map.Entry<ProducerMethodBean<?>, AnnotatedMethod<?>> beanEntry : annotatedMethods.entrySet()) {
            ProducerMethodBean<?> bean = beanEntry.getKey();
            AnnotatedMethod<?> annotatedMethod = beanEntry.getValue();
            Annotation[] annotationsFromSet = AnnotationUtil.getAnnotationsFromSet(bean.getQualifiers());
            Method disposal = annotationManager.getDisposalWithGivenAnnotatedMethod(annotatedType, bean.getReturnType(), annotationsFromSet);
            AnnotatedMethod<?> disposalAnnotated = null;
            GProcessProducerMethod processProducerMethodEvent = null;
            if (disposal != null) {
                disposalAnnotated = webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(disposal, annotatedType);
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, (AnnotatedParameter)disposalAnnotated.getParameters().get(0));
            } else {
                processProducerMethodEvent = new GProcessProducerMethod(bean, annotatedMethod, null);
            }
            webBeansContext.getBeanManagerImpl().fireEvent(processProducerMethodEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public void fireProcessObservableMethodBeanEvent(Map<ObserverMethod<?>, AnnotatedMethod<?>> annotatedMethods) {
        for (Map.Entry<ObserverMethod<?>, AnnotatedMethod<?>> observableMethodEntry : annotatedMethods.entrySet()) {
            ObserverMethod<?> observableMethod = observableMethodEntry.getKey();
            AnnotatedMethod<?> annotatedMethod = observableMethodEntry.getValue();
            GProcessObservableMethod event = new GProcessObservableMethod(annotatedMethod, observableMethod);
            this.webBeansContext.getBeanManagerImpl().fireEvent(event, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public void fireProcessProducerFieldBeanEvent(Map<ProducerFieldBean<?>, AnnotatedField<?>> annotatedFields) {
        for (Map.Entry<ProducerFieldBean<?>, AnnotatedField<?>> beanEntry : annotatedFields.entrySet()) {
            ProducerFieldBean<?> bean = beanEntry.getKey();
            AnnotatedField<?> field = beanEntry.getValue();
            GProcessProducerField processProducerFieldEvent = new GProcessProducerField(bean, field);
            this.webBeansContext.getBeanManagerImpl().fireEvent(processProducerFieldEvent, AnnotationUtil.EMPTY_ANNOTATION_ARRAY);
        }
    }

    public static void checkInjectionPointNamedQualifier(InjectionPoint injectionPoint) {
        Member member;
        String value;
        Set qualifierset = injectionPoint.getQualifiers();
        Named namedQualifier = null;
        for (Annotation qualifier : qualifierset) {
            if (!qualifier.annotationType().equals(Named.class)) continue;
            namedQualifier = (Named)qualifier;
            break;
        }
        if (namedQualifier != null && ((value = namedQualifier.value()) == null || value.equals("")) && !((member = injectionPoint.getMember()) instanceof Field)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define @Named qualifier without value!");
        }
    }

    public void setInjectionTargetBeanEnableFlag(InjectionTargetBean<?> bean) {
        AnnotatedType<?> at;
        Asserts.assertNotNull(bean, "bean can not be null");
        boolean isAlternative = WebBeansUtil.hasInjectionTargetBeanAnnotatedWithAlternative(bean);
        if (!isAlternative && (at = bean.getAnnotatedType()) != null) {
            boolean bl = isAlternative = at.getAnnotation(Alternative.class) != null;
        }
        if (isAlternative && !this.webBeansContext.getAlternativesManager().isBeanHasAlternative(bean)) {
            bean.setEnabled(false);
        }
    }

    public static boolean hasInjectionTargetBeanAnnotatedWithAlternative(InjectionTargetBean<?> bean) {
        Asserts.assertNotNull(bean, "bean can not be null");
        boolean alternative = false;
        boolean useAnnotatedType = Boolean.parseBoolean(bean.getWebBeansContext().getOpenWebBeansConfiguration().getProperty(USE_ANNOTATED_TYPE));
        AnnotatedType<?> annotatedType = bean.getAnnotatedType();
        if (useAnnotatedType && annotatedType != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Custom Property useAnnotatedType was true and annotateType was not null");
            }
            if (annotatedType.isAnnotationPresent(Alternative.class)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Alternative annotation found on AnnotatedType : [{0}]", WebBeansLoggerFacade.args(annotatedType.getClass()));
                }
                alternative = true;
            }
        } else if (AnnotationUtil.hasClassAnnotation(bean.getBeanClass(), Alternative.class)) {
            alternative = true;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Alternative annotation found on bean class : [{0}]", WebBeansLoggerFacade.args(bean.getBeanClass()));
            }
        }
        if (!alternative) {
            Set stereotypes = bean.getStereotypes();
            for (Class stereoType : stereotypes) {
                if (!AnnotationUtil.hasClassAnnotation(stereoType, Alternative.class)) continue;
                alternative = true;
                break;
            }
        }
        return alternative;
    }

    public void setBeanEnableFlagForProducerBean(InjectionTargetBean<?> parent, AbstractProducerBean<?> producer, Annotation[] annotations) {
        Asserts.assertNotNull(parent, "parent can not be null");
        Asserts.assertNotNull(producer, "producer can not be null");
        boolean alternative = false;
        if (AnnotationUtil.hasAnnotation(annotations, Alternative.class)) {
            alternative = true;
        }
        if (!alternative) {
            Set<Class<Annotation>> stereotypes = producer.getStereotypes();
            for (Class<Annotation> stereoType : stereotypes) {
                if (!AnnotationUtil.hasClassAnnotation(stereoType, Alternative.class)) continue;
                alternative = true;
                break;
            }
        }
        if (alternative) {
            if (WebBeansUtil.hasInjectionTargetBeanAnnotatedWithAlternative(parent) && this.webBeansContext.getAlternativesManager().isBeanHasAlternative(parent)) {
                producer.setEnabled(true);
            } else {
                producer.setEnabled(false);
            }
        } else {
            producer.setEnabled(parent.isEnabled());
        }
    }

    public static boolean isExtensionEventType(Class<?> clazz) {
        return clazz.equals(BeforeBeanDiscovery.class) || clazz.equals(AfterBeanDiscovery.class) || clazz.equals(AfterDeploymentValidation.class) || clazz.equals(BeforeShutdown.class) || clazz.equals(GProcessAnnotatedType.class) || clazz.equals(GProcessInjectionTarget.class) || clazz.equals(GProcessProducer.class) || clazz.equals(GProcessProducerField.class) || clazz.equals(GProcessProducerMethod.class) || clazz.equals(GProcessManagedBean.class) || clazz.equals(GProcessBean.class) || clazz.equals(GProcessSessionBean.class) || clazz.equals(GProcessObservableMethod.class);
    }

    public static boolean isExtensionBeanEventType(Class<?> clazz) {
        return clazz.equals(GProcessAnnotatedType.class) || clazz.equals(GProcessInjectionTarget.class) || clazz.equals(GProcessManagedBean.class) || clazz.equals(GProcessSessionBean.class) || clazz.equals(GProcessBean.class);
    }

    public static boolean isDefaultExtensionBeanEventType(Class<?> clazz) {
        return clazz.equals(ProcessAnnotatedType.class) || clazz.equals(ProcessInjectionTarget.class) || clazz.equals(ProcessManagedBean.class) || clazz.equals(ProcessBean.class) || clazz.equals(ProcessSessionBean.class);
    }

    public static boolean isExtensionProducerOrObserverEventType(Class<?> clazz) {
        return clazz.equals(GProcessProducer.class) || clazz.equals(GProcessProducerField.class) || clazz.equals(GProcessProducerMethod.class) || clazz.equals(GProcessObservableMethod.class);
    }

    public static boolean isDefaultExtensionProducerOrObserverEventType(Class<?> clazz) {
        return clazz.equals(ProcessProducer.class) || clazz.equals(ProcessProducerField.class) || clazz.equals(ProcessProducerMethod.class) || clazz.equals(ProcessObserverMethod.class);
    }

    public static boolean isDependent(Bean<?> bean) {
        if (!(bean instanceof OwbBean)) {
            return bean.getScope().equals(Dependent.class);
        }
        return ((OwbBean)bean).isDependent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectErrorStack(String logMessage) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        ErrorStack stack = manager.getErrorStack();
        try {
            if (stack.hasErrors()) {
                stack.logErrors();
                throw new WebBeansConfigurationException(logMessage);
            }
        }
        finally {
            stack.clear();
        }
    }

    public static String isPassivationCapable(Contextual<?> contextual) {
        if (contextual instanceof Bean) {
            if (contextual instanceof AbstractOwbBean) {
                if (((AbstractOwbBean)contextual).isPassivationCapable()) {
                    return ((AbstractOwbBean)contextual).getId();
                }
            } else if (contextual instanceof PassivationCapable) {
                PassivationCapable pc = (PassivationCapable)contextual;
                return pc.getId();
            }
        } else if (contextual instanceof PassivationCapable && contextual instanceof Serializable) {
            PassivationCapable pc = (PassivationCapable)contextual;
            return pc.getId();
        }
        return null;
    }

    public <T> ManagedBean<T> defineAbstractDecorator(ManagedBeanCreatorImpl<T> managedBeanCreator, ProcessInjectionTarget<T> processInjectionTargetEvent) {
        ManagedBean<?> bean = this.defineManagedBean(managedBeanCreator, processInjectionTargetEvent, false);
        if (bean == null) {
            throw new DeploymentException("Cannot create ManagedBean for class" + processInjectionTargetEvent.getAnnotatedType());
        }
        Class<?> clazz = this.webBeansContext.getProxyFactory().createAbstractDecoratorProxyClass(bean);
        bean.setConstructor(this.defineConstructor(clazz));
        bean.setIsAbstractDecorator(true);
        return bean;
    }

    public <T> ManagedBean<T> defineManagedBean(ManagedBeanCreatorImpl<T> managedBeanCreator, ProcessInjectionTarget<T> processInjectionTargetEvent, boolean allowLazyInit) {
        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
        AnnotatedType annotatedType = processInjectionTargetEvent.getAnnotatedType();
        AbstractInjectionTargetBean managedBean = managedBeanCreator.getBean();
        Class clazz = annotatedType.getJavaClass();
        managedBeanCreator.defineApiType();
        managedBeanCreator.defineStereoTypes();
        managedBeanCreator.defineScopeType(WebBeansLoggerFacade.getTokenString("TEXT_MB_IMPL") + clazz.getName() + WebBeansLoggerFacade.getTokenString("TEXT_SAME_SCOPE"), allowLazyInit);
        managedBeanCreator.defineSerializable();
        this.setInjectionTargetBeanEnableFlag(managedBean);
        managedBeanCreator.checkCreateConditions();
        managedBeanCreator.defineQualifier();
        managedBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        if (((ManagedBean)managedBean).isFullInit()) {
            managedBeanCreator.defineConstructor();
            Set<ProducerMethodBean<?>> producerMethods = managedBeanCreator.defineProducerMethods();
            Set<ProducerFieldBean<?>> producerFields = managedBeanCreator.defineProducerFields();
            managedBeanCreator.defineInjectedFields();
            managedBeanCreator.defineInjectedMethods();
            Set<Object> observerMethods = new HashSet();
            if (managedBean.isEnabled()) {
                observerMethods = managedBeanCreator.defineObserverMethods();
            }
            manager.putInjectionTargetWrapper(managedBean, new InjectionTargetWrapper(processInjectionTargetEvent.getInjectionTarget()));
            HashMap annotatedMethods = new HashMap();
            for (ProducerMethodBean<?> producerMethodBean : producerMethods) {
                AnnotatedMethod annotatedMethod = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(producerMethodBean.getCreatorMethod(), annotatedType);
                GProcessProducer gProcessProducer = this.fireProcessProducerEventForMethod(producerMethodBean, annotatedMethod);
                this.inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerMethods. Look at logs for further details");
                annotatedMethods.put(producerMethodBean, annotatedMethod);
                manager.putInjectionTargetWrapper(producerMethodBean, new InjectionTargetWrapper(gProcessProducer.getProducer()));
            }
            HashMap annotatedFields = new HashMap();
            for (ProducerFieldBean<?> producerFieldBean : producerFields) {
                AnnotatedField annotatedField = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedField(producerFieldBean.getCreatorField(), annotatedType);
                GProcessProducer producerEvent = this.fireProcessProducerEventForField(producerFieldBean, annotatedField);
                this.inspectErrorStack("There are errors that are added by ProcessProducer event observers for ProducerFields. Look at logs for further details");
                annotatedFields.put(producerFieldBean, annotatedField);
                manager.putInjectionTargetWrapper(producerFieldBean, new InjectionTargetWrapper(producerEvent.getProducer()));
            }
            HashMap hashMap = new HashMap();
            for (ObserverMethod observerMethod : observerMethods) {
                ObserverMethodImpl impl = (ObserverMethodImpl)observerMethod;
                AnnotatedMethod annotatedMethod = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedMethod(impl.getObserverMethod(), annotatedType);
                hashMap.put(observerMethod, annotatedMethod);
            }
            BeanManagerImpl beanManagerImpl = this.webBeansContext.getBeanManagerImpl();
            GProcessManagedBean gProcessManagedBean = new GProcessManagedBean((ManagedBean<?>)managedBean, (AnnotatedType<?>)annotatedType);
            beanManagerImpl.fireEvent(gProcessManagedBean, new Annotation[0]);
            this.inspectErrorStack("There are errors that are added by ProcessManagedBean event observers for managed beans. Look at logs for further details");
            this.fireProcessProducerMethodBeanEvent(annotatedMethods, annotatedType);
            this.inspectErrorStack("There are errors that are added by ProcessProducerMethod event observers for producer method beans. Look at logs for further details");
            this.fireProcessProducerFieldBeanEvent(annotatedFields);
            this.inspectErrorStack("There are errors that are added by ProcessProducerField event observers for producer field beans. Look at logs for further details");
            this.fireProcessObservableMethodBeanEvent(hashMap);
            this.inspectErrorStack("There are errors that are added by ProcessObserverMethod event observers for observer methods. Look at logs for further details");
            if (!this.isAnnotatedTypeDecoratorOrInterceptor(annotatedType)) {
                beanManagerImpl.addBean(managedBean);
                for (ProducerMethodBean<?> producerMethodBean : producerMethods) {
                    beanManagerImpl.addBean(producerMethodBean);
                }
                managedBeanCreator.defineDisposalMethods();
                for (ProducerFieldBean producerFieldBean : producerFields) {
                    beanManagerImpl.addBean(producerFieldBean);
                }
            }
        } else {
            BeanManagerImpl beanManager = this.webBeansContext.getBeanManagerImpl();
            GProcessManagedBean processBeanEvent = new GProcessManagedBean((ManagedBean<?>)managedBean, (AnnotatedType<?>)annotatedType);
            beanManager.fireEvent(processBeanEvent, new Annotation[0]);
            this.inspectErrorStack("There are errors that are added by ProcessManagedBean event observers for managed beans. Look at logs for further details");
            if (!this.isAnnotatedTypeDecoratorOrInterceptor(annotatedType)) {
                beanManager.addBean(managedBean);
            }
        }
        return managedBean;
    }

    public <T> ManagedBean<T> defineManagedBeanWithoutFireEvents(AnnotatedType<T> type) {
        Class clazz = type.getJavaClass();
        ManagedBean<T> managedBean = new ManagedBean<T>(clazz, WebBeansType.MANAGED, this.webBeansContext);
        managedBean.setAnnotatedType(type);
        ManagedBeanCreatorImpl<T> managedBeanCreator = new ManagedBeanCreatorImpl<T>(managedBean);
        managedBeanCreator.setAnnotatedType(type);
        managedBeanCreator.defineApiType();
        managedBeanCreator.defineStereoTypes();
        managedBeanCreator.defineScopeType(WebBeansLoggerFacade.getTokenString("TEXT_MB_IMPL") + clazz.getName() + WebBeansLoggerFacade.getTokenString("TEXT_SAME_SCOPE"), false);
        managedBeanCreator.defineSerializable();
        this.setInjectionTargetBeanEnableFlag(managedBean);
        managedBeanCreator.checkCreateConditions();
        managedBeanCreator.defineQualifier();
        managedBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        managedBeanCreator.defineConstructor();
        managedBeanCreator.defineProducerMethods();
        managedBeanCreator.defineProducerFields();
        managedBeanCreator.defineInjectedFields();
        managedBeanCreator.defineInjectedMethods();
        managedBeanCreator.defineObserverMethods();
        DefinitionUtil definitionUtil = this.webBeansContext.getDefinitionUtil();
        definitionUtil.defineDecoratorStack(managedBean);
        definitionUtil.defineBeanInterceptorStack(managedBean);
        managedBeanCreator.defineDisposalMethods();
        return managedBean;
    }

    public static boolean isStaticInjection(InjectionPoint injectionPoint) {
        Member member;
        return injectionPoint != null && (member = injectionPoint.getMember()) != null && Modifier.isStatic(member.getModifiers());
    }

    public boolean isPassivationCapableDependency(InjectionPoint injectionPoint) {
        if (injectionPoint.isDelegate()) {
            return true;
        }
        InjectionResolver instance = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
        Bean<?> bean = instance.getInjectionPointBean(injectionPoint);
        if (bean instanceof EnterpriseBeanMarker || bean instanceof ResourceBean || bean instanceof InstanceBean || bean instanceof EventBean || bean instanceof InjectionPointBean || bean instanceof BeanManagerBean) {
            return true;
        }
        if (bean instanceof AbstractProducerBean) {
            Class beanType = ((AbstractProducerBean)bean).getReturnType();
            boolean isFinal = Modifier.isFinal(beanType.getModifiers());
            if (isFinal) {
                return Serializable.class.isAssignableFrom(beanType);
            }
            return true;
        }
        if (this.webBeansContext.getBeanManagerImpl().isNormalScope(bean.getScope())) {
            return true;
        }
        return WebBeansUtil.isPassivationCapable(bean) != null;
    }

    public static void throwRuntimeExceptions(Exception e) {
        if (RuntimeException.class.isAssignableFrom(e.getClass())) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    public static boolean isAnnotatedTypeDecorator(AnnotatedType<?> annotatedType) {
        return annotatedType.isAnnotationPresent(Decorator.class);
    }

    public boolean isAnnotatedTypeDecoratorOrInterceptor(AnnotatedType<?> annotatedType) {
        if (WebBeansUtil.isAnnotatedTypeDecorator(annotatedType) || WebBeansUtil.isAnnotatedTypeInterceptor(annotatedType)) {
            return true;
        }
        if (this.webBeansContext.getInterceptorsManager().isInterceptorEnabled(annotatedType.getJavaClass())) {
            return true;
        }
        return this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(annotatedType.getJavaClass());
    }

    public static boolean isAnnotatedTypeInterceptor(AnnotatedType<?> annotatedType) {
        return annotatedType.isAnnotationPresent(Interceptor.class);
    }

    public <T> ManagedBean<T> defineManagedBean(AnnotatedType<T> type) {
        return this.defineManagedBean(type, true);
    }

    public <T> ManagedBean<T> defineManagedBean(AnnotatedType<T> type, boolean fullProcessing) {
        Class clazz = type.getJavaClass();
        ManagedBean<T> managedBean = new ManagedBean<T>(clazz, WebBeansType.MANAGED, this.webBeansContext);
        managedBean.setAnnotatedType(type);
        AnnotatedTypeBeanCreatorImpl<T> managedBeanCreator = new AnnotatedTypeBeanCreatorImpl<T>(managedBean);
        managedBeanCreator.setAnnotatedType(type);
        managedBeanCreator.defineApiType();
        managedBeanCreator.defineStereoTypes();
        managedBeanCreator.defineScopeType(WebBeansLoggerFacade.getTokenString("TEXT_MB_IMPL") + clazz.getName() + WebBeansLoggerFacade.getTokenString("TEXT_SAME_SCOPE"), false);
        managedBeanCreator.defineSerializable();
        this.setInjectionTargetBeanEnableFlag(managedBean);
        managedBeanCreator.checkCreateConditions();
        managedBeanCreator.defineQualifier();
        managedBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        managedBeanCreator.defineConstructor();
        managedBeanCreator.defineProducerMethods();
        managedBeanCreator.defineProducerFields();
        managedBeanCreator.defineInjectedFields();
        managedBeanCreator.defineInjectedMethods();
        if (fullProcessing) {
            managedBeanCreator.defineObserverMethods();
            this.webBeansContext.getDefinitionUtil().defineDecoratorStack(managedBean);
            this.webBeansContext.getDefinitionUtil().defineBeanInterceptorStack(managedBean);
        }
        managedBeanCreator.defineDisposalMethods();
        return managedBean;
    }

    public void lazyInitializeManagedBean(Class<?> clazz, ManagedBean<?> managedBean, ManagedBeanCreatorImpl<?> managedBeanCreator) {
        managedBeanCreator.defineConstructor();
        managedBeanCreator.defineProducerMethods();
        managedBeanCreator.defineProducerFields();
        managedBeanCreator.defineInjectedFields();
        managedBeanCreator.defineInjectedMethods();
        managedBeanCreator.defineObserverMethods();
        this.webBeansContext.getDefinitionUtil().defineDecoratorStack(managedBean);
        this.webBeansContext.getDefinitionUtil().defineBeanInterceptorStack(managedBean);
        managedBeanCreator.defineDisposalMethods();
    }

    public <T> ManagedBean<T> defineAbstractDecorator(AnnotatedType<T> type) {
        ManagedBean<?> bean = this.defineManagedBean(type);
        Class<?> clazz = this.webBeansContext.getProxyFactory().createAbstractDecoratorProxyClass(bean);
        bean.setConstructor(this.defineConstructor(clazz));
        bean.setIsAbstractDecorator(true);
        return bean;
    }

    public <T> void defineDecorator(AnnotatedType<T> annotatedType) {
        if (this.webBeansContext.getDecoratorsManager().isDecoratorEnabled(annotatedType.getJavaClass())) {
            ManagedBean<T> delegate = null;
            Set methods = annotatedType.getMethods();
            for (AnnotatedMethod methodA : methods) {
                Method method = methodA.getJavaMember();
                if (AnnotationUtil.hasMethodAnnotation(method, Produces.class)) {
                    throw new WebBeansConfigurationException("Decorator class : " + annotatedType.getJavaClass() + " can not have producer methods but it has one with name : " + method.getName());
                }
                if (!AnnotationUtil.hasMethodParameterAnnotation(method, Observes.class)) continue;
                throw new WebBeansConfigurationException("Decorator class : " + annotatedType.getJavaClass() + " can not have observer methods but it has one with name : " + method.getName());
            }
            delegate = Modifier.isAbstract(annotatedType.getJavaClass().getModifiers()) ? this.defineAbstractDecorator(annotatedType) : this.defineManagedBean(annotatedType);
            if (delegate != null) {
                WebBeansDecoratorConfig.configureDecoratorClass(delegate);
            }
        }
    }

    public <T> void defineInterceptor(AnnotatedType<T> annotatedType) {
        Class clazz = annotatedType.getJavaClass();
        if (this.webBeansContext.getInterceptorsManager().isInterceptorEnabled(clazz)) {
            ManagedBean<T> delegate = null;
            this.webBeansContext.getInterceptorUtil().checkAnnotatedTypeInterceptorConditions(annotatedType);
            delegate = this.defineManagedBean(annotatedType);
            if (delegate != null) {
                Set annTypeSet = annotatedType.getAnnotations();
                Annotation[] anns = annTypeSet.toArray(new Annotation[annTypeSet.size()]);
                AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
                this.webBeansContext.getWebBeansInterceptorConfig().configureInterceptorClass(delegate, annotationManager.getInterceptorBindingMetaAnnotations(anns));
            }
        }
    }

    public <X> void checkManagedBeanCondition(AnnotatedType<X> type) throws WebBeansConfigurationException {
        int modifier = type.getJavaClass().getModifiers();
        if (type.isAnnotationPresent(Decorator.class) && type.isAnnotationPresent(Interceptor.class)) {
            throw new WebBeansConfigurationException("Annotated type " + type + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!type.isAnnotationPresent(Decorator.class) && !type.isAnnotationPresent(Interceptor.class)) {
            this.checkManagedWebBeansInterceptorConditions(type);
        }
        if (ClassUtil.isInterface(modifier)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + type.getJavaClass().getName() + " may not defined as interface");
        }
    }

    private <X> void checkManagedWebBeansInterceptorConditions(AnnotatedType<X> type) {
        Annotation[] anns = AnnotationUtil.getAnnotationsFromSet(type.getAnnotations());
        Class clazz = type.getJavaClass();
        boolean hasClassInterceptors = false;
        AnnotationManager annotationManager = this.webBeansContext.getAnnotationManager();
        if (annotationManager.getInterceptorBindingMetaAnnotations(anns).length > 0) {
            hasClassInterceptors = true;
        } else {
            Annotation[] stereoTypes = annotationManager.getStereotypeMetaAnnotations(anns);
            for (Annotation stero : stereoTypes) {
                if (!annotationManager.hasInterceptorBindingMetaAnnotation(stero.annotationType().getDeclaredAnnotations())) continue;
                hasClassInterceptors = true;
                break;
            }
        }
        if (ClassUtil.isFinal(clazz.getModifiers()) && hasClassInterceptors) {
            throw new WebBeansConfigurationException("Final managed bean class with name : " + clazz.getName() + " can not define any InterceptorBindings");
        }
        Set methods = type.getMethods();
        for (AnnotatedMethod methodA : methods) {
            Method method = methodA.getJavaMember();
            int modifiers = method.getModifiers();
            if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(modifiers) || Modifier.isPrivate(modifiers) || !ClassUtil.isFinal(modifiers)) continue;
            if (hasClassInterceptors) {
                throw new WebBeansConfigurationException("Maanged bean class : " + clazz.getName() + " can not define non-static, non-private final methods. Because it is annotated with at least one @InterceptorBinding");
            }
            if (!annotationManager.hasInterceptorBindingMetaAnnotation(AnnotationUtil.getAnnotationsFromSet(methodA.getAnnotations()))) continue;
            throw new WebBeansConfigurationException("Method : " + method.getName() + "in managed bean class : " + clazz.getName() + " can not be defined as non-static, non-private and final . Because it is annotated with at least one @InterceptorBinding");
        }
    }

    private static String format(String template, Object ... args) {
        int placeholderStart;
        template = String.valueOf(template);
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append(']');
        }
        return builder.toString();
    }

    static {
        INSTANCE_TYPE = new TypeLiteral<Instance<?>>(){
            private static final long serialVersionUID = 3555319035805031154L;
        }.getRawType();
        PROVIDER_TYPE = new TypeLiteral<Provider<?>>(){
            private static final long serialVersionUID = -2611190564495920054L;
        }.getRawType();
        EVENT_TYPE = new TypeLiteral<Event<?>>(){
            private static final long serialVersionUID = -1395145871249763477L;
        }.getRawType();
        isScopeTypeNormalCache = Collections.synchronizedMap(new WeakHashMap());
    }
}

