/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.jsf;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.Conversation;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.context.FacesContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.jsf.JSFUtil;

public class ConversationAwareViewHandler
extends ViewHandlerWrapper {
    private static final ThreadLocal<Source> source = new ThreadLocal();
    private final ViewHandler delegate;
    private Boolean owbApplication = null;

    public ConversationAwareViewHandler(ViewHandler delegate) {
        this.delegate = delegate;
    }

    private Source getSource() {
        if (source.get() == null) {
            return Source.ACTION;
        }
        return source.get();
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (!this.isOwbApplication()) {
            return this.delegate.getActionURL(context, viewId);
        }
        String url = this.delegate.getActionURL(context, viewId);
        ConversationManager conversationManager = WebBeansContext.getInstance().getConversationManager();
        Conversation conversation = conversationManager.getConversationBeanReference();
        if (conversation != null && !conversation.isTransient() && !this.getSource().equals((Object)Source.BOOKMARKABLE)) {
            url = JSFUtil.getRedirectViewIdWithCid(url, conversation.getId());
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBookmarkableURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        if (!this.isOwbApplication()) {
            return this.delegate.getBookmarkableURL(context, viewId, parameters, includeViewParams);
        }
        try {
            source.set(Source.BOOKMARKABLE);
            String string = super.getBookmarkableURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getResourceURL(FacesContext context, String path) {
        if (!this.isOwbApplication()) {
            return this.delegate.getResourceURL(context, path);
        }
        try {
            source.set(Source.RESOURCE);
            String string = super.getResourceURL(context, path);
            return string;
        }
        finally {
            source.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedirectURL(FacesContext context, String viewId, Map<String, List<String>> parameters, boolean includeViewParams) {
        if (!this.isOwbApplication()) {
            return this.delegate.getRedirectURL(context, viewId, parameters, includeViewParams);
        }
        try {
            source.set(Source.REDIRECT);
            String string = super.getRedirectURL(context, viewId, parameters, includeViewParams);
            return string;
        }
        finally {
            source.remove();
        }
    }

    private boolean isOwbApplication() {
        if (this.owbApplication == null) {
            this.owbApplication = WebBeansContext.getInstance().getBeanManagerImpl().isInUse();
        }
        return this.owbApplication;
    }

    public ViewHandler getWrapped() {
        return this.delegate;
    }

    private static enum Source {
        ACTION,
        BOOKMARKABLE,
        REDIRECT,
        RESOURCE;

    }
}

