/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.validator;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.beanvalidation.service.BeanValidation;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.webbeans.spi.ValidatorService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyValidatorService
implements ValidatorService {
    private static final TraceComponent TC = Tr.register(LibertyValidatorService.class, (String)"JCDI", null);
    private final AtomicServiceReference<BeanValidation> beanValidation = new AtomicServiceReference("beanValidation");
    static final long serialVersionUID = -4232678438958423668L;

    protected void activate(ComponentContext compcontext) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("Activating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.beanValidation.activate(compcontext);
    }

    protected void deactivate(ComponentContext compcontext) {
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)("Deactivating " + this.getClass().getName()), (Object[])new Object[0]);
        }
        this.beanValidation.deactivate(compcontext);
    }

    protected void setBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidation.setReference(ref);
    }

    protected void unsetBeanValidation(ServiceReference<BeanValidation> ref) {
        this.beanValidation.unsetReference(ref);
    }

    /*
     * WARNING - void declaration
     */
    public Validator getDefaultValidator() {
        BeanValidation beanValidation = (BeanValidation)this.beanValidation.getService();
        if (beanValidation == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Returning a null Validator because the BeanValidation service is not currently unavailable. Is the bean validation feature enabled?", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return beanValidation.getValidator(componentMetaData);
        }
        catch (ValidationException componentMetaData) {
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.ws.webbeans.validator.LibertyValidatorService", (String)"80", (Object)this, (Object[])new Object[0]);
            if (TC.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)TC, (String)("Returning a null Validator: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public ValidatorFactory getDefaultValidatorFactory() {
        BeanValidation beanValidation = (BeanValidation)this.beanValidation.getService();
        if (beanValidation == null) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Returning a null ValidatorFactory because the BeanValidation service is not currently unavailable.  Is the bean validation feature enabled?", (Object[])new Object[0]);
            }
            return null;
        }
        try {
            ComponentMetaData componentMetaData = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
            return beanValidation.getValidatorFactory(componentMetaData);
        }
        catch (ValidationException componentMetaData) {
            FFDCFilter.processException((Throwable)componentMetaData, (String)"com.ibm.ws.webbeans.validator.LibertyValidatorService", (String)"99", (Object)this, (Object[])new Object[0]);
            if (TC.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)TC, (String)("Returning a null ValidatorFactory: " + e.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }
}

