/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webbeans.web.scanner;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.webbeans.impl.scanner.ResourceInjectionBagService;
import com.ibm.ws.webbeans.services.ResourceInjectionBag;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.injectionengine.JNDIEnvironmentRefType;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.Map;
import org.osgi.service.component.ComponentContext;

public class WebResourceInjectionBagService
implements ResourceInjectionBagService {
    private static final TraceComponent tc = Tr.register(WebResourceInjectionBagService.class);

    public void activate(ComponentContext compcontext, Map<String, Object> properties) {
    }

    public void deactivate(ComponentContext compcontext) {
    }

    public ResourceInjectionBag getResourceInjectionBag(Container moduleContainer) {
        ResourceInjectionBag rib = null;
        try {
            WebAppConfiguration config;
            if (moduleContainer != null && (config = (WebAppConfiguration)moduleContainer.adapt(WebAppConfig.class)) != null) {
                rib = new ResourceInjectionBag();
                rib.envEntries = config.getEnvEntries();
                if (rib.envEntries != null) {
                    rib.envEntryValues = config.getEnvEntryValues();
                    rib.envEntryBindings = (Map)config.getAllRefBindings().get(JNDIEnvironmentRefType.EnvEntry);
                }
                rib.resourceRefs = config.getResourceRefs();
                rib.resourceRefBindings = (Map)config.getAllRefBindings().get(JNDIEnvironmentRefType.ResourceRef);
                rib.resourceRefConfigList = config.getResourceRefConfigList(null);
                rib.resourceEnvRefs = config.getResourceEnvRefs();
                rib.resourceEnvRefBindings = (Map)config.getAllRefBindings().get(JNDIEnvironmentRefType.ResourceEnvRef);
                rib.persistenceUnitRefs = config.getPersistenceUnitRefs();
                rib.persistenceContextRefs = config.getPersistenceContextRefs();
                rib.dataSourceDefinitions = config.getDataSources();
                rib.dataSourceDefinitionBindings = (Map)config.getAllRefBindings().get(JNDIEnvironmentRefType.DataSource);
                rib.webServiceRefs = config.getServiceRefs();
                rib.ejbRefs = config.getEJBRefs();
                rib.ejbRefBindings = (Map)config.getAllRefBindings().get(JNDIEnvironmentRefType.EJBRef);
            }
        }
        catch (UnableToAdaptException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Adapting WebAppConfiguation caught exception: " + (Object)((Object)e)), (Object[])new Object[0]);
            }
            rib = null;
        }
        return rib;
    }
}

