/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.servlet;

import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.LibertyContextsService;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.ELContextStore;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;

public class WebBeansConfigurationListener
implements ServletContextListener,
ServletRequestListener,
HttpSessionListener {
    private static final Logger logger = WebBeansLoggerFacade.getLogger(WebBeansConfigurationListener.class);
    protected ContainerLifecycle lifeCycle = null;
    protected FailOverService failoverService = null;
    private final WebBeansContext webBeansContext = WebBeansContext.getInstance();

    public WebBeansConfigurationListener() {
        this.failoverService = (FailOverService)this.webBeansContext.getService(FailOverService.class);
    }

    public void contextInitialized(ServletContextEvent event) {
        this.lifeCycle = (ContainerLifecycle)this.webBeansContext.getService(ContainerLifecycle.class);
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this.lifeCycle != null) {
            this.lifeCycle.stopApplication((Object)event);
            this.lifeCycle = null;
        }
        this.cleanupRequestThreadLocals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDestroyed(ServletRequestEvent event) {
        ELContextStore elStore;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a request : [{0}]", event.getServletRequest().getRemoteAddr());
        }
        if ((elStore = ELContextStore.getInstance((boolean)false)) != null) {
            elStore.destroyELContextStore();
        }
        this.lifeCycle.getContextService().endContext(RequestScoped.class, (Object)event);
        if (this.failoverService != null) {
            ServletRequest request = event.getServletRequest();
            if (request instanceof HttpServletRequest) {
                HttpServletRequest hRequest = (HttpServletRequest)request;
                boolean setInCollabAroundGetSession = false;
                if (request instanceof IExtendedRequest && !((IExtendedRequest)request).getRunningCollaborators()) {
                    setInCollabAroundGetSession = true;
                }
                try {
                    if (setInCollabAroundGetSession) {
                        ((IExtendedRequest)request).setRunningCollaborators(true);
                    }
                    this.failoverService.sessionIsIdle(hRequest.getSession(false));
                }
                finally {
                    if (setInCollabAroundGetSession) {
                        ((IExtendedRequest)request).setRunningCollaborators(false);
                    }
                }
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "could not obtain an HttpServletRequest object");
            }
        }
        this.cleanupRequestThreadLocals();
    }

    private void cleanupRequestThreadLocals() {
        InjectionPointBean.removeThreadLocal();
        LibertyContextsService.removeThreadLocals();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestInitialized(ServletRequestEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a new request : [{0}]", event.getServletRequest().getRemoteAddr());
            }
            ServletRequest req = event.getServletRequest();
            boolean setInCollabAroundStartContext = false;
            if (req instanceof IExtendedRequest && !((IExtendedRequest)req).getRunningCollaborators()) {
                setInCollabAroundStartContext = true;
            }
            try {
                if (setInCollabAroundStartContext) {
                    ((IExtendedRequest)req).setRunningCollaborators(true);
                }
                this.lifeCycle.getContextService().startContext(RequestScoped.class, (Object)event);
            }
            finally {
                if (setInCollabAroundStartContext) {
                    ((IExtendedRequest)req).setRunningCollaborators(false);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0019", (Object[])new Object[]{event.getServletRequest()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Starting a session with session id : [{0}]", event.getSession().getId());
            }
            this.lifeCycle.getContextService().startContext(SessionScoped.class, (Object)event.getSession());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, WebBeansLoggerFacade.constructMessage((String)"ERROR_0020", (Object[])new Object[]{event.getSession()}));
            WebBeansUtil.throwRuntimeExceptions((Exception)e);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Destroying a session with session id : [{0}]", event.getSession().getId());
        }
        if (this.lifeCycle == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Lifecycle was null during call to sessionDestroyed with id " + event.getSession().getId());
            }
            return;
        }
        this.lifeCycle.getContextService().endContext(SessionScoped.class, (Object)event.getSession());
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        conversationManager.destroyConversationContextWithSessionId(event.getSession().getId());
    }
}

