/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import com.ibm.ws.serialization.SerializationService;
import com.ibm.ws.webbeans.impl.service.LibertySingletonService;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javassist.util.proxy.ProxyObjectOutputStream;
import javax.enterprise.context.Conversation;
import javax.enterprise.inject.spi.Bean;
import javax.servlet.http.HttpSession;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ConversationContext;
import org.apache.webbeans.context.LibertyContextsService;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.context.SessionContextManager;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.proxy.javassist.OpenWebBeansClassLoaderProvider;
import org.apache.webbeans.spi.FailOverService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.web.failover.FailOverBag;
import org.apache.webbeans.web.failover.FailOverSessionActivationListener;
import org.apache.webbeans.web.failover.OwbProxyObjectInputStream;
import org.apache.webbeans.web.failover.SerializationHandlerV10;

public class DefaultOwbFailOverService
implements FailOverService {
    private static final Logger LOGGER = WebBeansLoggerFacade.getLogger(DefaultOwbFailOverService.class);
    public static final String CONFIG_IS_SUPPORT_FAILOVER = "org.apache.webbeans.web.failover.issupportfailover";
    public static final String CONFIG_IS_SUPPORT_PASSIVATE = "org.apache.webbeans.web.failover.issupportpassivation";
    public static final String CONFIG_RESOURCES_SERIALIZATION_HANDLER = "org.apache.webbeans.web.failover.resources.serialization.handler.v10";
    public static final String ATTRIBUTE_SESSION_CONTEXT = "sessionContext";
    public static final String ATTRIBUTE_CONVERSATION_CONTEXT_MAP = "conversatzionContextMap";
    private static final String JVM_ID = UUID.randomUUID().toString() + "_" + System.currentTimeMillis();
    private final WebBeansContext webBeansContext = WebBeansContext.currentInstance();
    private final ThreadLocal<Boolean> passivation = new ThreadLocal();
    private boolean supportFailOver;
    private boolean supportPassivation;
    private SerializationHandlerV10 handler;

    public DefaultOwbFailOverService() {
        OpenWebBeansConfiguration config = this.webBeansContext.getOpenWebBeansConfiguration();
        String value = config.getProperty(CONFIG_IS_SUPPORT_FAILOVER);
        if (value != null && value.equalsIgnoreCase("true")) {
            this.supportFailOver = true;
        }
        if ((value = config.getProperty(CONFIG_IS_SUPPORT_PASSIVATE)) != null && value.equalsIgnoreCase("true")) {
            this.supportPassivation = true;
        }
        if (this.supportFailOver || this.supportPassivation) {
            OpenWebBeansClassLoaderProvider.initProxyFactoryClassLoaderProvider();
            value = config.getProperty(CONFIG_RESOURCES_SERIALIZATION_HANDLER);
            if (value != null) {
                try {
                    this.handler = (SerializationHandlerV10)Class.forName(value).newInstance();
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "DefaultOwbFailOverService could not instanciate: [" + value + "]", e);
                }
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "IsSupportFailOver: [{0}]", String.valueOf(this.supportFailOver));
            LOGGER.log(Level.FINE, "IsSupportPassivation: [{0}]", String.valueOf(this.supportPassivation));
        }
    }

    public void sessionIsIdle(HttpSession session) {
        if (session != null) {
            FailOverBag bag = (FailOverBag)session.getAttribute("o.a.owb.FAIL_OVER_BAG");
            if (bag == null) {
                bag = new FailOverBag(session.getId(), this.getJvmId());
            }
            bag.setSessionInUse(false);
            this.storeBeansInFailOverBag(bag, session);
            this.addFailOverBagToSession(bag, session);
            this.addActivationListenerToSession(session);
        }
        this.passivation.remove();
        this.passivation.set(null);
    }

    public void sessionIsInUse(HttpSession session) {
        if (session != null) {
            FailOverBag bag = (FailOverBag)session.getAttribute("o.a.owb.FAIL_OVER_BAG");
            if (bag != null) {
                bag.setSessionInUse(true);
            }
            this.addActivationListenerToSession(session);
        }
    }

    public void sessionDidActivate(HttpSession session) {
        FailOverBag bag = (FailOverBag)session.getAttribute("o.a.owb.FAIL_OVER_BAG");
        if (bag != null) {
            if (bag.isSessionInUse()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Skip restore beans for session [" + bag.getSessionId() + "] because session is in use.");
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Restore beans for session [{0}]", session.getId());
                }
                this.restoreBeansFromFailOverBag(bag, session);
            }
        }
    }

    public void sessionWillPassivate(HttpSession session) {
        this.sessionIsIdle(session);
        this.passivation.set(true);
    }

    protected void addActivationListenerToSession(HttpSession session) {
        if (session.getAttribute("o.a.owb.SESSION_ACTIVATION_LISTENER") == null) {
            session.setAttribute("o.a.owb.SESSION_ACTIVATION_LISTENER", (Object)new FailOverSessionActivationListener());
        }
    }

    protected void addFailOverBagToSession(FailOverBag bag, HttpSession session) {
        try {
            session.setAttribute("o.a.owb.FAIL_OVER_BAG", (Object)bag);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Successfully added FailOverBag to session [" + bag.getSessionId() + "].");
            }
        }
        catch (Exception e) {
            String message = "Could not add FailOverBag to session [" + bag.getSessionId() + "].";
            LOGGER.log(Level.SEVERE, message, e);
            throw new WebBeansException(message, (Throwable)e);
        }
    }

    protected void storeBeansInFailOverBag(FailOverBag bag, HttpSession session) {
        SessionContextManager sessionManager = ((LibertyContextsService)this.webBeansContext.getContextsService()).getSessionContextManager();
        SessionContext sessionContext = sessionManager.getSessionContextWithSessionId(session.getId());
        bag.put(ATTRIBUTE_SESSION_CONTEXT, sessionContext);
        ConversationManager conversationManager = this.webBeansContext.getConversationManager();
        bag.put(ATTRIBUTE_CONVERSATION_CONTEXT_MAP, conversationManager.getConversationMapWithSessionId(session.getId()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Beans for session [" + bag.getSessionId() + "] successfully stored in FailOverBag.");
        }
    }

    protected void restoreBeansFromFailOverBag(FailOverBag bag, HttpSession session) {
        try {
            Map conversationContextMap;
            SessionContext sessionContext = (SessionContext)bag.get(ATTRIBUTE_SESSION_CONTEXT);
            if (sessionContext != null) {
                SessionContextManager sessionManager = ((LibertyContextsService)this.webBeansContext.getContextsService()).getSessionContextManager();
                sessionManager.addNewSessionContext(session.getId(), sessionContext);
                sessionContext.setActive(true);
            }
            if ((conversationContextMap = (Map)bag.get(ATTRIBUTE_CONVERSATION_CONTEXT_MAP)) != null && !conversationContextMap.isEmpty()) {
                ConversationManager conversationManager = this.webBeansContext.getConversationManager();
                for (Conversation conversation : conversationContextMap.keySet()) {
                    ConversationContext context = (ConversationContext)conversationContextMap.get(conversation);
                    conversationManager.addConversationContext(conversation, context);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Beans for session [" + bag.getSessionId() + "] from [" + bag.getJvmId() + "] successfully restored.");
            }
        }
        catch (Exception e) {
            String message = "Could not restore beans for session [" + bag.getSessionId() + "] from [" + bag.getJvmId() + "]";
            LOGGER.log(Level.SEVERE, message, e);
            throw new WebBeansException(message, (Throwable)e);
        }
    }

    public Object handleResource(Bean<?> bean, Object resourceObject, ObjectInput in, ObjectOutput out) {
        if (this.handler != null) {
            return this.handler.handleResource(bean, resourceObject, in, out, this.isPassivation() ? 1 : 0);
        }
        return NOT_HANDLED;
    }

    public ObjectInputStream getObjectInputStream(InputStream in) throws IOException {
        SerializationService ss = LibertySingletonService.getSerializationService();
        ClassLoader cl = WebBeansUtil.getCurrentClassLoader();
        OwbProxyObjectInputStream stream = new OwbProxyObjectInputStream(in);
        ObjectInputStream oStream = ss.createObjectInputStream((InputStream)((Object)stream), cl);
        return oStream;
    }

    public ObjectOutputStream getObjectOutputStream(OutputStream out) throws IOException {
        SerializationService ss = LibertySingletonService.getSerializationService();
        ProxyObjectOutputStream stream = new ProxyObjectOutputStream(out);
        return ss.createObjectOutputStream((OutputStream)stream);
    }

    public String getJvmId() {
        return JVM_ID;
    }

    public boolean isSupportFailOver() {
        return this.supportFailOver;
    }

    public void enableFailOverSupport(boolean supportFailOver) {
        this.supportFailOver = supportFailOver;
    }

    public boolean isSupportPassivation() {
        return this.supportPassivation;
    }

    public void enablePassivationSupport(boolean supportPassivation) {
        this.supportPassivation = supportPassivation;
    }

    public boolean isPassivation() {
        if (this.passivation.get() == null) {
            this.passivation.set(false);
        }
        return this.passivation.get();
    }
}

