/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.failover;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.FailOverService;

public class FailOverBag
implements Serializable,
Externalizable {
    public static final String SESSION_ATTRIBUTE_NAME = "o.a.owb.FAIL_OVER_BAG";
    private static final long serialVersionUID = -6314819837009653190L;
    private final transient FailOverService failOverService;
    private Map<String, Object> items;
    private boolean sessionInUse;
    private String sessionId;
    private String jvmId;

    public FailOverBag() {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        this.failOverService = (FailOverService)webBeansContext.getService(FailOverService.class);
        this.items = new HashMap<String, Object>();
    }

    public FailOverBag(String sessionId, String jvmId) {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        this.failOverService = (FailOverService)webBeansContext.getService(FailOverService.class);
        this.items = new HashMap<String, Object>();
        this.sessionId = sessionId;
        this.jvmId = jvmId;
    }

    public void put(String name, Object item) {
        this.items.put(name, item);
    }

    public Object get(String name) {
        return this.items.get(name);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte[] buffer = (byte[])in.readObject();
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ObjectInputStream ois = this.failOverService.getObjectInputStream((InputStream)bais);
        this.sessionInUse = ois.readBoolean();
        this.sessionId = (String)ois.readObject();
        this.jvmId = (String)ois.readObject();
        this.items = (Map)ois.readObject();
        ois.close();
        bais.close();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = this.failOverService.getObjectOutputStream((OutputStream)baos);
        oos.writeBoolean(this.sessionInUse);
        oos.writeObject(this.sessionId);
        oos.writeObject(this.jvmId);
        oos.writeObject(this.items);
        oos.flush();
        out.writeObject(baos.toByteArray());
        oos.close();
        baos.close();
        out.close();
    }

    public boolean isSessionInUse() {
        return this.sessionInUse;
    }

    public void setSessionInUse(boolean sessionInUse) {
        this.sessionInUse = sessionInUse;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getJvmId() {
        return this.jvmId;
    }

    public void setJvmId(String jvmId) {
        this.jvmId = jvmId;
    }
}

