/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.web.lifecycle;

import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.webbeans.context.CDIMetaData;
import com.ibm.ws.webbeans.services.ResourceInjectionServiceImpl;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.webcontainer.facade.ServletContextFacade;
import com.ibm.wsspi.webcontainer.servlet.IServletContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.LibertyContextsService;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.lifecycle.AbstractLifeCycle;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.web.util.ServletCompatibilityUtil;

public final class WebContainerLifecycle
extends AbstractLifeCycle {
    private ScheduledExecutorService service = null;
    private final String CLASS_NAME = WebContainerLifecycle.class.getName();

    public WebContainerLifecycle() {
        super(null);
        this.logger = WebBeansLoggerFacade.getLogger(WebContainerLifecycle.class);
    }

    public WebContainerLifecycle(WebBeansContext webBeansContext) {
        super(null, webBeansContext);
        this.logger = WebBeansLoggerFacade.getLogger(WebContainerLifecycle.class);
    }

    public void startApplication(Object startupObject) {
        if (!(startupObject instanceof CDIMetaData)) {
            ServletContext servletContext = this.getServletContext(startupObject);
            super.startApplication((Object)servletContext);
        } else {
            super.startApplication(startupObject);
        }
    }

    public void stopApplication(Object endObject) {
        ServletContext servletContext = this.getServletContext(endObject);
        super.stopApplication((Object)servletContext);
        ResourceInjectionService riService = (ResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
        if (riService != null && riService instanceof ResourceInjectionServiceImpl) {
            ResourceInjectionServiceImpl riServiceImpl = (ResourceInjectionServiceImpl)riService;
            riServiceImpl.removeModuleInjectionTargets();
        }
    }

    protected void afterStartApplication(final Object startupObject) {
        final boolean isServletContext = startupObject instanceof ServletContext;
        WebBeansContext webBeansContext = this.getWebBeansContext();
        if (webBeansContext != null && !webBeansContext.isWebAppLifecycleStarted()) {
            String strDelay = "150000";
            strDelay = webBeansContext.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", strDelay);
            long delay = Long.parseLong(strDelay);
            this.service = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(final Runnable runable) {
                    Thread t = AccessController.doPrivileged(new PrivilegedAction<Thread>(){

                        @Override
                        public Thread run() {
                            Thread t = isServletContext ? new Thread(runable, "OwbConversationCleaner-" + ServletCompatibilityUtil.getServletInfo((ServletContext)startupObject)) : new Thread(runable, "OwbConversationCleaner-" + startupObject);
                            t.setDaemon(true);
                            return t;
                        }
                    });
                    return t;
                }
            });
            this.service.scheduleWithFixedDelay(new ConversationCleaner(webBeansContext), delay, delay, TimeUnit.MILLISECONDS);
        }
        if (webBeansContext != null && isServletContext) {
            this.afterStartSetVars((ServletContext)startupObject);
        }
    }

    public void afterStartSetVars(ServletContext ctx) {
        ELAdaptor elAdaptor = (ELAdaptor)this.webBeansContext.getService(ELAdaptor.class);
        ELResolver resolver = elAdaptor.getOwbELResolver();
        if (this.webBeansContext.getOpenWebBeansConfiguration().isJspApplication()) {
            this.logger.log(Level.FINE, "Application is configured as JSP. Adding EL Resolver.");
            JspFactory factory = JspFactory.getDefaultFactory();
            if (factory != null) {
                JspApplicationContext applicationCtx = factory.getJspApplicationContext(ctx);
                applicationCtx.addELResolver(resolver);
            } else {
                this.logger.log(Level.FINE, "Default JSPFactroy instance has not found");
            }
        }
        ServletContext servletContext = ctx;
        servletContext.setAttribute(BeanManager.class.getName(), (Object)this.getBeanManager());
    }

    protected void beforeStartApplication(Object startupObject) {
        WebBeansContext webBeansContext = this.getWebBeansContext();
        if (webBeansContext == null || !webBeansContext.isWebAppLifecycleStarted()) {
            if (startupObject instanceof ServletContext) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.logp(Level.FINE, this.CLASS_NAME, "beforeStartApplication", "scanner service init called using ServletContext object");
                }
                IServletContext servletContext = WebContainerLifecycle.unwrapServletContext((ServletContext)startupObject);
                Container moduleContainer = servletContext.getModuleContainer();
                this.scannerService.init((Object)moduleContainer);
            } else if (startupObject instanceof ModuleInfo) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.logp(Level.FINE, this.CLASS_NAME, "beforeStartApplication", "scanner service init called using ModuleInfo object");
                }
                this.scannerService.init((Object)((ModuleInfo)startupObject).getContainer());
            } else if (this.logger.isLoggable(Level.FINE)) {
                this.logger.logp(Level.FINE, this.CLASS_NAME, "beforeStartApplication", "scanner service init not called since the object is not a ServletContext");
            }
        }
    }

    private static IServletContext unwrapServletContext(ServletContext context) {
        while (context instanceof ServletContextFacade) {
            context = ((ServletContextFacade)context).getIServletContext();
        }
        return (IServletContext)context;
    }

    protected void beforeStopApplication(Object stopObject) {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    protected void afterStopApplication(Object stopObject) {
        ServletContext servletContext = stopObject instanceof ServletContext ? (ServletContext)stopObject : this.getServletContext(stopObject);
        ResourceInjectionService injectionServices = (ResourceInjectionService)this.getWebBeansContext().getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        this.cleanupShutdownThreadLocals();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "INFO_0002", ServletCompatibilityUtil.getServletInfo(servletContext));
        }
    }

    private void cleanupShutdownThreadLocals() {
        InjectionPointBean.removeThreadLocal();
        LibertyContextsService.removeThreadLocals();
    }

    private ServletContext getServletContext(Object object) {
        if (object != null) {
            if (object instanceof ServletContextEvent) {
                object = ((ServletContextEvent)object).getServletContext();
                return (ServletContext)object;
            }
            if (object instanceof ServletContext) {
                return (ServletContext)object;
            }
            throw new WebBeansException(WebBeansLoggerFacade.getTokenString((String)"EXCEPT_0018"));
        }
        throw new IllegalArgumentException("ServletContextEvent object but found null");
    }

    private static class ConversationCleaner
    implements Runnable {
        private final WebBeansContext webBeansContext;

        public ConversationCleaner(WebBeansContext webBeansContext) {
            this.webBeansContext = webBeansContext;
        }

        @Override
        public void run() {
            if (this.webBeansContext != null) {
                this.webBeansContext.getConversationManager().destroyWithRespectToTimout();
            }
        }
    }
}

