/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.aries.application.InvalidAttributeException;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.application.modelling.ModellingManager;
import org.apache.aries.application.modelling.ParsedServiceElements;
import org.apache.aries.application.modelling.ParserProxy;
import org.apache.aries.application.modelling.ServiceModeller;
import org.apache.aries.application.modelling.impl.ParsedServiceElementsImpl;
import org.apache.aries.application.modelling.internal.BundleBlueprintParser;
import org.apache.aries.application.modelling.internal.MessageUtil;
import org.apache.aries.util.filesystem.FileSystem;
import org.apache.aries.util.filesystem.ICloseableDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.io.IOUtils;
import org.apache.aries.util.manifest.BundleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelledResourceManagerImpl
implements ModelledResourceManager {
    private final Logger _logger = LoggerFactory.getLogger(ModelledResourceManagerImpl.class);
    private ParserProxy _parserProxy;
    private ModellingManager _modellingManager;
    private Collection<ServiceModeller> modellingPlugins;

    public void setModellingPlugins(Collection<ServiceModeller> modellingPlugins) {
        this.modellingPlugins = modellingPlugins;
    }

    public void setModellingManager(ModellingManager m) {
        this._modellingManager = m;
    }

    public void setParserProxy(ParserProxy p) {
        this._parserProxy = p;
    }

    public ParserProxy getParserProxy() {
        return this._parserProxy;
    }

    public ParsedServiceElements getServiceElements(IDirectory archive) throws ModellerException {
        BundleManifest bm = BundleManifest.fromBundle((IFile)archive);
        return this.getServiceElements(bm, archive);
    }

    public ParsedServiceElements getServiceElements(ModelledResourceManager.InputStreamProvider archive) throws ModellerException {
        ICloseableDirectory dir = null;
        try {
            dir = FileSystem.getFSRoot((InputStream)archive.open());
            BundleManifest bm = BundleManifest.fromBundle((IFile)dir);
            ParsedServiceElements parsedServiceElements = this.getServiceElements(bm, (IDirectory)dir);
            return parsedServiceElements;
        }
        catch (IOException e) {
            throw new ModellerException((Exception)e);
        }
        finally {
            IOUtils.close((Closeable)dir);
        }
    }

    private ParsedServiceElements getServiceElements(BundleManifest bundleMf, IDirectory archive) throws ModellerException {
        HashSet<ExportedService> services = new HashSet<ExportedService>();
        HashSet<ImportedService> references = new HashSet<ImportedService>();
        try {
            ParsedServiceElements pse = this.getBlueprintServiceElements(bundleMf, this.findBlueprints(bundleMf, archive));
            services.addAll(pse.getServices());
            references.addAll(pse.getReferences());
            for (ServiceModeller sm : this.modellingPlugins) {
                pse = sm.modelServices(bundleMf, archive);
                services.addAll(pse.getServices());
                references.addAll(pse.getReferences());
            }
            return new ParsedServiceElementsImpl(services, references);
        }
        catch (Exception e) {
            throw new ModellerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsedServiceElements getBlueprintServiceElements(BundleManifest bundleMf, Iterable<InputStream> blueprints) throws ModellerException {
        this._logger.debug("Method entry: {}, args {}", (Object)"getServiceElements", (Object)new Object[]{bundleMf, blueprints});
        HashSet services = new HashSet();
        HashSet references = new HashSet();
        try {
            for (InputStream is : blueprints) {
                try {
                    ParsedServiceElements pse = this.getParserProxy().parseAllServiceElements(is);
                    services.addAll(pse.getServices());
                    references.addAll(pse.getReferences());
                }
                finally {
                    IOUtils.close((Closeable)is);
                }
            }
        }
        catch (Exception e) {
            ModellerException m = new ModellerException(e);
            this._logger.debug("Method exit: {}, returning {}", (Object)"getServiceElements", (Object)m);
            throw m;
        }
        ParsedServiceElements result = this._modellingManager.getParsedServiceElements(services, references);
        this._logger.debug("Method exit: {}, returning {}", (Object)"getServiceElements", (Object)result);
        return result;
    }

    public ModelledResource getModelledResource(IDirectory bundle) throws ModellerException {
        try {
            return this.getModelledResource(bundle.toURL().toURI().toString(), bundle);
        }
        catch (MalformedURLException mue) {
            throw new ModellerException((Exception)mue);
        }
        catch (URISyntaxException use) {
            throw new ModellerException((Exception)use);
        }
    }

    public ModelledResource getModelledResource(String uri, ModelledResourceManager.InputStreamProvider bundle) throws ModellerException {
        ICloseableDirectory dir = null;
        try {
            dir = FileSystem.getFSRoot((InputStream)bundle.open());
            ModelledResource modelledResource = this.getModelledResource(uri, (IDirectory)dir);
            return modelledResource;
        }
        catch (IOException e) {
            throw new ModellerException((Exception)e);
        }
        finally {
            IOUtils.close((Closeable)dir);
        }
    }

    public ModelledResource getModelledResource(String uri, IDirectory bundle) throws ModellerException {
        this._logger.debug("Method entry: {}, args {}", (Object)"getModelledResource", (Object)new Object[]{uri, bundle});
        if (bundle != null) {
            BundleManifest bm = BundleManifest.fromBundle((IFile)bundle);
            ParsedServiceElements pse = this.getServiceElements(bm, bundle);
            return this.model(uri, bm, pse);
        }
        ModellerException me = new ModellerException(MessageUtil.getMessage("INVALID_BUNDLE_LOCATION", bundle));
        this._logger.debug("Method exit: {}, returning {}", (Object)"getModelledResource", (Object)me);
        throw me;
    }

    private ModelledResource model(String uri, BundleManifest bm, ParsedServiceElements pse) throws ModellerException {
        Attributes attributes = bm.getRawAttributes();
        ModelledResource mbi = null;
        try {
            mbi = this._modellingManager.getModelledResource(uri, attributes, pse.getReferences(), pse.getServices());
        }
        catch (InvalidAttributeException iae) {
            ModellerException me = new ModellerException((Exception)((Object)iae));
            this._logger.debug("Method exit: {}, returning {}", (Object)"getModelledResource", (Object)me);
            throw me;
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"getModelledResource", (Object)mbi);
        return mbi;
    }

    private Iterable<InputStream> findBlueprints(BundleManifest bundleMf, IDirectory bundle) throws IOException {
        this._logger.debug("Method entry: {}, args {}", (Object)"findBlueprints", (Object)bundle);
        ArrayList<IFile> blueprints = new ArrayList<IFile>();
        BundleBlueprintParser bpParser = new BundleBlueprintParser(bundleMf);
        if (bpParser.mightContainBlueprint()) {
            List files = bundle.listAllFiles();
            for (IFile file : files) {
                String directoryFullPath = file.getName();
                String directoryName = "";
                String fileName = "";
                if (directoryFullPath.lastIndexOf("/") != -1) {
                    int bundleNameLength = bundle.getName().length();
                    directoryName = directoryFullPath.substring(bundleNameLength, directoryFullPath.lastIndexOf("/"));
                    if (directoryName.startsWith("/") && directoryName.length() > 1) {
                        directoryName = directoryName.substring(1);
                    }
                    fileName = directoryFullPath.substring(directoryFullPath.lastIndexOf("/") + 1);
                } else if (file.isFile()) {
                    directoryName = "";
                    fileName = directoryFullPath;
                }
                if (file.isDirectory() || !bpParser.isBPFile(directoryName, fileName)) continue;
                blueprints.add(file);
            }
        }
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        try {
            for (IFile bp : blueprints) {
                result.add(bp.open());
            }
        }
        catch (IOException e) {
            for (InputStream is : result) {
                IOUtils.close((Closeable)is);
            }
            throw e;
        }
        this._logger.debug("Method exit: {}, returning {}", (Object)"findBlueprints", result);
        return result;
    }

    private Iterable<InputStream> findBlueprints(BundleManifest bundleMf, InputStream stream) {
        final BundleBlueprintParser bpParser = new BundleBlueprintParser(bundleMf);
        final ZipInputStream zip = new ZipInputStream(stream);
        return new Iterable<InputStream>(){

            @Override
            public Iterator<InputStream> iterator() {
                return new ZipBlueprintIterator(zip, bpParser);
            }
        };
    }

    private class ZipBlueprintIterator
    implements Iterator<InputStream> {
        private final ZipInputStream zip;
        private final BundleBlueprintParser bpParser;
        private boolean valid;

        public ZipBlueprintIterator(ZipInputStream zip, BundleBlueprintParser bpParser) {
            this.zip = zip;
            this.bpParser = bpParser;
        }

        @Override
        public boolean hasNext() {
            this.valid = false;
            try {
                ZipEntry entry;
                while (!this.valid && (entry = this.zip.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    String name = entry.getName();
                    String directory = "";
                    int index = name.lastIndexOf(47);
                    if (index != -1) {
                        directory = name.substring(0, index);
                        name = name.substring(index + 1);
                    }
                    if (!this.bpParser.isBPFile(directory, name)) continue;
                    this.valid = true;
                }
            }
            catch (IOException e) {
                ModelledResourceManagerImpl.this._logger.error("Could not open next zip entry", (Throwable)e);
            }
            return this.valid;
        }

        @Override
        public InputStream next() {
            if (!this.valid) {
                throw new IllegalStateException();
            }
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return ZipBlueprintIterator.this.zip.read();
                }

                @Override
                public void close() {
                }
            };
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

