/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.modelling.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.aries.application.modelling.ImportedPackage;
import org.apache.aries.application.modelling.utils.impl.ModellingHelperImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageRequirementMerger {
    private final Logger logger = LoggerFactory.getLogger(PackageRequirementMerger.class);
    private final Collection<ImportedPackage> mergedRequirements;
    private final Set<String> invalidRequirements = new HashSet<String>();

    public PackageRequirementMerger(Collection<ImportedPackage> requirements) {
        this.logger.debug("Method entry: {}, args {}", (Object)"PackageRequirementMerger", requirements);
        if (requirements == null) {
            NullPointerException npe = new NullPointerException();
            this.logger.debug("Method exit: {}, returning {}", (Object)"PackageRequirementMerger", (Object)npe);
            throw npe;
        }
        HashMap<String, ImportedPackage> reqMap = new HashMap<String, ImportedPackage>();
        for (ImportedPackage req : requirements) {
            String pkgName = req.getPackageName();
            ImportedPackage existingReq = (ImportedPackage)reqMap.get(pkgName);
            if (existingReq == null) {
                reqMap.put(pkgName, req);
                continue;
            }
            ImportedPackage intersectReq = ModellingHelperImpl.intersectPackage_(req, existingReq);
            if (intersectReq != null) {
                reqMap.put(pkgName, intersectReq);
                continue;
            }
            this.invalidRequirements.add(pkgName);
        }
        this.mergedRequirements = this.invalidRequirements.isEmpty() ? reqMap.values() : null;
        this.logger.debug("Method exit: {}, returning {}", (Object)"PackageRequirementMerger");
    }

    public boolean isMergeSuccessful() {
        this.logger.debug("Method entry: {}, args {}", (Object)"isMergeSuccessful");
        boolean result = this.mergedRequirements != null;
        this.logger.debug("Method exit: {}, returning {}", (Object)"isMergeSuccessful", (Object)result);
        return result;
    }

    public Collection<ImportedPackage> getMergedRequirements() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getMergedRequirements");
        if (this.mergedRequirements == null) {
            IllegalStateException ise = new IllegalStateException();
            this.logger.debug("Method exit: {}, returning {}", (Object)"getMergedRequirements", (Object)ise);
            throw ise;
        }
        this.logger.debug("Method exit: {}, returning {}", (Object)"getMergedRequirements", this.mergedRequirements);
        return Collections.unmodifiableCollection(this.mergedRequirements);
    }

    public Set<String> getInvalidRequirements() {
        this.logger.debug("Method entry: {}, args {}", (Object)"getInvalidRequirements");
        this.logger.debug("Method exit: {}, returning {}", (Object)"getInvalidRequirements", this.invalidRequirements);
        return Collections.unmodifiableSet(this.invalidRequirements);
    }
}

