/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.application.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.aries.application.ApplicationMetadata;
import org.apache.aries.application.Content;
import org.apache.aries.application.ServiceDeclaration;
import org.apache.aries.application.impl.ContentImpl;
import org.apache.aries.application.impl.ServiceDeclarationImpl;
import org.apache.aries.util.manifest.ManifestHeaderProcessor;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationMetadataImpl
implements ApplicationMetadata {
    private static final Logger _logger = LoggerFactory.getLogger((String)"org.apache.aries.application.management.impl");
    private String appSymbolicName;
    private Version appVersion;
    private String appName;
    private String appScope;
    private final List<Content> appContents = new ArrayList<Content>();
    private final List<ServiceDeclaration> importServices;
    private final List<ServiceDeclaration> exportServices;
    private final Manifest manifest;
    private final List<Content> useBundle = new ArrayList<Content>();

    public ApplicationMetadataImpl(Manifest appManifest) {
        this.importServices = new ArrayList<ServiceDeclaration>();
        this.exportServices = new ArrayList<ServiceDeclaration>();
        this.setup(appManifest);
        this.manifest = appManifest;
    }

    private void setup(Manifest appManifest) {
        Map<String, String> appMap = this.readManifestIntoMap(appManifest);
        this.appSymbolicName = appMap.get("Application-SymbolicName");
        this.appVersion = new Version(appMap.get("Application-Version"));
        this.appName = appMap.get("Application-Name");
        this.appScope = this.appSymbolicName + "_" + this.appVersion.toString();
        if (this.appSymbolicName == null || this.appVersion == null) {
            throw new IllegalArgumentException("Failed to create ApplicationMetadataImpl object from Manifest " + appManifest);
        }
        String applicationContents = appMap.get("Application-Content");
        Map appContentsMap = ManifestHeaderProcessor.parseImportString((String)applicationContents);
        for (Map.Entry e : appContentsMap.entrySet()) {
            this.appContents.add(new ContentImpl((String)e.getKey(), (Map)e.getValue()));
        }
        String useBundleStr = appMap.get("Use-Bundle");
        if (useBundleStr != null) {
            Map useBundleMap = ManifestHeaderProcessor.parseImportString((String)useBundleStr);
            for (Map.Entry e : useBundleMap.entrySet()) {
                this.useBundle.add(new ContentImpl((String)e.getKey(), (Map)e.getValue()));
            }
        }
        String allServiceImports = appMap.get("Application-ImportService");
        List serviceImports = ManifestHeaderProcessor.split((String)allServiceImports, (String)",");
        for (String s : serviceImports) {
            try {
                ServiceDeclarationImpl dec = new ServiceDeclarationImpl(s);
                this.importServices.add(dec);
            }
            catch (InvalidSyntaxException ise) {
                _logger.warn("APPUTILS0013E", new Object[]{s, this.appSymbolicName});
            }
        }
        String allServiceExports = appMap.get("Application-ExportService");
        List serviceExports = ManifestHeaderProcessor.split((String)allServiceExports, (String)",");
        for (String s : serviceExports) {
            try {
                ServiceDeclarationImpl dec = new ServiceDeclarationImpl(s);
                this.exportServices.add(dec);
            }
            catch (InvalidSyntaxException ise) {
                _logger.warn("APPUTILS0014E", new Object[]{s, this.appSymbolicName});
            }
        }
    }

    private Map<String, String> readManifestIntoMap(Manifest mf) {
        Set<Map.Entry<Object, Object>> attributeSet;
        HashMap<String, String> props = new HashMap<String, String>();
        Attributes mainAttrs = mf.getMainAttributes();
        if (mainAttrs != null && (attributeSet = mainAttrs.entrySet()) != null) {
            for (Map.Entry<Object, Object> entry : attributeSet) {
                props.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
        }
        return props;
    }

    public List<Content> getApplicationContents() {
        return Collections.unmodifiableList(this.appContents);
    }

    public List<ServiceDeclaration> getApplicationExportServices() {
        return Collections.unmodifiableList(this.exportServices);
    }

    public List<ServiceDeclaration> getApplicationImportServices() {
        return Collections.unmodifiableList(this.importServices);
    }

    public String getApplicationSymbolicName() {
        return this.appSymbolicName;
    }

    public Version getApplicationVersion() {
        return this.appVersion;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public String getApplicationScope() {
        return this.appScope;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof ApplicationMetadataImpl) {
            return this.appScope.equals(((ApplicationMetadataImpl)other).appScope);
        }
        return false;
    }

    public int hashCode() {
        return this.appScope.hashCode();
    }

    public void store(File f) throws IOException {
        FileOutputStream fos = new FileOutputStream(f);
        this.store(fos);
        fos.close();
    }

    public void store(OutputStream out) throws IOException {
        if (this.manifest != null) {
            Attributes att = this.manifest.getMainAttributes();
            if (att.getValue(Attributes.Name.MANIFEST_VERSION.toString()) == null) {
                att.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            }
            this.manifest.write(out);
        }
    }

    public Collection<Content> getUseBundles() {
        return this.useBundle;
    }
}

