/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.util.Collection;
import java.util.Hashtable;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.ContextProvider;
import org.apache.aries.jndi.DelegateContext;
import org.apache.aries.jndi.ServicePair;
import org.apache.aries.jndi.SingleContextProvider;
import org.apache.aries.jndi.URLContextProvider;
import org.apache.aries.jndi.Utils;
import org.apache.aries.jndi.startup.Activator;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class ContextHelper {
    private static final Logger logger = Logger.getLogger(ContextHelper.class.getName());

    private ContextHelper() {
        throw new RuntimeException();
    }

    public static ContextProvider createURLContext(BundleContext context, String urlScheme, Hashtable<?, ?> env) throws NamingException {
        ObjectFactory factory;
        ServicePair<ObjectFactory> urlObjectFactory = ContextHelper.getURLObjectFactory(context, urlScheme, env);
        if (urlObjectFactory != null && (factory = urlObjectFactory.get()) != null) {
            return new URLContextProvider(context, urlObjectFactory.getReference(), factory, env);
        }
        return null;
    }

    public static ServicePair<ObjectFactory> getURLObjectFactory(BundleContext ctx, String urlScheme, Hashtable<?, ?> environment) throws NamingException {
        ServicePair<ObjectFactory> result = null;
        ServiceReference<ObjectFactory> ref = Activator.getUrlFactory(urlScheme);
        if (ref == null) {
            Collection<ServiceReference<URLObjectFactoryFinder>> refs = Activator.getURLObjectFactoryFinderServices();
            for (ServiceReference<URLObjectFactoryFinder> finderRef : refs) {
                ObjectFactory f;
                URLObjectFactoryFinder finder = Activator.getService(ctx, finderRef);
                if (finder == null || (f = finder.findFactory(urlScheme, environment)) == null) continue;
                result = new ServicePair<ObjectFactory>(ctx, finderRef, f);
                break;
            }
        } else {
            result = new ServicePair<ObjectFactory>(ctx, ref);
        }
        return result;
    }

    public static Context getInitialContext(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider;
        Bundle jndiBundle = FrameworkUtil.getBundle(ContextHelper.class);
        if (jndiBundle != null) {
            BundleContext jndiBundleContext = Utils.doPrivileged(() -> ((Bundle)jndiBundle).getBundleContext());
            if (!jndiBundleContext.getClass().equals(context.getClass())) {
                context = jndiBundleContext;
            }
        }
        if ((provider = ContextHelper.getContextProvider(context, environment)) != null) {
            return new DelegateContext(context, provider);
        }
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            return new DelegateContext(context, environment);
        }
        throw new NoInitialContextException("Unable to find the InitialContextFactory " + contextFactoryClass + ".");
    }

    public static ContextProvider getContextProvider(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider = null;
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            provider = ContextHelper.getInitialContextUsingBuilder(context, environment).orElseGet(() -> ContextHelper.getInitialContextUsingFactoryServices(context, environment).orElse(null));
        } else {
            InitialContextFactory factory;
            ServiceReference<InitialContextFactory> ref = Activator.getInitialContextFactory(contextFactoryClass);
            if (ref != null && (factory = Activator.getService(context, ref)) != null) {
                Context initialContext = factory.getInitialContext(environment);
                provider = new SingleContextProvider(context, ref, initialContext);
            }
            if (provider == null) {
                provider = ContextHelper.getInitialContextUsingBuilder(context, environment).orElse(null);
            }
        }
        return provider;
    }

    private static Optional<ContextProvider> getInitialContextUsingFactoryServices(BundleContext context, Hashtable<?, ?> environment) {
        for (ServiceReference<InitialContextFactory> reference : Activator.getInitialContextFactoryServices()) {
            try {
                InitialContextFactory factory = Activator.getService(context, reference);
                Context initialContext = factory.getInitialContext(environment);
                if (initialContext == null) continue;
                return Optional.of(new SingleContextProvider(context, reference, initialContext));
            }
            catch (NamingException e) {
                logger.log(Level.FINE, "Exception caught", e);
            }
        }
        return Optional.empty();
    }

    private static Optional<ContextProvider> getInitialContextUsingBuilder(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        for (ServiceReference<InitialContextFactoryBuilder> ref : Activator.getInitialContextFactoryBuilderServices()) {
            InitialContextFactoryBuilder builder = Activator.getService(context, ref);
            InitialContextFactory factory = null;
            try {
                factory = builder.createInitialContextFactory(environment);
            }
            catch (NamingException ne) {
                logger.log(Level.FINE, "Exception caught", ne);
            }
            catch (NullPointerException npe) {
                logger.log(Level.SEVERE, "NPE caught in ContextHelper.getInitialContextUsingBuilder. context=" + context + " ref=" + ref);
                throw npe;
            }
            if (factory == null) continue;
            return Optional.of(new SingleContextProvider(context, ref, factory.getInitialContext(environment)));
        }
        return Optional.empty();
    }
}

