/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Clause;
import org.apache.aries.subsystem.core.archive.Directive;
import org.apache.aries.subsystem.core.archive.DirectiveFactory;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.ParameterFactory;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.TypedAttribute;
import org.apache.aries.subsystem.core.archive.VersionAttribute;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.osgi.framework.VersionRange;

public abstract class AbstractClause
implements Clause {
    protected final Map<String, Parameter> parameters;
    protected final String path;

    protected static Collection<Parameter> generateDefaultParameters(Parameter ... parameters) {
        if (parameters == null || parameters.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Parameter> defaults = new ArrayList<Parameter>(parameters.length);
        for (Parameter parameter : parameters) {
            defaults.add(parameter);
        }
        return defaults;
    }

    protected static Map<String, Parameter> parseParameters(String clause, boolean replaceVersionWithVersionRange) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        Matcher matcher = Patterns.PARAMETER.matcher(clause);
        while (matcher.find()) {
            Parameter parameter = ParameterFactory.create(matcher.group());
            if (replaceVersionWithVersionRange && parameter instanceof VersionAttribute) {
                parameter = new VersionRangeAttribute(new VersionRange(String.valueOf(parameter.getValue())));
            }
            parameters.put(parameter.getName(), parameter);
        }
        return parameters;
    }

    protected static Map<String, Parameter> parseTypedParameters(String clause) {
        HashMap<String, Parameter> parameters = new HashMap<String, Parameter>();
        Matcher matcher = Patterns.TYPED_PARAMETER.matcher(clause);
        while (matcher.find()) {
            if (":=".equals(matcher.group(2))) {
                parameters.put(matcher.group(1), DirectiveFactory.createDirective(matcher.group(1), AbstractClause.removeQuotes(matcher.group(3))));
                continue;
            }
            if (":".equals(matcher.group(5))) {
                parameters.put(matcher.group(4), new TypedAttribute(matcher.group(4), AbstractClause.removeQuotes(matcher.group(7)), matcher.group(6)));
                continue;
            }
            parameters.put(matcher.group(4), new TypedAttribute(matcher.group(4), AbstractClause.removeQuotes(matcher.group(7)), "String"));
        }
        return parameters;
    }

    protected static String removeQuotes(String value) {
        if (value == null) {
            return null;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    protected static String parsePath(String clause, Pattern pattern, boolean replaceAllWhitespace) {
        Matcher matcher = pattern.matcher(clause);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid path: " + clause);
        }
        String path = matcher.group();
        if (replaceAllWhitespace) {
            path = path.replaceAll("\\s", "");
        }
        return path;
    }

    public AbstractClause(String path, Map<String, Parameter> parameters, Collection<Parameter> defaultParameters) {
        if (path == null) {
            throw new NullPointerException();
        }
        for (Parameter parameter : defaultParameters) {
            String name = parameter.getName();
            if (parameters.containsKey(name)) continue;
            parameters.put(name, parameter);
        }
        this.path = path;
        this.parameters = Collections.synchronizedMap(parameters);
    }

    @Override
    public Attribute getAttribute(String name) {
        Parameter result = this.parameters.get(name);
        if (result instanceof Attribute) {
            return (Attribute)result;
        }
        return null;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(this.parameters.size());
        for (Parameter parameter : this.parameters.values()) {
            if (!(parameter instanceof Attribute)) continue;
            attributes.add((Attribute)parameter);
        }
        attributes.trimToSize();
        return attributes;
    }

    @Override
    public Directive getDirective(String name) {
        Parameter result = this.parameters.get(name);
        if (result instanceof Directive) {
            return (Directive)result;
        }
        return null;
    }

    @Override
    public Collection<Directive> getDirectives() {
        ArrayList<Directive> directives = new ArrayList<Directive>(this.parameters.size());
        for (Parameter parameter : this.parameters.values()) {
            if (!(parameter instanceof Directive)) continue;
            directives.add((Directive)parameter);
        }
        directives.trimToSize();
        return directives;
    }

    @Override
    public Parameter getParameter(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Collection<Parameter> getParameters() {
        return Collections.unmodifiableCollection(this.parameters.values());
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.path.hashCode();
        result = 31 * result + ((Object)this.parameters).hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractClause)) {
            return false;
        }
        AbstractClause that = (AbstractClause)o;
        return that.path.equals(this.path) && ((Object)that.parameters).equals(this.parameters);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.getPath());
        for (Parameter parameter : this.getParameters()) {
            builder.append(';').append(parameter);
        }
        return builder.toString();
    }
}

