/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.DynamicImportPackageRequirement;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.osgi.resource.Resource;

public class DynamicImportPackageHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String ATTRIBUTE_BUNDLE_SYMBOLICNAME = "bundle-symbolic-name";
    public static final String ATTRIBUTE_BUNDLE_VERSION = "bundle-version";
    public static final String ATTRIBUTE_VERSION = "version";
    public static final String NAME = "DynamicImport-Package";

    public DynamicImportPackageHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public DynamicImportPackageHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    @Override
    public String getName() {
        return "Import-Package";
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<DynamicImportPackageRequirement> toRequirements(Resource resource) {
        Collection clauses = this.getClauses();
        ArrayList<DynamicImportPackageRequirement> result = new ArrayList<DynamicImportPackageRequirement>(clauses.size());
        for (Clause clause : clauses) {
            result.addAll(clause.toRequirements(resource));
        }
        return result;
    }

    public static class Clause
    extends AbstractClause {
        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.WILDCARD_NAMES, true), Clause.parseParameters(clause, true), Clause.generateDefaultParameters(VersionRangeAttribute.DEFAULT_VERSION));
        }

        public Collection<String> getPackageNames() {
            return Arrays.asList(this.path.split(";"));
        }

        public VersionRangeAttribute getVersionRangeAttribute() {
            return (VersionRangeAttribute)this.parameters.get(DynamicImportPackageHeader.ATTRIBUTE_VERSION);
        }

        public List<DynamicImportPackageRequirement> toRequirements(Resource resource) {
            Collection<String> pkgs = this.getPackageNames();
            ArrayList<DynamicImportPackageRequirement> result = new ArrayList<DynamicImportPackageRequirement>(pkgs.size());
            for (String pkg : pkgs) {
                result.add(new DynamicImportPackageRequirement(pkg, this, resource));
            }
            return result;
        }
    }
}

