/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.BundleVersionAttribute;
import org.apache.aries.subsystem.core.archive.FragmentHostRequirement;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Resource;

public class FragmentHostHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Fragment-Host";

    public FragmentHostHeader(Collection<Clause> clauses) {
        super(clauses);
        if (clauses.size() != 1) {
            throw new IllegalArgumentException("A Fragment-Host header must have one and only one clause");
        }
    }

    public FragmentHostHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
        if (this.clauses.size() != 1) {
            throw new IllegalArgumentException("A Fragment-Host header must have one and only one clause");
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<FragmentHostRequirement> toRequirements(Resource resource) {
        ArrayList<FragmentHostRequirement> requirements = new ArrayList<FragmentHostRequirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_BUNDLEVERSION = "bundle-version";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SYMBOLIC_NAME, false), Clause.parseParameters(clause, false), Clause.generateDefaultParameters(new BundleVersionAttribute(new VersionRange('[', new Version("0"), null, ')'))));
        }

        public String getSymbolicName() {
            return this.path;
        }

        public FragmentHostRequirement toRequirement(Resource resource) {
            return new FragmentHostRequirement(this, resource);
        }
    }
}

