/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.archive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.aries.subsystem.core.archive.AbstractClause;
import org.apache.aries.subsystem.core.archive.AbstractClauseBasedHeader;
import org.apache.aries.subsystem.core.archive.Attribute;
import org.apache.aries.subsystem.core.archive.Parameter;
import org.apache.aries.subsystem.core.archive.Patterns;
import org.apache.aries.subsystem.core.archive.PreferredProviderRequirement;
import org.apache.aries.subsystem.core.archive.RequirementHeader;
import org.apache.aries.subsystem.core.archive.TypeAttribute;
import org.apache.aries.subsystem.core.archive.VersionRangeAttribute;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.osgi.framework.VersionRange;
import org.osgi.resource.Resource;

public class PreferredProviderHeader
extends AbstractClauseBasedHeader<Clause>
implements RequirementHeader<Clause> {
    public static final String NAME = "Preferred-Provider";

    public PreferredProviderHeader(Collection<Clause> clauses) {
        super(clauses);
    }

    public PreferredProviderHeader(String value) {
        super(value, new AbstractClauseBasedHeader.ClauseFactory<Clause>(){

            @Override
            public Clause newInstance(String clause) {
                return new Clause(clause);
            }
        });
    }

    public boolean contains(Resource resource) {
        for (Clause clause : this.getClauses()) {
            if (!clause.contains(resource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public List<PreferredProviderRequirement> toRequirements(Resource resource) {
        ArrayList<PreferredProviderRequirement> requirements = new ArrayList<PreferredProviderRequirement>(this.clauses.size());
        for (Clause clause : this.clauses) {
            requirements.add(clause.toRequirement(resource));
        }
        return requirements;
    }

    public static class Clause
    extends AbstractClause {
        public static final String ATTRIBUTE_TYPE = "type";
        public static final String ATTRIBUTE_VERSION = "version";

        public Clause(String clause) {
            super(Clause.parsePath(clause, Patterns.SYMBOLIC_NAME, false), Clause.parseParameters(clause, true), Clause.generateDefaultParameters(VersionRangeAttribute.DEFAULT_VERSION, TypeAttribute.newInstance("osgi.subsystem.composite")));
        }

        public boolean contains(Resource resource) {
            return this.getSymbolicName().equals(ResourceHelper.getSymbolicNameAttribute(resource)) && this.getVersionRange().includes(ResourceHelper.getVersionAttribute(resource)) && this.getType().equals(ResourceHelper.getTypeAttribute(resource));
        }

        public String getSymbolicName() {
            return this.path;
        }

        public String getType() {
            return (String)this.getAttribute(ATTRIBUTE_TYPE).getValue();
        }

        public VersionRange getVersionRange() {
            Attribute attribute = this.getAttribute(ATTRIBUTE_VERSION);
            if (attribute instanceof VersionRangeAttribute) {
                return ((VersionRangeAttribute)attribute).getVersionRange();
            }
            return new VersionRange(attribute.getValue().toString());
        }

        public PreferredProviderRequirement toRequirement(Resource resource) {
            return new PreferredProviderRequirement(this, resource);
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.getPath());
            for (Parameter parameter : this.getParameters()) {
                builder.append(';').append(parameter);
            }
            return builder.toString();
        }
    }
}

