/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.application.modelling.ParsedServiceElements;
import org.apache.aries.subsystem.core.internal.BasicCapability;
import org.apache.aries.subsystem.core.internal.BasicRequirement;
import org.apache.aries.subsystem.core.internal.ServiceModeller;
import org.apache.aries.util.filesystem.IDirectory;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.SubsystemException;

public class ApplicationServiceModeller
implements ServiceModeller {
    private final ModelledResourceManager manager;

    public ApplicationServiceModeller(Object manager) {
        this.manager = (ModelledResourceManager)manager;
    }

    @Override
    public ServiceModeller.ServiceModel computeRequirementsAndCapabilities(Resource resource, IDirectory directory) throws SubsystemException {
        try {
            ServiceModelImpl model = new ServiceModelImpl();
            ParsedServiceElements elements = this.manager.getServiceElements(directory);
            for (ExportedService service : elements.getServices()) {
                model.capabilities.add(new BasicCapability.Builder().namespace("osgi.service").attribute("objectClass", new ArrayList(service.getInterfaces())).attributes(service.getServiceProperties()).resource(resource).build());
            }
            for (ExportedService service : elements.getReferences()) {
                StringBuilder builder = new StringBuilder();
                String serviceInterface = service.getInterface();
                String filter = service.getFilter();
                if (serviceInterface != null && filter != null) {
                    builder.append("(&");
                }
                if (serviceInterface != null) {
                    builder.append('(').append("objectClass").append('=').append(serviceInterface).append(')');
                }
                if (filter != null) {
                    builder.append(filter);
                }
                if (serviceInterface != null && filter != null) {
                    builder.append(')');
                }
                if (builder.length() <= 0) continue;
                model.requirements.add(new BasicRequirement.Builder().namespace("osgi.service").directive("filter", builder.toString()).directive("resolution", service.isOptional() ? "optional" : "mandatory").directive("cardinality", service.isMultiple() ? "multiple" : "single").resource(resource).build());
            }
            return model;
        }
        catch (ModellerException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    static class ServiceModelImpl
    implements ServiceModeller.ServiceModel {
        final List<Requirement> requirements = new ArrayList<Requirement>();
        final List<Capability> capabilities = new ArrayList<Capability>();

        ServiceModelImpl() {
        }

        @Override
        public List<Requirement> getServiceRequirements() {
            return this.requirements;
        }

        @Override
        public List<Capability> getServiceCapabilities() {
            return this.capabilities;
        }
    }
}

