/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.repository.Repository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.subsystem.SubsystemException;

public class RepositoryServiceRepository
implements Repository {
    final BundleContext context;

    public RepositoryServiceRepository() {
        this(Activator.getInstance().getBundleContext());
    }

    RepositoryServiceRepository(BundleContext ctx) {
        this.context = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Capability> findProviders(Requirement requirement) {
        ServiceReference[] references;
        HashSet<Capability> result = new HashSet<Capability>();
        try {
            references = this.context.getAllServiceReferences("org.osgi.service.repository.Repository", null);
            if (references == null) {
                return result;
            }
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceReference reference : references) {
            Object repository = this.context.getService(reference);
            if (repository == null) continue;
            try {
                Map map;
                Class<?> repoInterface = null;
                block10: for (Class<?> clazz = repository.getClass(); clazz != null && repoInterface == null; clazz = clazz.getSuperclass()) {
                    for (Class<?> intf : clazz.getInterfaces()) {
                        if (!org.osgi.service.repository.Repository.class.getName().equals(intf.getName())) continue;
                        repoInterface = intf;
                        continue block10;
                    }
                }
                if (repoInterface == null) continue;
                try {
                    Method method = repoInterface.getMethod("findProviders", Collection.class);
                    map = (Map)method.invoke(repository, Collections.singleton(requirement));
                }
                catch (Exception e) {
                    throw new SubsystemException((Throwable)e);
                }
                Collection capabilities = (Collection)map.get(requirement);
                if (capabilities == null) continue;
                result.addAll(capabilities);
            }
            finally {
                this.context.ungetService(reference);
            }
        }
        return result;
    }

    @Override
    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            result.put(requirement, this.findProviders(requirement));
        }
        return result;
    }
}

