/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.aries.subsystem.core.archive.ProvisionPolicyDirective;
import org.apache.aries.subsystem.core.archive.SubsystemContentHeader;
import org.apache.aries.subsystem.core.archive.SubsystemManifest;
import org.apache.aries.subsystem.core.archive.SubsystemTypeHeader;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.BundleRevisionResource;
import org.apache.aries.subsystem.core.internal.ContentRepository;
import org.apache.aries.subsystem.core.internal.DependencyCalculator;
import org.apache.aries.subsystem.core.internal.PreferredProviderRepository;
import org.apache.aries.subsystem.core.internal.RepositoryServiceRepository;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.apache.aries.subsystem.core.internal.SharingPolicyValidator;
import org.apache.aries.subsystem.core.internal.StartAction;
import org.apache.aries.subsystem.core.internal.SubsystemResource;
import org.apache.aries.subsystem.core.internal.Utils;
import org.apache.aries.subsystem.core.repository.Repository;
import org.eclipse.equinox.region.Region;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;
import org.osgi.service.subsystem.Subsystem;

public class ResolveContext
extends org.osgi.service.resolver.ResolveContext {
    private final Repository contentRepository;
    private final Repository localRepository;
    private final Repository preferredProviderRepository;
    private final Repository repositoryServiceRepository;
    private final SubsystemResource resource;
    private final Repository systemRepository;
    private final Map<Resource, Wiring> wirings = this.computeWirings();

    public ResolveContext(SubsystemResource resource) {
        this.resource = resource;
        this.contentRepository = new ContentRepository(resource.getInstallableContent(), resource.getSharedContent());
        this.localRepository = resource.getLocalRepository();
        this.preferredProviderRepository = new PreferredProviderRepository(resource);
        this.repositoryServiceRepository = new RepositoryServiceRepository();
        this.systemRepository = Activator.getInstance().getSystemRepository();
    }

    private void installDependenciesOfRequirerIfNecessary(Requirement requirement) {
        Collection<BasicSubsystem> subsystems;
        if (requirement == null) {
            return;
        }
        Resource requirer = requirement.getResource();
        if (this.resource.equals(requirer)) {
            return;
        }
        if (requirer instanceof BasicSubsystem) {
            BasicSubsystem subsystem = (BasicSubsystem)requirer;
            subsystems = Collections.singletonList(subsystem);
        } else if (requirer instanceof BundleRevision) {
            BundleRevision revision = (BundleRevision)requirer;
            BundleResourceInstaller.BundleConstituent constituent = new BundleResourceInstaller.BundleConstituent(null, revision);
            subsystems = Activator.getInstance().getSubsystems().getSubsystemsByConstituent((Resource)constituent);
        } else {
            return;
        }
        for (BasicSubsystem subsystem : subsystems) {
            if (Utils.isProvisionDependenciesInstall(subsystem) || !Subsystem.State.INSTALLING.equals((Object)subsystem.getState())) continue;
            AccessController.doPrivileged(new StartAction(subsystem, subsystem, subsystem, StartAction.Restriction.INSTALL_ONLY));
        }
    }

    private boolean isResolved(Resource resource) {
        return this.wirings.containsKey(resource);
    }

    private boolean isProcessableAsFragment(Requirement requirement) {
        Resource resource = requirement.getResource();
        String namespace = requirement.getNamespace();
        return Utils.isFragment(resource) && !"osgi.ee".equals(namespace) && !"osgi.wiring.host".equals(namespace);
    }

    private void processAsFragment(Requirement requirement, List<Capability> capabilities) {
        String namespace = requirement.getNamespace();
        Resource fragment = requirement.getResource();
        Wiring fragmentWiring = this.wirings.get(fragment);
        List fragmentWires = fragmentWiring.getRequiredResourceWires("osgi.wiring.host");
        for (Wire fragmentWire : fragmentWires) {
            Resource host = fragmentWire.getProvider();
            Wiring hostWiring = this.wirings.get(host);
            List hostWires = hostWiring.getRequiredResourceWires(namespace);
            this.processWires(hostWires, requirement, capabilities);
        }
    }

    private void processWires(Collection<Wire> wires, Requirement requirement, List<Capability> capabilities) {
        for (Wire wire : wires) {
            this.processWire(wire, requirement, capabilities);
        }
    }

    private void processWire(Wire wire, Requirement requirement, List<Capability> capabilities) {
        if (requirement.equals(wire.getRequirement())) {
            capabilities.add(wire.getCapability());
        }
    }

    private void processCapability(Capability capability, Requirement requirement, List<Capability> capabilities) {
        if (ResourceHelper.matches(requirement, capability)) {
            capabilities.add(capability);
        }
    }

    private void processResourceCapabilities(Collection<Capability> resourceCapabilities, Requirement requirement, List<Capability> capabilities) {
        for (Capability resourceCapability : resourceCapabilities) {
            this.processCapability(resourceCapability, requirement, capabilities);
        }
    }

    private void processAsBundle(Requirement requirement, List<Capability> capabilities) {
        String namespace = requirement.getNamespace();
        Resource bundle = requirement.getResource();
        Wiring wiring = this.wirings.get(bundle);
        List wires = wiring.getRequiredResourceWires(namespace);
        this.processWires(wires, requirement, capabilities);
    }

    private void processAsSubstitutableExport(boolean isFragment, Requirement requirement, List<Capability> capabilities) {
        String namespace = requirement.getNamespace();
        if (!"osgi.wiring.package".equals(namespace)) {
            return;
        }
        Resource resource = requirement.getResource();
        Wiring wiring = this.wirings.get(resource);
        if (isFragment) {
            List fragmentWires = wiring.getRequiredResourceWires("osgi.wiring.host");
            for (Wire fragmentWire : fragmentWires) {
                Resource host = fragmentWire.getProvider();
                this.processResourceCapabilities(this.wirings.get(host).getResourceCapabilities(namespace), requirement, capabilities);
            }
        } else {
            List resourceCapabilities = wiring.getResourceCapabilities(namespace);
            this.processResourceCapabilities(resourceCapabilities, requirement, capabilities);
        }
    }

    private void processAlreadyResolvedResource(Resource resource, Requirement requirement, List<Capability> capabilities) {
        boolean isFragment = this.isProcessableAsFragment(requirement);
        if (isFragment) {
            this.processAsFragment(requirement, capabilities);
        } else {
            this.processAsBundle(requirement, capabilities);
        }
        if (capabilities.isEmpty() && Utils.isMandatory(requirement)) {
            this.processAsSubstitutableExport(isFragment, requirement, capabilities);
            if (capabilities.isEmpty()) {
                capabilities.add(new DependencyCalculator.MissingCapability(requirement));
            }
        }
    }

    private void processNewlyResolvedResource(Resource resource, Requirement requirement, List<Capability> capabilities) {
        try {
            if ("osgi.ee".equals(requirement.getNamespace()) || "osgi.native".equals(requirement.getNamespace())) {
                this.addDependenciesFromSystemRepository(requirement, capabilities);
            } else {
                this.addDependenciesFromContentRepository(requirement, capabilities);
                this.addDependenciesFromPreferredProviderRepository(requirement, capabilities);
                this.addDependenciesFromSystemRepository(requirement, capabilities);
                this.addDependenciesFromLocalRepository(requirement, capabilities);
                if (capabilities.isEmpty()) {
                    this.addDependenciesFromRepositoryServiceRepositories(requirement, capabilities);
                }
            }
            if (capabilities.isEmpty()) {
                String resolution = (String)requirement.getDirectives().get("resolution");
                if ("optional".equals(resolution)) {
                    capabilities.add(new DependencyCalculator.MissingCapability(requirement));
                } else if (this.isResolved(requirement.getResource())) {
                    capabilities.add(new DependencyCalculator.MissingCapability(requirement));
                }
            }
        }
        catch (Throwable t) {
            Utils.handleTrowable(t);
        }
    }

    public List<Capability> findProviders(Requirement requirement) {
        ArrayList<Capability> capabilities = new ArrayList<Capability>();
        Resource resource = requirement.getResource();
        if (this.isResolved(resource) && Utils.isEffectiveResolve(requirement)) {
            this.processAlreadyResolvedResource(resource, requirement, capabilities);
        } else {
            this.installDependenciesOfRequirerIfNecessary(requirement);
            this.processNewlyResolvedResource(resource, requirement, capabilities);
        }
        capabilities.trimToSize();
        return capabilities;
    }

    public int insertHostedCapability(List<Capability> capabilities, HostedCapability hostedCapability) {
        int sz = capabilities.size();
        capabilities.add(sz, (Capability)hostedCapability);
        return sz;
    }

    public boolean isEffective(Requirement requirement) {
        return true;
    }

    public Collection<Resource> getMandatoryResources() {
        return this.resource.getMandatoryResources();
    }

    public Collection<Resource> getOptionalResources() {
        return this.resource.getOptionalResources();
    }

    public Map<Resource, Wiring> getWirings() {
        return Collections.emptyMap();
    }

    private boolean addDependencies(Repository repository, Requirement requirement, List<Capability> capabilities, boolean validate) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (repository == null) {
            return false;
        }
        Map<Requirement, Collection<Capability>> m = repository.findProviders(Collections.singleton(requirement));
        if (m.containsKey(requirement)) {
            Collection<Capability> cc = m.get(requirement);
            this.addValidCapabilities(cc, capabilities, requirement, validate);
        }
        return !capabilities.isEmpty();
    }

    private boolean addDependenciesFromContentRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.contentRepository, requirement, capabilities, false);
    }

    private boolean addDependenciesFromLocalRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.localRepository, requirement, capabilities, true);
    }

    private boolean addDependenciesFromPreferredProviderRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.preferredProviderRepository, requirement, capabilities, true);
    }

    private boolean addDependenciesFromRepositoryServiceRepositories(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        return this.addDependencies(this.repositoryServiceRepository, requirement, capabilities, true);
    }

    private boolean addDependenciesFromSystemRepository(Requirement requirement, List<Capability> capabilities) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        boolean result = this.addDependencies(this.systemRepository, requirement, capabilities, true);
        return result;
    }

    private void addValidCapabilities(Collection<Capability> from, Collection<Capability> to, Requirement requirement, boolean validate) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        for (Capability c : from) {
            if (validate && !this.isValid(c, requirement)) continue;
            to.add(c);
        }
    }

    private void addWiring(Resource resource, Map<Resource, Wiring> wirings) {
        BundleRevision br;
        BundleWiring wiring;
        if (resource instanceof BundleResourceInstaller.BundleConstituent) {
            BundleResourceInstaller.BundleConstituent bc = (BundleResourceInstaller.BundleConstituent)resource;
            BundleWiring wiring2 = bc.getWiring();
            if (wiring2 != null) {
                wirings.put((Resource)bc.getBundle().adapt(BundleRevision.class), (Wiring)wiring2);
            }
        } else if (resource instanceof BundleRevision && (wiring = (br = (BundleRevision)resource).getWiring()) != null) {
            wirings.put((Resource)br, (Wiring)wiring);
        }
    }

    private Map<Resource, Wiring> computeWirings() {
        HashMap<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();
        for (BasicSubsystem subsystem : Activator.getInstance().getSubsystems().getSubsystems()) {
            for (Resource constituent : subsystem.getConstituents()) {
                this.addWiring(constituent, wirings);
            }
        }
        return Collections.unmodifiableMap(wirings);
    }

    private boolean isContent(Resource resource) {
        return this.resource.isContent(resource);
    }

    private boolean isInstallable(Resource resource) {
        return !this.isShared(resource);
    }

    private boolean isShared(Resource resource) {
        return Utils.isSharedResource(resource);
    }

    private boolean isValid(Capability capability, Requirement requirement) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if ("osgi.identity".equals(capability.getNamespace())) {
            return true;
        }
        Resource provider = capability.getResource();
        Resource requirer = requirement.getResource();
        SubsystemManifest manifest = this.resource.getSubsystemManifest();
        SubsystemContentHeader header = manifest.getSubsystemContentHeader();
        if (header.contains(provider) && header.contains(requirer)) {
            return true;
        }
        Region from = this.findRegionForCapabilityValidation(provider);
        Region to = this.findRegionForCapabilityValidation(requirer);
        return new SharingPolicyValidator(from, to).isValid(capability);
    }

    private boolean isAcceptDependencies() {
        SubsystemManifest manifest = this.resource.getSubsystemManifest();
        SubsystemTypeHeader header = manifest.getSubsystemTypeHeader();
        ProvisionPolicyDirective directive = header.getProvisionPolicyDirective();
        return directive.isAcceptDependencies();
    }

    private Region findRegionForCapabilityValidation(Resource resource) throws BundleException, IOException, InvalidSyntaxException, URISyntaxException {
        if (this.isInstallable(resource)) {
            if (this.isContent(resource) || this.isAcceptDependencies()) {
                if (this.resource.isComposite()) {
                    return this.resource.getRegion();
                }
                BasicSubsystem parent = this.resource.getParents().iterator().next();
                if (parent.getSubsystemManifest().getSubsystemTypeHeader().getProvisionPolicyDirective().isAcceptDependencies()) {
                    return parent.getRegion();
                }
                parent = Utils.findFirstScopedAncestorWithSharingPolicy(this.resource);
                return parent.getRegion();
            }
            return Utils.findFirstSubsystemAcceptingDependenciesStartingFrom(this.resource.getParents().iterator().next()).getRegion();
        }
        if (Utils.isBundle(resource)) {
            if (this.isContent(resource) && this.resource.getSubsystemManifest().getSubsystemTypeHeader().getAriesProvisionDependenciesDirective().isResolve()) {
                return Utils.findFirstScopedAncestorWithSharingPolicy(this.resource).getRegion();
            }
            BundleRevision revision = resource instanceof BundleRevision ? (BundleRevision)resource : ((BundleRevisionResource)resource).getRevision();
            return Activator.getInstance().getRegionDigraph().getRegion(revision.getBundle());
        }
        if (this.resource.getSubsystemManifest().getSubsystemTypeHeader().getAriesProvisionDependenciesDirective().isResolve()) {
            return Utils.findFirstScopedAncestorWithSharingPolicy(this.resource).getRegion();
        }
        return Activator.getInstance().getSubsystems().getSubsystemsReferencing(resource).iterator().next().getRegion();
    }
}

