/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.UnexpectedTypeException;
import javax.validation.Valid;
import javax.validation.ValidationException;
import javax.validation.groups.Default;
import org.apache.bval.jsr303.AnnotationConstraintBuilder;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.AppendValidation;
import org.apache.bval.jsr303.AppendValidationToBuilder;
import org.apache.bval.jsr303.ConstraintAnnotationAttributes;
import org.apache.bval.jsr303.util.ConstraintDefinitionValidator;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationProcessor {
    private final ApacheFactoryContext factoryContext;

    public AnnotationProcessor(ApacheFactoryContext factoryContext) {
        this.factoryContext = factoryContext;
    }

    public boolean processAnnotations(MetaProperty prop, Class<?> owner, AnnotatedElement element, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        boolean changed = false;
        for (Annotation annotation : element.getDeclaredAnnotations()) {
            changed |= this.processAnnotation(annotation, prop, owner, access, appender);
        }
        return changed;
    }

    public final <A extends Annotation> boolean processAnnotation(A annotation, Class<?> owner, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        return this.processAnnotation(annotation, null, owner, null, appender);
    }

    public <A extends Annotation> boolean processAnnotation(A annotation, MetaProperty prop, Class<?> owner, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        if (annotation instanceof Valid) {
            return this.addAccessStrategy(prop, access);
        }
        Constraint vcAnno = annotation.annotationType().getAnnotation(Constraint.class);
        if (vcAnno != null) {
            ConstraintDefinitionValidator.validateConstraintDefinition(annotation);
            Class<ConstraintValidator<A, ?>>[] validatorClasses = this.findConstraintValidatorClasses(annotation, vcAnno);
            return this.applyConstraint(annotation, validatorClasses, prop, owner, access, appender);
        }
        Object result = SecureActions.getAnnotationValue(annotation, ConstraintAnnotationAttributes.VALUE.getAttributeName());
        if (result instanceof Annotation[]) {
            boolean changed = false;
            for (Annotation each : (Annotation[])result) {
                changed |= this.processAnnotation(each, prop, owner, access, appender);
            }
            return changed;
        }
        return false;
    }

    public boolean addAccessStrategy(MetaProperty prop, AccessStrategy access) {
        if (prop == null) {
            return false;
        }
        Object[] strategies = (AccessStrategy[])prop.getFeature("refCascade");
        if (strategies == null) {
            strategies = new AccessStrategy[]{access};
            prop.putFeature("refCascade", strategies);
        } else if (!ArrayUtils.contains((Object[])strategies, (Object)access)) {
            prop.putFeature("refCascade", ArrayUtils.add((Object[])strategies, (Object)access));
        }
        return true;
    }

    private <A extends Annotation> Class<? extends ConstraintValidator<A, ?>>[] findConstraintValidatorClasses(A annotation, Constraint vcAnno) {
        if (vcAnno == null) {
            vcAnno = annotation.annotationType().getAnnotation(Constraint.class);
        }
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Class<ConstraintValidator<? extends Annotation, ?>>[] validatorClasses = this.factoryContext.getFactory().getConstraintsCache().getConstraintValidators(annotationType);
        if (validatorClasses == null && (validatorClasses = vcAnno.validatedBy()).length == 0) {
            validatorClasses = this.factoryContext.getFactory().getDefaultConstraints().getValidatorClasses(annotationType);
        }
        return validatorClasses;
    }

    private <A extends Annotation> boolean applyConstraint(A annotation, Class<? extends ConstraintValidator<A, ?>>[] constraintClasses, MetaProperty prop, Class<?> owner, AccessStrategy access, AppendValidation appender) throws IllegalAccessException, InvocationTargetException {
        ConstraintValidator validator = this.getConstraintValidator(annotation, constraintClasses, owner, access);
        AnnotationConstraintBuilder<A> builder = new AnnotationConstraintBuilder<A>(constraintClasses, validator, annotation, owner, access);
        if (prop != null && prop.getParentMetaBean() != null) {
            MetaBean parentMetaBean = prop.getParentMetaBean();
            if (builder.getConstraintValidation().getOwner().isInterface() && parentMetaBean.getBeanClass() != builder.getConstraintValidation().getOwner() && builder.getConstraintValidation().getGroups().size() == 1 && builder.getConstraintValidation().getGroups().contains(Default.class)) {
                Set<Class<?>> groups = builder.getConstraintValidation().getGroups();
                groups.add(builder.getConstraintValidation().getOwner());
                builder.getConstraintValidation().setGroups(groups);
            }
        }
        if (appender instanceof AppendValidationToBuilder) {
            AppendValidationToBuilder avb = (AppendValidationToBuilder)appender;
            builder.getConstraintValidation().setGroups(avb.getInheritedGroups());
            builder.getConstraintValidation().setPayload(avb.getInheritedPayload());
        }
        this.processAnnotations(prop, owner, annotation.annotationType(), access, new AppendValidationToBuilder(builder));
        appender.append(builder.getConstraintValidation());
        return true;
    }

    private <A extends Annotation, T> ConstraintValidator<A, ? super T> getConstraintValidator(A annotation, Class<? extends ConstraintValidator<A, ?>>[] constraintClasses, Class<?> owner, AccessStrategy access) {
        if (constraintClasses != null && constraintClasses.length > 0) {
            Type type = AnnotationProcessor.determineTargetedType(owner, access);
            Map<Type, Class<ConstraintValidator<A, ?>>> validatorTypes = AnnotationProcessor.getValidatorsTypes(constraintClasses);
            ArrayList<Type> assignableTypes = new ArrayList<Type>(constraintClasses.length);
            AnnotationProcessor.fillAssignableTypes(type, validatorTypes.keySet(), assignableTypes);
            AnnotationProcessor.reduceAssignableTypes(assignableTypes);
            AnnotationProcessor.checkOneType(assignableTypes, type, owner, annotation, access);
            ConstraintValidator validator = this.factoryContext.getFactory().getConstraintValidatorFactory().getInstance(validatorTypes.get(assignableTypes.get(0)));
            if (validator == null) {
                throw new ValidationException("Factory returned null validator for: " + validatorTypes.get(assignableTypes.get(0)));
            }
            return validator;
        }
        return null;
    }

    private static void checkOneType(List<Type> types, Type targetType, Class<?> owner, Annotation anno, AccessStrategy access) {
        if (types.isEmpty()) {
            StringBuilder buf = new StringBuilder().append("No validator could be found for type ").append(AnnotationProcessor.stringForType(targetType)).append(". See: @").append(anno.annotationType().getSimpleName()).append(" at ").append(AnnotationProcessor.stringForLocation(owner, access));
            throw new UnexpectedTypeException(buf.toString());
        }
        if (types.size() > 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("Ambiguous validators for type ");
            buf.append(AnnotationProcessor.stringForType(targetType));
            buf.append(". See: @").append(anno.annotationType().getSimpleName()).append(" at ").append(AnnotationProcessor.stringForLocation(owner, access));
            buf.append(". Validators are: ");
            boolean comma = false;
            for (Type each : types) {
                if (comma) {
                    buf.append(", ");
                }
                comma = true;
                buf.append(each);
            }
            throw new UnexpectedTypeException(buf.toString());
        }
    }

    private static Type determineTargetedType(Class<?> owner, AccessStrategy access) {
        if (access == null) {
            return owner;
        }
        Type type = access.getJavaType();
        if (type == null) {
            return Object.class;
        }
        if (type instanceof Class) {
            type = ClassUtils.primitiveToWrapper((Class)((Class)type));
        }
        return type;
    }

    private static String stringForType(Type clazz) {
        if (clazz instanceof Class) {
            if (((Class)clazz).isArray()) {
                return ((Class)clazz).getComponentType().getName() + "[]";
            }
            return ((Class)clazz).getName();
        }
        return clazz.toString();
    }

    private static String stringForLocation(Class<?> owner, AccessStrategy access) {
        if (access != null) {
            return access.toString();
        }
        return owner.getName();
    }

    private static void fillAssignableTypes(Type type, Set<Type> validatorsTypes, List<Type> suitableTypes) {
        for (Type validatorType : validatorsTypes) {
            if (!TypeUtils.isAssignable((Type)type, (Type)validatorType) || suitableTypes.contains(validatorType)) continue;
            suitableTypes.add(validatorType);
        }
    }

    private static void reduceAssignableTypes(List<Type> assignableTypes) {
        boolean removed;
        if (assignableTypes.size() <= 1) {
            return;
        }
        do {
            removed = false;
            Type type = assignableTypes.get(0);
            for (int i = 1; i < assignableTypes.size(); ++i) {
                Type nextType = assignableTypes.get(i);
                if (TypeUtils.isAssignable((Type)nextType, (Type)type)) {
                    assignableTypes.remove(0);
                    --i;
                    removed = true;
                    continue;
                }
                if (!TypeUtils.isAssignable((Type)type, (Type)nextType)) continue;
                assignableTypes.remove(i--);
                removed = true;
            }
        } while (removed && assignableTypes.size() > 1);
    }

    private static <A extends Annotation> Map<Type, Class<? extends ConstraintValidator<A, ?>>> getValidatorsTypes(Class<? extends ConstraintValidator<A, ?>>[] constraintValidatorClasses) {
        HashMap validatorsTypes = new HashMap();
        for (Class<ConstraintValidator<A, ?>> clazz : constraintValidatorClasses) {
            Type componentType;
            Class<?> validatedType = (Class<?>)TypeUtils.getTypeArguments(clazz, ConstraintValidator.class).get(ConstraintValidator.class.getTypeParameters()[1]);
            if (validatedType == null) {
                throw new ValidationException(String.format("Could not detect validated type for %s", clazz));
            }
            if (validatedType instanceof GenericArrayType && (componentType = TypeUtils.getArrayComponentType((Type)validatedType)) instanceof Class) {
                validatedType = Array.newInstance((Class)componentType, 0).getClass();
            }
            validatorsTypes.put(validatedType, clazz);
        }
        return validatorsTypes;
    }
}

