/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import org.apache.bval.IntrospectorMetaBeanFactory;
import org.apache.bval.MetaBeanBuilder;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.MetaBeanFinder;
import org.apache.bval.MetaBeanManager;
import org.apache.bval.jsr303.ApacheValidatorFactory;
import org.apache.bval.jsr303.ClassValidator;
import org.apache.bval.jsr303.Jsr303MetaBeanFactory;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.util.PrivilegedActions;
import org.apache.bval.xml.XMLMetaBeanBuilder;
import org.apache.bval.xml.XMLMetaBeanFactory;
import org.apache.bval.xml.XMLMetaBeanManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.ConstructorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheFactoryContext
implements ValidatorContext {
    private final ApacheValidatorFactory factory;
    private final MetaBeanFinder metaBeanFinder;
    private MessageInterpolator messageInterpolator;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;

    public ApacheFactoryContext(ApacheValidatorFactory factory) {
        this.factory = factory;
        this.metaBeanFinder = this.buildMetaBeanFinder();
    }

    protected ApacheFactoryContext(ApacheValidatorFactory factory, MetaBeanFinder metaBeanFinder) {
        this.factory = factory;
        this.metaBeanFinder = metaBeanFinder;
    }

    public ApacheValidatorFactory getFactory() {
        return this.factory;
    }

    public final MetaBeanFinder getMetaBeanFinder() {
        return this.metaBeanFinder;
    }

    public ValidatorContext messageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
        return this;
    }

    public ValidatorContext traversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
        return this;
    }

    public ValidatorContext constraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
        return this;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory == null ? this.factory.getConstraintValidatorFactory() : this.constraintValidatorFactory;
    }

    public Validator getValidator() {
        ClassValidator validator = new ClassValidator(this);
        if (Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.treat-maps-like-beans"))) {
            validator.setTreatMapsLikeBeans(true);
        }
        return validator;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator == null ? this.factory.getMessageInterpolator() : this.messageInterpolator;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver == null ? this.factory.getTraversableResolver() : this.traversableResolver;
    }

    protected MetaBeanFinder buildMetaBeanFinder() {
        boolean enableMetaBeansXml;
        String[] factoryClassNames;
        ArrayList<MetaBeanFactory> builders = new ArrayList<MetaBeanFactory>();
        if (Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-introspector"))) {
            builders.add(new IntrospectorMetaBeanFactory());
        }
        if ((factoryClassNames = StringUtils.split((String)this.factory.getProperties().get("apache.bval.metabean-factory-classnames"))) != null) {
            for (String clsName : factoryClassNames) {
                Class<?> factoryClass = this.loadClass(clsName);
                builders.add((MetaBeanFactory)this.createMetaBeanFactory(factoryClass));
            }
        }
        boolean jsr303Found = false;
        for (MetaBeanFactory builder : builders) {
            jsr303Found |= builder instanceof Jsr303MetaBeanFactory;
        }
        if (!jsr303Found) {
            builders.add(new Jsr303MetaBeanFactory(this));
        }
        if (enableMetaBeansXml = Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-metabeans-xml"))) {
            XMLMetaBeanManagerCreator.addFactory(builders);
        }
        return this.createMetaBeanManager(builders);
    }

    protected MetaBeanFinder createMetaBeanManager(List<MetaBeanFactory> builders) {
        if (Boolean.parseBoolean(this.factory.getProperties().get("apache.bval.enable-metabeans-xml"))) {
            return XMLMetaBeanManagerCreator.createXMLMetaBeanManager(builders);
        }
        return new MetaBeanManager(new MetaBeanBuilder(builders.toArray(new MetaBeanFactory[builders.size()])));
    }

    private <F extends MetaBeanFactory> F createMetaBeanFactory(final Class<F> cls) {
        return (F)((MetaBeanFactory)PrivilegedActions.run(new PrivilegedAction<F>(){

            @Override
            public F run() {
                try {
                    Constructor c = ConstructorUtils.getMatchingAccessibleConstructor((Class)cls, (Class[])new Class[]{ApacheFactoryContext.this.getClass()});
                    if (c != null) {
                        return (MetaBeanFactory)c.newInstance(ApacheFactoryContext.this);
                    }
                    c = ConstructorUtils.getMatchingAccessibleConstructor((Class)cls, (Class[])new Class[]{ApacheFactoryContext.this.getFactory().getClass()});
                    if (c != null) {
                        return (MetaBeanFactory)c.newInstance(ApacheFactoryContext.this.getFactory());
                    }
                    return (MetaBeanFactory)cls.newInstance();
                }
                catch (Exception e) {
                    throw new ValidationException((Throwable)e);
                }
            }
        }));
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    private Class<?> loadClass(String className) {
        ClassLoader loader = ApacheFactoryContext.doPrivileged(SecureActions.getContextClassLoader());
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException ex) {
            throw new ValidationException("Unable to load class: " + className, (Throwable)ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class XMLMetaBeanManagerCreator {
        private XMLMetaBeanManagerCreator() {
        }

        static void addFactory(List<MetaBeanFactory> builders) {
            builders.add((MetaBeanFactory)new XMLMetaBeanFactory());
        }

        protected static MetaBeanManager createXMLMetaBeanManager(List<MetaBeanFactory> builders) {
            return new XMLMetaBeanManager(new XMLMetaBeanBuilder(builders.toArray(new MetaBeanFactory[builders.size()])));
        }
    }
}

