/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.resolver;

import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.validation.Path;
import javax.validation.TraversableResolver;
import org.apache.bval.jsr303.resolver.CachingRelevant;
import org.apache.bval.jsr303.resolver.CachingTraversableResolver;
import org.apache.bval.jsr303.util.ClassHelper;
import org.apache.bval.util.PrivilegedActions;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTraversableResolver
implements TraversableResolver,
CachingRelevant {
    private static final Logger log = LoggerFactory.getLogger(DefaultTraversableResolver.class);
    private static final String PERSISTENCE_UTIL_CLASSNAME = "javax.persistence.PersistenceUtil";
    private static final String JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME = "org.apache.bval.jsr303.resolver.JPATraversableResolver";
    private TraversableResolver jpaTR;

    public DefaultTraversableResolver() {
        this.initJpa();
    }

    public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isReachable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
        return this.jpaTR == null || this.jpaTR.isCascadable(traversableObject, traversableProperty, rootBeanType, pathToTraversableObject, elementType);
    }

    private void initJpa() {
        ClassLoader classLoader = DefaultTraversableResolver.getClassLoader();
        try {
            PrivilegedActions.getUtilClass(classLoader, PERSISTENCE_UTIL_CLASSNAME);
            log.debug("Found {} on classpath.", (Object)PERSISTENCE_UTIL_CLASSNAME);
        }
        catch (Exception e) {
            log.debug("Cannot find {} on classpath. All properties will per default be traversable.", (Object)PERSISTENCE_UTIL_CLASSNAME);
            return;
        }
        try {
            Class jpaAwareResolverClass = ClassUtils.getClass((ClassLoader)classLoader, (String)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME, (boolean)true);
            this.jpaTR = (TraversableResolver)jpaAwareResolverClass.newInstance();
            log.debug("Instantiated an instance of {}.", (Object)JPA_AWARE_TRAVERSABLE_RESOLVER_CLASSNAME);
        }
        catch (Exception e) {
            log.warn("Unable to load or instanciate JPA aware resolver org.apache.bval.jsr303.resolver.JPATraversableResolver. All properties will per default be traversable.", (Throwable)e);
        }
    }

    @Override
    public boolean needsCaching() {
        return this.jpaTR != null && CachingTraversableResolver.needsCaching(this.jpaTR);
    }

    private static ClassLoader getClassLoader() {
        return System.getSecurityManager() == null ? DefaultTraversableResolver.getClassLoader0() : AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return DefaultTraversableResolver.getClassLoader0();
            }
        });
    }

    private static ClassLoader getClassLoader0() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader != null ? loader : ClassHelper.class.getClassLoader();
    }
}

