/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.model;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.bval.model.Validation;
import org.apache.commons.lang3.ArrayUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeaturesCapable
implements Serializable {
    private static final long serialVersionUID = -4045110242904814218L;
    private ConcurrentMap<String, Object> features = this.createFeaturesMap();
    private Validation[] validations = new Validation[0];
    private volatile boolean locking;
    private ReentrantLock lock = new ReentrantLock(true);

    public Map<String, Object> getFeatures() {
        return this.features;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizeRead(boolean fast) {
        this.lock.lock();
        try {
            this.locking = !fast;
        }
        finally {
            this.lock.unlock();
        }
    }

    public <T> T getFeature(String key) {
        return (T)this.getFeature(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getFeature(String key, T defaultValue) {
        boolean release = this.acquireLockIfNeeded();
        try {
            T t = this.features.containsKey(key) ? this.features.get(key) : defaultValue;
            return t;
        }
        finally {
            if (release) {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void putFeature(String key, T value) {
        boolean release = this.acquireLockIfNeeded();
        try {
            this.features.put(key, value);
        }
        finally {
            if (release) {
                this.lock.unlock();
            }
        }
    }

    public <T extends FeaturesCapable> T copy() {
        try {
            FeaturesCapable self = (FeaturesCapable)this.clone();
            this.copyInto(self);
            return (T)self;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("cannot clone() " + this, e);
        }
    }

    protected <T extends FeaturesCapable> void copyInto(T target) {
        target.features = target.createFeaturesMap();
        target.features.putAll(this.features);
        if (this.validations != null) {
            target.validations = (Validation[])this.validations.clone();
        }
    }

    public Validation[] getValidations() {
        return (Validation[])ArrayUtils.clone((Object[])this.validations);
    }

    public void setValidations(Validation[] validations) {
        this.validations = (Validation[])ArrayUtils.clone((Object[])validations);
    }

    public void addValidation(Validation validation) {
        this.validations = (Validation[])ArrayUtils.add((Object[])this.validations, (Object)validation);
    }

    public boolean hasValidation(Validation aValidation) {
        if (this.validations == null) {
            return false;
        }
        for (Validation validation : this.validations) {
            if (!validation.equals(aValidation)) continue;
            return true;
        }
        return false;
    }

    protected ConcurrentMap<String, Object> createFeaturesMap() {
        return new ConcurrentHashMap<String, Object>();
    }

    private boolean acquireLockIfNeeded() {
        if (this.locking) {
            this.lock.lock();
            if (this.locking) {
                return true;
            }
            this.lock.unlock();
        }
        return false;
    }
}

