/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang3.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrivilegedActions {
    private static String lineSeparator = null;
    private static String pathSeparator = null;

    @Deprecated
    public static final String getLineSeparator() {
        if (lineSeparator == null) {
            lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        return lineSeparator;
    }

    @Deprecated
    public static final String getPathSeparator() {
        if (pathSeparator == null) {
            pathSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("path.separator");
                }
            });
        }
        return pathSeparator;
    }

    public static <T> T run(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    public static <T> T run(PrivilegedExceptionAction<T> action) throws PrivilegedActionException, Exception {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    public static Class<?> getUtilClass(final ClassLoader classLoader, final String className) throws Exception {
        return (Class)PrivilegedActions.run(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws Exception {
                return ClassUtils.getClass((ClassLoader)classLoader, (String)className, (boolean)true);
            }
        });
    }

    public static Object getAnnotationValue(final Annotation annotation, final String name) throws IllegalAccessException, InvocationTargetException {
        return PrivilegedActions.run(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Method valueMethod;
                try {
                    valueMethod = annotation.annotationType().getDeclaredMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    valueMethod = null;
                }
                if (null != valueMethod) {
                    try {
                        valueMethod.setAccessible(true);
                        return valueMethod.invoke((Object)annotation, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        });
    }

    public static ClassLoader getClassLoader(final Class<?> clazz) {
        return PrivilegedActions.run(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                if (cl == null) {
                    cl = clazz.getClassLoader();
                }
                return cl;
            }
        });
    }

    public static final String getProperty(final String name) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(name);
            }
        });
    }
}

