/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ProxyClassLoaderCache;
import org.apache.cxf.common.util.SortedArraySet;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class ProxyHelper {
    static final ProxyHelper HELPER = new ProxyHelper();
    private static final Logger LOG = LogUtils.getL7dLogger(ProxyHelper.class);
    protected ProxyClassLoaderCache proxyClassLoaderCache;
    static final long serialVersionUID = -7068764378510576356L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected ProxyHelper() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyHelper", "<init>", new Object[0]);
        }
        this.proxyClassLoaderCache = new ProxyClassLoaderCache();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected Object getProxyInternal(ClassLoader loader, Class<?>[] interfaces, InvocationHandler handler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyHelper", "getProxyInternal", new Object[]{loader, interfaces, handler});
        }
        ClassLoader combinedLoader = this.getClassLoaderForInterfaces(loader, interfaces);
        Object object = Proxy.newProxyInstance(combinedLoader, interfaces, handler);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "getProxyInternal", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private ClassLoader getClassLoaderForInterfaces(ClassLoader loader, Class<?>[] interfaces) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyHelper", "getClassLoaderForInterfaces", new Object[]{loader, interfaces});
        }
        if (this.canSeeAllInterfaces(loader, interfaces)) {
            LOG.log(Level.FINE, "current classloader " + loader + " can see all interface");
            ClassLoader classLoader = loader;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                classLoader = classLoader;
                LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "getClassLoaderForInterfaces", classLoader);
            }
            return classLoader;
        }
        String sortedNameFromInterfaceArray = this.getSortedNameFromInterfaceArray(interfaces);
        ClassLoader cachedLoader = this.proxyClassLoaderCache.getProxyClassLoader(loader, interfaces);
        if (this.canSeeAllInterfaces(cachedLoader, interfaces)) {
            LOG.log(Level.FINE, "find required loader from ProxyClassLoader cache with key" + sortedNameFromInterfaceArray);
            ClassLoader classLoader = cachedLoader;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                classLoader = classLoader;
                LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "getClassLoaderForInterfaces", classLoader);
            }
            return classLoader;
        }
        LOG.log(Level.FINE, "find a loader from ProxyClassLoader cache with interfaces " + sortedNameFromInterfaceArray + " but can't see all interfaces");
        for (Class<?> currentInterface : interfaces) {
            String ifName = currentInterface.getName();
            if (ifName.startsWith("org.apache.cxf") || ifName.startsWith("java")) continue;
            this.proxyClassLoaderCache.removeStaleProxyClassLoader(currentInterface);
            cachedLoader = this.proxyClassLoaderCache.getProxyClassLoader(loader, interfaces);
        }
        ClassLoader classLoader = cachedLoader;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            classLoader = classLoader;
            LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "getClassLoaderForInterfaces", classLoader);
        }
        return classLoader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String getSortedNameFromInterfaceArray(Class<?>[] interfaces) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyHelper", "getSortedNameFromInterfaceArray", new Object[]{interfaces});
        }
        SortedArraySet<String> arraySet = new SortedArraySet<String>();
        for (Class<?> currentInterface : interfaces) {
            arraySet.add(currentInterface.getName() + ClassLoaderUtils.getClassLoaderName(currentInterface));
        }
        String string = arraySet.toString();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "getSortedNameFromInterfaceArray", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    @FFDCIgnore(value={ClassNotFoundException.class})
    private boolean canSeeAllInterfaces(ClassLoader loader, Class<?>[] interfaces) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyHelper", "canSeeAllInterfaces", new Object[]{loader, interfaces});
        }
        for (Class<?> currentInterface : interfaces) {
            Class<?> ifClass;
            block10: {
                boolean bl;
                block11: {
                    String ifName = currentInterface.getName();
                    ifClass = Class.forName(ifName, true, loader);
                    if (ifClass == currentInterface) break block10;
                    bl = false;
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block11;
                    bl = bl;
                    LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "canSeeAllInterfaces", bl);
                }
                return bl;
            }
            try {
                for (Method m : ifClass.getMethods()) {
                    Class<?> returnType = m.getReturnType();
                    if (!returnType.isPrimitive()) {
                        Class.forName(returnType.getName(), true, loader);
                    }
                    for (Class<?> p : m.getParameterTypes()) {
                        if (p.isPrimitive()) continue;
                        Class.forName(p.getName(), true, loader);
                    }
                }
            }
            catch (ClassNotFoundException | NoClassDefFoundError e) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "canSeeAllInterfaces", bl);
                }
                return bl;
            }
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "canSeeAllInterfaces", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object getProxy(ClassLoader loader, Class<?>[] interfaces, InvocationHandler handler) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.common.util.ProxyHelper", "getProxy", new Object[]{loader, interfaces, handler});
        }
        Object object = HELPER.getProxyInternal(loader, interfaces, handler);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.common.util.ProxyHelper", "getProxy", object);
        }
        return object;
    }
}

