/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

class IntArrayDescriptor
extends ArrayDescriptor<int[]> {
    IntArrayDescriptor(TypeRepository rep) {
        super(int[].class, Integer.TYPE, rep);
    }

    @Override
    public Serializable readValue(InputStream in, Map<Integer, Serializable> offsetMap, Integer key) {
        int[] arr = (int[])this.createArray(in, offsetMap, key);
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = in.read_long();
        }
        return arr;
    }

    @Override
    public void writeValue(OutputStream out, Serializable value) {
        int[] arr = (int[])value;
        out.write_long(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            out.write_long(arr[i]);
        }
    }

    @Override
    Object copyObject(Object value, CopyState state) {
        if (((int[])value).length == 0) {
            return value;
        }
        Object copy = ((int[])value).clone();
        state.put(value, copy);
        return copy;
    }

    @Override
    void printFields(PrintWriter pw, Map recurse, Object val) {
        int[] arr = (int[])val;
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            pw.print(arr[i]);
        }
    }
}

