/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.apache.yoko.rmi.api.PortableRemoteObjectExt;
import org.apache.yoko.rmi.api.PortableRemoteObjectState;
import org.apache.yoko.rmi.impl.RMIServant;
import org.apache.yoko.rmi.impl.RemoteDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.util.NoDeleteSynchronizedMap;
import org.apache.yoko.util.Exceptions;
import org.apache.yoko.util.PrivilegedActions;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public class RMIState
implements PortableRemoteObjectState {
    static final Logger logger = Logger.getLogger(RMIState.class.getName());
    private boolean isShutdown;
    private final ORB _orb;
    private String _name;
    final TypeRepository repo = TypeRepository.get();
    private POA poa;
    final Map<Class<?>, Constructor<? extends Stub>> stub_map = new NoDeleteSynchronizedMap();
    final Map<Remote, Tie> tie_map = Collections.synchronizedMap(new IdentityHashMap());
    private Map<Class<?>, Optional<Constructor<? extends Stub>>> static_stub_map = new NoDeleteSynchronizedMap();
    private URL _codebase;

    POA getPOA() {
        return this.poa;
    }

    RMIState(ORB orb, String name) {
        Objects.requireNonNull(orb, "ORB is null");
        try {
            POA rootPoa = (POA)orb.resolve_initial_references("RootPOA");
            this.poa = rootPoa.create_POA(name, null, new Policy[0]);
            this.poa.the_POAManager().activate();
        }
        catch (AdapterAlreadyExists e) {
            logger.log(Level.WARNING, "Adapter already exists", e);
        }
        catch (InvalidPolicy e) {
            logger.log(Level.WARNING, "Invalid policy", e);
        }
        catch (InvalidName e) {
            logger.log(Level.WARNING, "Invalid name", e);
        }
        catch (AdapterInactive e) {
            logger.log(Level.WARNING, "Adapter inactive", e);
        }
        this._orb = orb;
        this._name = name;
    }

    void checkShutDown() {
        if (this.isShutdown) {
            BAD_INV_ORDER ex = new BAD_INV_ORDER("RMIState has already been shut down");
            logger.fine("RMIState has already been shut down " + (Object)((Object)ex));
            throw ex;
        }
    }

    @Override
    public void shutdown() {
        logger.finer("RMIState shutdown requested; name = " + this._name);
        this.checkShutDown();
        this.isShutdown = true;
    }

    @Override
    public ORB getORB() {
        return this._orb;
    }

    Delegate createDelegate(RMIServant servant) {
        this.checkShutDown();
        byte[] id = servant._id;
        RemoteDescriptor desc = servant._descriptor;
        String repid = desc.getRepositoryID();
        POA poa = this.getPOA();
        try {
            ObjectImpl ref = (ObjectImpl)poa.create_reference_with_id(id, repid);
            return ref._get_delegate();
        }
        catch (BAD_PARAM ex) {
            throw (InternalError)Exceptions.as(InternalError::new, (Throwable)ex, (Object)("wrong policy: " + ex.getMessage()));
        }
    }

    static RMIState current() {
        return (RMIState)PortableRemoteObjectExt.getState();
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader;
    }

    public void setCodeBase(URL codebase) {
        this._codebase = codebase;
    }

    public URL getCodeBase() {
        return this._codebase;
    }

    public Stub getStaticStub(String codebase, Class type) {
        Optional<Constructor<? extends Stub>> entry = this.static_stub_map.get(type);
        if (null == entry) {
            String stubClassName = this.getStubClassName(type);
            Constructor<? extends Stub> cons = this.getStubConstructor(codebase, stubClassName);
            if (cons == null) {
                cons = this.getStubConstructor(codebase, this.getOldStubClassName(stubClassName));
            }
            entry = Optional.ofNullable(cons);
            this.static_stub_map.put(type, entry);
        }
        return entry.map(this::createStub).orElse(null);
    }

    private Stub createStub(Constructor<? extends Stub> constructor) {
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (ClassCastException ex) {
            logger.log(Level.FINE, "loaded class " + constructor.getDeclaringClass() + " is not a proper stub", ex);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
            logger.log(Level.FINE, "cannot instantiate stub class for " + constructor.getDeclaringClass() + " :: " + ex.getMessage(), ex);
        }
        return null;
    }

    private Constructor<? extends Stub> getStubConstructor(String codebase, String stubClassName) {
        Constructor<? extends Stub> cons = this.findConstructor(codebase, stubClassName);
        if (cons == null || Stub.class.isAssignableFrom(cons.getDeclaringClass())) {
            return cons;
        }
        logger.fine("class " + cons.getDeclaringClass() + " is not a javax.rmi.CORBA.Stub");
        return null;
    }

    private Constructor<? extends Stub> findConstructor(String codebase, String stubName) {
        try {
            Class stubClass = Util.loadClass((String)stubName, (String)codebase, (ClassLoader)((ClassLoader)AccessController.doPrivileged(PrivilegedActions.GET_CONTEXT_CLASS_LOADER)));
            return (Constructor)AccessController.doPrivileged(PrivilegedActions.getNoArgConstructor((Class)stubClass));
        }
        catch (ClassNotFoundException ex) {
            logger.log(Level.FINE, "failed to load remote class " + stubName + " from " + codebase, ex);
        }
        catch (NoSuchMethodError ex) {
            logger.log(Level.WARNING, "stub class " + stubName + " has no default constructor", ex);
        }
        return null;
    }

    private String getStubClassName(Class<?> c) {
        String cname = c.getName();
        int idx = cname.lastIndexOf(46);
        if (idx == -1) {
            return String.format("org.omg.stub._%s_Stub", cname);
        }
        return String.format("org.omg.stub.%s_%s_Stub", cname.substring(0, idx + 1), cname.substring(idx + 1));
    }

    private String getOldStubClassName(String stubClassName) {
        return stubClassName.substring("org.omg.stub.".length());
    }

    @Override
    public void exportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.exportObject((Remote)remote);
    }

    @Override
    public void unexportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.unexportObject((Remote)remote);
    }

    public String getName() {
        return this._name;
    }
}

