/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.MethodDescriptor;
import org.apache.yoko.rmi.impl.RMIPersistentStub;
import org.apache.yoko.rmi.impl.RMIStub;
import org.apache.yoko.rmi.impl.StubHandler;

public class RMIStubHandler
implements StubHandler,
Serializable {
    static final Logger logger = Logger.getLogger(RMIStubHandler.class.getName());
    static final RMIStubHandler instance = new RMIStubHandler();
    static Field classNameField;
    static Field methodNameField;
    static Field fileNameField;
    static Field lineNumberField;

    protected RMIStubHandler() {
    }

    @Override
    public Object stubWriteReplace(RMIStub stub) {
        Class type = stub._descriptor.type;
        return new RMIPersistentStub(stub, type);
    }

    /*
     * Exception decompiling
     */
    @Override
    public Object invoke(RMIStub stub, MethodDescriptor method, Object[] args) throws Throwable {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Throwable addLocalTrace(MethodDescriptor desc, Throwable ex) {
        try {
            throw new Throwable("Client-Side RMI Trace");
        }
        catch (Throwable lex) {
            StackTraceElement[] remoteTrace = ex.getStackTrace();
            StackTraceElement[] localTrace = lex.getStackTrace();
            StackTraceElement[] fullTrace = new StackTraceElement[localTrace.length + remoteTrace.length];
            for (int i = 0; i < remoteTrace.length; ++i) {
                fullTrace[i] = remoteTrace[i];
            }
            Method m = desc.getReflectedMethod();
            RMIStubHandler.resetTraceInfo(m.getDeclaringClass().getName(), m.getName(), localTrace[0]);
            for (int i = 0; i < localTrace.length; ++i) {
                fullTrace[remoteTrace.length + i] = localTrace[i];
            }
            ex.setStackTrace(fullTrace);
            return ex;
        }
    }

    private static void resetTraceInfo(String className, String methodName, StackTraceElement ste) {
        try {
            classNameField.set(ste, className);
            methodNameField.set(ste, methodName);
            fileNameField.set(ste, "--- RMI/IIOP INVOCATION ---");
            lineNumberField.set(ste, -2000);
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    classNameField = StackTraceElement.class.getDeclaredField("declaringClass");
                    classNameField.setAccessible(true);
                    methodNameField = StackTraceElement.class.getDeclaredField("methodName");
                    methodNameField.setAccessible(true);
                    fileNameField = StackTraceElement.class.getDeclaredField("fileName");
                    fileNameField.setAccessible(true);
                    lineNumberField = StackTraceElement.class.getDeclaredField("lineNumber");
                    lineNumberField.setAccessible(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }
}

