/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Objects;

class Util {
    Util() {
    }

    static String getPackageName(Class clazz) {
        String class_name = clazz.getName();
        int idx = class_name.lastIndexOf(46);
        if (idx == -1) {
            return null;
        }
        return class_name.substring(0, idx);
    }

    static Class defineClass(ClassLoader loader, String className, byte[] data) {
        return loader == null ? Util.defineClass(Objects.requireNonNull(Thread.currentThread().getContextClassLoader()), className, data) : (Class)AccessController.doPrivileged(DefineClass.invoker(loader, className, data));
    }

    static String methodFieldName(int i) {
        return "__method$" + i;
    }

    static String handlerFieldName() {
        return "__handler";
    }

    static String initializerFieldName() {
        return "__initializer";
    }

    static String getSuperMethodName(String name) {
        return String.format("__super_%s$%s", name, Integer.toHexString(name.hashCode() & 0xFFFF));
    }

    private static enum DefineClass {

        private static final URL STUB_SOURCE_URL;
        private static final Certificate[] NO_CERTS;
        private static Method defineClass;

        private static ProtectionDomain getProtectionDomain(ClassLoader loader) {
            return new ProtectionDomain(new CodeSource(STUB_SOURCE_URL, NO_CERTS), new Permissions(), loader, null);
        }

        private static PrivilegedAction<Class> invoker(ClassLoader loader, String className, byte[] data) {
            return () -> {
                try {
                    return (Class)defineClass.invoke((Object)loader, className, data, 0, data.length, DefineClass.getProtectionDomain(loader));
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    throw new Error("internal error", ex);
                }
                catch (InvocationTargetException ex) {
                    try {
                        throw ex.getTargetException();
                    }
                    catch (Error | RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new Error("unexpected exception: " + ex.getMessage(), ex);
                    }
                }
            };
        }

        static {
            try {
                STUB_SOURCE_URL = new URL(null, "yoko:stub", new URLStreamHandler(){

                    @Override
                    protected URLConnection openConnection(URL u) {
                        return null;
                    }
                });
            }
            catch (MalformedURLException unexpected) {
                throw new Error(unexpected);
            }
            NO_CERTS = new Certificate[0];
            try {
                Class<ClassLoader> clc = ClassLoader.class;
                defineClass = clc.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE, ProtectionDomain.class);
                AccessController.doPrivileged(() -> {
                    defineClass.setAccessible(true);
                    return null;
                });
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new Error("unexpected exception: " + ex.getMessage(), ex);
            }
        }
    }
}

