/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.io;

public enum AlignmentBoundary {
    NO_BOUNDARY{

        @Override
        int gap(int index) {
            return 0;
        }

        @Override
        int newIndex(int index) {
            return index;
        }
    }
    ,
    TWO_BYTE_BOUNDARY{

        @Override
        int gap(int index) {
            return index & 1;
        }

        @Override
        int newIndex(int index) {
            return index + 1 & 0xFFFFFFFE;
        }
    }
    ,
    FOUR_BYTE_BOUNDARY{

        @Override
        int gap(int index) {
            return -index & 3;
        }

        @Override
        int newIndex(int index) {
            return index + 3 & 0xFFFFFFFC;
        }
    }
    ,
    EIGHT_BYTE_BOUNDARY{

        @Override
        int gap(int index) {
            return -index & 7;
        }

        @Override
        int newIndex(int index) {
            return index + 7 & 0xFFFFFFF8;
        }
    };


    abstract int gap(int var1);

    abstract int newIndex(int var1);
}

