/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.yoko.util.Exceptions;

public enum PrivilegedActions {

    public static final PrivilegedAction<Properties> GET_SYSPROPS = System::getProperties;
    public static final PrivilegedAction<Map<Object, Object>> GET_SYSPROPS_OR_EMPTY_MAP = () -> {
        try {
            return System.getProperties();
        }
        catch (SecurityException swallowed) {
            return Collections.EMPTY_MAP;
        }
    };
    public static final PrivilegedAction<ClassLoader> GET_CONTEXT_CLASS_LOADER = () -> Thread.currentThread().getContextClassLoader();

    public static final PrivilegedAction<String> getSysProp(String key) {
        return () -> System.getProperty(key);
    }

    public static final PrivilegedAction<String> getSysProp(String key, String defaultValue) {
        return () -> System.getProperty(key, defaultValue);
    }

    public static final <T> PrivilegedAction<Constructor<T>> getNoArgConstructor(Class<T> type) {
        return () -> {
            try {
                return type.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw Exceptions.as(NoSuchMethodError::new, e, e.getMessage());
            }
        };
    }

    public static final PrivilegedAction<Method> getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        return () -> {
            try {
                return type.getMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw Exceptions.as(NoSuchMethodError::new, e, e.getMessage());
            }
        };
    }

    public static final PrivilegedAction<Method> getDeclaredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        return () -> {
            try {
                return type.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw Exceptions.as(NoSuchMethodError::new, e, e.getMessage());
            }
        };
    }

    public static final <T> PrivilegedAction<T> action(Supplier<T> supplier) {
        return supplier::get;
    }
}

