/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.util.cmsf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.rmi.CORBA.Util;

public final class RepIds
extends Enum<RepIds> {
    private static final Logger LOGGER;
    private static final Pattern dotPattern;
    private static final Pattern slashPattern;
    private static final Set<String> keywords;
    private static final List<String> reservedSuffixes;
    private static final /* synthetic */ RepIds[] $VALUES;

    public static RepIds[] values() {
        return (RepIds[])$VALUES.clone();
    }

    public static RepIds valueOf(String name) {
        return Enum.valueOf(RepIds.class, name);
    }

    public static Query query(String repid) {
        return new QueryImpl(repid);
    }

    private static Class<?> toClass(QueryImpl query) {
        Class result;
        block6: {
            String repid = query.repid;
            String suffix = query.suffix;
            String codebase = query.codebase;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Searching for class from repid \"%s\" using suffix \"%s\"", repid, suffix));
            }
            result = null;
            if ("IDL:omg.org/CORBA/WStringValue:1.0".equals(repid) && "".equals(suffix)) {
                return String.class;
            }
            String className = RepIds.toClassName(query);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Class name from repid \"%s\" using suffix \"%s\" is \"%s\"", repid, suffix, className));
            }
            if (className != null) {
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    result = Util.loadClass((String)className, (String)codebase, (ClassLoader)loader);
                }
                catch (ClassNotFoundException ex) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block6;
                    LOGGER.fine(String.format("Class \"%s\" not found", className));
                }
            }
        }
        return result;
    }

    private static String toClassName(QueryImpl query) {
        String repid = query.repid;
        String suffix = query.suffix;
        if ("IDL:omg.org/CORBA/WStringValue:1.0".equals(repid) && "".equals(suffix)) {
            return String.class.getName();
        }
        String result = null;
        if (repid.startsWith("IDL:")) {
            result = RepIds.idlToClassName(repid);
        } else if (repid.startsWith("RMI:")) {
            result = RepIds.rmiToClassName(repid);
        }
        if (result != null) {
            result = result + suffix;
            result = RepIds.removeUnicodeEscapes(result);
        }
        return result;
    }

    private static String rmiToClassName(String repid) {
        int end = repid.indexOf(58, 4);
        String result = end < 0 ? repid.substring(4) : repid.substring(4, end);
        return result;
    }

    private static String idlToClassName(String repid) {
        try {
            StringBuilder sb = new StringBuilder(repid.length());
            int end = repid.lastIndexOf(58);
            String s = end < 0 ? repid.substring(4) : repid.substring(4, end);
            int firstSlash = s.indexOf(47);
            if (firstSlash > 0) {
                String prefix = s.substring(0, firstSlash);
                String[] elems = dotPattern.split(prefix);
                Collections.reverse(Arrays.asList(elems));
                for (String elem : elems) {
                    sb.append(RepIds.fixName(elem)).append('.');
                }
                s = s.substring(firstSlash + 1);
            }
            for (String elem : slashPattern.split(s)) {
                sb.append(RepIds.fixName(elem)).append('.');
            }
            sb.deleteCharAt(sb.length() - 1);
            return sb.toString();
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }

    private static String removeUnicodeEscapes(String in) {
        int escape = in.indexOf("\\U");
        if (escape < 0) {
            return in;
        }
        StringBuilder out = new StringBuilder(in.length());
        int start = 0;
        while (escape >= 0) {
            out.append(in.substring(start, escape));
            escape += 2;
            int value = 0;
            block6: for (int i = 0; i < 4; ++i) {
                char ch = in.charAt(escape++);
                switch (ch) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = (value << 4) + ch - 48;
                        continue block6;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        value = (value << 4) + 10 + ch - 97;
                        continue block6;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        value = (value << 4) + 10 + ch - 65;
                        continue block6;
                    }
                    default: {
                        value <<= 4;
                    }
                }
            }
            out.append((char)value);
            start = escape;
            escape = in.indexOf("\\U", escape);
        }
        if (start < in.length()) {
            out.append(in.substring(start));
        }
        return out.toString();
    }

    private static Set<String> createStringSet(String ... strings) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(strings)));
    }

    private static List<String> createStringList(String ... strings) {
        return Collections.unmodifiableList(Arrays.asList(strings));
    }

    private static String fixName(String name) {
        assert (name.indexOf(46) == -1);
        int nameLen = name.length();
        if (nameLen == 0) {
            return name;
        }
        if (keywords.contains(name)) {
            return "_" + name;
        }
        String result = name;
        String curr = name;
        block0: while (true) {
            for (String reservedSuffix : reservedSuffixes) {
                int resLength;
                if (!curr.endsWith(reservedSuffix)) continue;
                result = "_" + result;
                int currLength = curr.length();
                if (currLength == (resLength = reservedSuffix.length())) {
                    return result;
                }
                curr = curr.substring(0, currLength - resLength);
                continue block0;
            }
            break;
        }
        return result;
    }

    static {
        $VALUES = new RepIds[0];
        LOGGER = Logger.getLogger(RepIds.class.getName());
        dotPattern = Pattern.compile(Pattern.quote("."));
        slashPattern = Pattern.compile(Pattern.quote("/"));
        keywords = RepIds.createStringSet("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "clone", "const", "continue", "default", "do", "double", "else", "equals", "extends", "false", "final", "finalize", "finally", "float", "for", "getClass", "goto", "hashCode", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "notify", "notifyAll", "null", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "toString", "transient", "true", "try", "void", "volatile", "wait", "while");
        reservedSuffixes = RepIds.createStringList("Helper", "Holder", "Operations", "POA", "POATie", "Package", "ValueFactory");
    }

    private static final class QueryImpl
    implements Query {
        public final String repid;
        public final String suffix;
        public final String codebase;

        private QueryImpl(String repid) {
            this(Objects.requireNonNull(repid), "", null);
        }

        private QueryImpl(String repid, String suffix, String codebase) {
            this.repid = repid;
            this.suffix = suffix;
            this.codebase = codebase;
        }

        @Override
        public QueryImpl suffix(String suffix) {
            return new QueryImpl(this.repid, Objects.requireNonNull(suffix), this.codebase);
        }

        @Override
        public QueryImpl codebase(String codebase) {
            return new QueryImpl(this.repid, this.suffix, codebase);
        }

        @Override
        public <T> Class<T> toClass() {
            return RepIds.toClass(this);
        }

        @Override
        public String toClassName() {
            return RepIds.toClassName(this);
        }
    }

    public static interface Query {
        public Query suffix(String var1);

        public Query codebase(String var1);

        public <T> Class<T> toClass();

        public String toClassName();
    }
}

