/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.cyberneko.html.HTMLTagBalancingListener;
import org.cyberneko.html.parsers.DOMParser;
import org.openid4java.discovery.RuntimeDiscoveryException;
import org.w3c.dom.Document;
import org.w3c.dom.html.HTMLHtmlElement;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class OpenID4JavaDOMParser
extends DOMParser
implements HTMLTagBalancingListener {
    private boolean ignoredHeadStartElement;

    public static InputSource createInputSource(String s) {
        try {
            return new InputSource(new ByteArrayInputStream(s.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toXmlString(Document doc) throws TransformerException {
        Transformer transformer;
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            transformer = factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        DOMSource source = new DOMSource(doc);
        StringWriter xmlString = new StringWriter();
        StreamResult streamResult = new StreamResult(xmlString);
        transformer.transform(source, streamResult);
        return xmlString.toString();
    }

    public OpenID4JavaDOMParser() {
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", false);
            this.setFeature("http://xml.org/sax/features/validation", false);
            this.setFeature("http://xml.org/sax/features/external-general-entities", false);
            this.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            this.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            this.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    throw new RuntimeDiscoveryException("External entity found in input data");
                }
            });
        }
        catch (SAXNotRecognizedException e) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            // empty catch block
        }
    }

    public boolean isIgnoredHeadStartElement() {
        return this.ignoredHeadStartElement;
    }

    public void ignoredEndElement(QName element, Augmentations augs) {
    }

    public void ignoredStartElement(QName element, XMLAttributes attrs, Augmentations augs) {
        if (element.rawname.equals("HEAD") && this.fCurrentNode instanceof HTMLHtmlElement) {
            this.ignoredHeadStartElement = true;
        }
    }
}

