/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.RecoveryEventListener;
import java.util.ArrayList;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RegisteredRecoveryEventListeners
implements RecoveryEventListener {
    private static final TraceComponent tc = Tr.register(RegisteredRecoveryEventListeners.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private static final RegisteredRecoveryEventListeners _instance = new RegisteredRecoveryEventListeners();
    private List<RecoveryEventListener> _listeners;
    static final long serialVersionUID = 8628840450769249906L;

    public static RegisteredRecoveryEventListeners instance() {
        return _instance;
    }

    private RegisteredRecoveryEventListeners() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
    }

    @ManualTrace
    public synchronized void add(RecoveryEventListener rel) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"add", (Object[])new Object[]{rel});
        }
        if (this._listeners == null) {
            this._listeners = new ArrayList<RecoveryEventListener>();
        }
        this._listeners.add(rel);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"add");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void failureOccurred(FailureScope fs) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"failureOccurred", (Object[])new Object[]{fs});
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener rel = this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Notifying " + rel), (Object[])new Object[0]);
            }
            try {
                rel.failureOccurred(fs);
                continue;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RegisteredRecoveryEventListeners", (String)"66", (Object)this, (Object[])new Object[]{fs});
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Exception notifying " + rel), (Object[])new Object[]{t});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"failureOccurred");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void clientRecoveryInitiated(FailureScope fs, int clientId) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clientRecoveryInitiated", (Object[])new Object[]{fs, clientId});
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener rel = this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Notifying " + rel), (Object[])new Object[0]);
            }
            try {
                rel.clientRecoveryInitiated(fs, clientId);
                continue;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RegisteredRecoveryEventListeners", (String)"92", (Object)this, (Object[])new Object[]{fs, clientId});
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Exception notifying " + rel), (Object[])new Object[]{t});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clientRecoveryInitiated");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void clientRecoveryComplete(FailureScope fs, int clientId) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"clientRecoveryComplete", (Object[])new Object[]{fs, clientId});
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener rel = this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Notifying " + rel), (Object[])new Object[0]);
            }
            try {
                rel.clientRecoveryComplete(fs, clientId);
                continue;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RegisteredRecoveryEventListeners", (String)"118", (Object)this, (Object[])new Object[]{fs, clientId});
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Exception notifying " + rel), (Object[])new Object[]{t});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"clientRecoveryComplete");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ManualTrace
    public void recoveryComplete(FailureScope fs) {
        if (this._listeners == null) {
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object[])new Object[]{fs});
        }
        for (int i = 0; i < this._listeners.size(); ++i) {
            RecoveryEventListener rel = this._listeners.get(i);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Notifying " + rel), (Object[])new Object[0]);
            }
            try {
                rel.recoveryComplete(fs);
                continue;
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.recoverylog.spi.RegisteredRecoveryEventListeners", (String)"144", (Object)this, (Object[])new Object[]{fs});
                if (!tc.isEventEnabled()) continue;
                Tr.event((TraceComponent)tc, (String)("Exception notifying " + rel), (Object[])new Object[]{t});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }
}

