/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.common.enums;

import com.ibm.ws.repository.common.enums.FilterableAttribute;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;

public class FilterPredicate {
    private FilterableAttribute attribute;
    private Collection<String> values;

    public FilterableAttribute getAttribute() {
        return this.attribute;
    }

    public Collection<String> getValues() {
        return this.values;
    }

    private FilterPredicate() {
    }

    public static FilterPredicate areEqual(FilterableAttribute attribute, Object value) {
        FilterPredicate pred = new FilterPredicate();
        pred.attribute = attribute;
        Class<?> requiredType = attribute.getType();
        if (!requiredType.isInstance(value)) {
            throw new IllegalArgumentException("The value must be of the correct type for the FilterableAttribute. Expected: " + requiredType.getName() + " but was " + value.getClass().getName());
        }
        pred.values = Collections.singleton(FilterPredicate.getString(value));
        return pred;
    }

    private static String getString(Object value) {
        if (!(value instanceof Enum)) {
            return value.toString();
        }
        Method method = null;
        try {
            method = value.getClass().getMethod("getValue", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (method != null && method.getReturnType() != String.class) {
            method = null;
        }
        if (method == null) {
            return value.toString();
        }
        String answer = null;
        try {
            answer = (String)method.invoke(value, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The enum " + value.getClass().getName() + " was expected to have a public getValue method", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("The enum " + value.getClass().getName() + " was expected to have a public getValue method with no arguments", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("The enum " + value.getClass().getName() + " getValue method threw an unexpectd exception", e);
        }
        return answer;
    }
}

