/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.common.enums;

import com.ibm.ws.repository.common.enums.StateAction;
import java.util.Arrays;
import java.util.List;

public enum State {
    DRAFT("draft", new StateAction[]{null, StateAction.PUBLISH, StateAction.PUBLISH, StateAction.PUBLISH}),
    AWAITING_APPROVAL("awaiting_approval", new StateAction[]{StateAction.CANCEL, null, StateAction.NEED_MORE_INFO, StateAction.APPROVE}),
    NEED_MORE_INFO("need_more_info", new StateAction[]{StateAction.PUBLISH, StateAction.PUBLISH, null, StateAction.PUBLISH}),
    PUBLISHED("published", new StateAction[]{StateAction.UNPUBLISH, StateAction.UNPUBLISH, StateAction.UNPUBLISH, null});

    private final String state;
    private StateAction[] actions;

    private State(String state, StateAction[] actions) {
        this.state = state;
        this.actions = actions;
    }

    public boolean isStateActionAllowed(StateAction action) {
        List<StateAction> allowed = Arrays.asList(this.actions);
        return action == null ? false : allowed.contains((Object)action);
    }

    public StateAction getNextAction(State target) {
        return this.actions[target.ordinal()];
    }

    public String getValue() {
        return this.state;
    }

    public static State forValue(String value) {
        for (State state : State.values()) {
            if (!state.getValue().equals(value)) continue;
            return state;
        }
        return null;
    }
}

