/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resources.internal;

import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.internal.RepositoryResourceImpl;
import com.ibm.ws.repository.resources.internal.RepositoryResourceMatchingData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public class ResourceCollector<T extends RepositoryResource> {
    private final HashSet<RepositoryResourceMatchingData> _dupesChecker;
    private final ArrayList<T> _backingCollection = new ArrayList();

    public ResourceCollector(DuplicatePolicy duplicatePolicy) {
        this._dupesChecker = duplicatePolicy == DuplicatePolicy.FORBID_DUPLICATES ? new HashSet() : null;
    }

    public boolean add(T res) {
        if (this._dupesChecker != null) {
            RepositoryResourceMatchingData matchingData = ((RepositoryResourceImpl)res).createMatchingData();
            if (!this._dupesChecker.contains(matchingData)) {
                this._dupesChecker.add(matchingData);
                this._backingCollection.add(res);
                return true;
            }
            return false;
        }
        this._backingCollection.add(res);
        return true;
    }

    public boolean addAll(Iterable<? extends T> iterable) {
        boolean ret = false;
        for (RepositoryResource item : iterable) {
            ret |= this.add(item);
        }
        return ret;
    }

    public Collection<T> getResourceCollection() {
        return this._backingCollection;
    }

    public static enum DuplicatePolicy {
        ALLOW_DUPLICATES,
        FORBID_DUPLICATES;

    }
}

