/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.request.timing.manager;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.request.timing.RequestTimingService;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class ThreadDumpManager {
    private static final TraceComponent tc = Tr.register(ThreadDumpManager.class, (String)"requestTiming", (String)"com.ibm.ws.request.timing.internal.resources.LoggingMessages");
    private final int threadDumpsRequired;
    private final int threadDumpDuration;
    private final Counter threadDumpsGenerated = new Counter();
    private volatile ScheduledFuture<?> timeKeeper = null;
    private final Runnable generateThreadDump = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Trivial
        public void run() {
            try {
                RequestTimingService.getLibertyProcess().createJavaDump(new HashSet<String>(Arrays.asList("thread")));
            }
            finally {
                Counter counter = ThreadDumpManager.this.threadDumpsGenerated;
                synchronized (counter) {
                    if (ThreadDumpManager.this.threadDumpsGenerated.get() == 0) {
                        ThreadDumpManager.this.threadDumpsGenerated.notifyAll();
                    }
                    ThreadDumpManager.this.threadDumpsGenerated.increment();
                    if (ThreadDumpManager.this.threadDumpsGenerated.get() >= ThreadDumpManager.this.threadDumpsRequired) {
                        ThreadDumpManager.this.stopTimer();
                    }
                }
            }
        }
    };

    public ThreadDumpManager(int threadDumpsRequired, int threadDumpDuration) {
        this.threadDumpsRequired = threadDumpsRequired;
        this.threadDumpDuration = threadDumpDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTimer() {
        Counter counter = this.threadDumpsGenerated;
        synchronized (counter) {
            if (this.timeKeeper == null) {
                this.threadDumpsGenerated.reset();
                this.timeKeeper = RequestTimingService.getScheduledExecutorService().scheduleAtFixedRate(this.generateThreadDump, 0L, this.threadDumpDuration, TimeUnit.MINUTES);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Starting thread dump scheduler with initial delay (ms) : 0 and period (min) : " + this.threadDumpDuration), (Object[])new Object[0]);
                }
            }
            if (this.threadDumpsGenerated.get() == 0) {
                try {
                    this.threadDumpsGenerated.wait();
                }
                catch (InterruptedException ie) {
                    FFDCFilter.processException((Throwable)ie, (String)this.getClass().getName(), (String)"77", (Object)this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTimer() {
        Counter counter = this.threadDumpsGenerated;
        synchronized (counter) {
            if (this.timeKeeper != null) {
                try {
                    this.timeKeeper.cancel(false);
                    this.timeKeeper = null;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Stopping thread dump scheduler.", (Object[])new Object[0]);
                    }
                }
                finally {
                    if (this.threadDumpsGenerated.get() == 0) {
                        this.threadDumpsGenerated.notifyAll();
                    }
                }
            }
        }
    }

    private static final class Counter {
        int count = 0;

        private Counter() {
        }

        public void increment() {
            ++this.count;
        }

        public int get() {
            return this.count;
        }

        public void reset() {
            this.count = 0;
        }
    }
}

