/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.batch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import v2.io.swagger.models.Info;
import v2.io.swagger.models.Model;
import v2.io.swagger.models.ModelImpl;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Scheme;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.Tag;
import v2.io.swagger.models.parameters.BodyParameter;
import v2.io.swagger.models.parameters.Parameter;
import v2.io.swagger.models.parameters.PathParameter;
import v2.io.swagger.models.parameters.QueryParameter;
import v2.io.swagger.models.properties.ArrayProperty;
import v2.io.swagger.models.properties.ObjectProperty;
import v2.io.swagger.models.properties.Property;
import v2.io.swagger.models.properties.StringProperty;
import v2.io.swagger.util.Json;
import v2.io.swagger.util.Yaml;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={APIProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class BatchAPIProviderImpl
implements APIProvider {
    private static final TraceComponent tc = Tr.register(BatchAPIProviderImpl.class, null, null);
    private final Map<APIProvider.DocType, String> documents = new HashMap<APIProvider.DocType, String>();
    private Swagger swagger = null;
    private Path reusablePath;
    static final long serialVersionUID = -7661318586446924118L;

    public synchronized String getDocument(APIProvider.DocType docType) {
        String document;
        if (this.documents.containsKey(docType)) {
            document = this.documents.get(docType);
        } else {
            document = this.generateDocument(docType);
            this.documents.put(docType, document);
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    private String generateDocument(APIProvider.DocType docType) {
        String document;
        block6: {
            if (this.swagger == null) {
                this.populateDocument();
            }
            document = null;
            try {
                if (docType == APIProvider.DocType.Swagger_20_JSON) {
                    document = Json.mapper().writeValueAsString((Object)this.swagger);
                } else if (docType == APIProvider.DocType.Swagger_20_YAML) {
                    document = Yaml.mapper().writeValueAsString((Object)this.swagger);
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                void e;
                FFDCFilter.processException((Throwable)jsonProcessingException, (String)"com.ibm.ws.rest.api.discovery.batch.BatchAPIProviderImpl", (String)"83", (Object)this, (Object[])new Object[]{docType});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block6;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Exception occurred while trying to convert Swagger object to String. \n exception: " + e), (Object[])new Object[0]);
            }
        }
        return document;
    }

    private void populateDocument() {
        this.swagger = new Swagger();
        Info info = new Info().description("Batch APIs").version("1.0.0").title("Batch REST APIs");
        this.swagger.info(info).basePath("/ibm/api/batch").scheme(Scheme.HTTPS).tags(Arrays.asList(new Tag().name("Batch").description("Batch REST APIs")));
        this.populateJobExecutionsDocument();
        this.populateJobInstancesDocument();
        this.populateStepExecutionsDocument();
        this.populateBatchRoot();
    }

    private void populateJobExecutionsDocument() {
        Operation operationGetJobExecutionId = new Operation().tag("Batch").summary("Get information about a job execution").description("This URI returns detailed information about a specified job execution and includes links to associated step executions and job logs.").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionid")).type("integer")).format("int64")).produces("application/json").response(200, new Response().description("successful operation"));
        this.reusablePath = new Path().set("get", operationGetJobExecutionId);
        Operation operationPutJobExecutionId = new Operation().tag("Batch").summary("Stop or restart a job execution").description("Use this URI to stop or restart the specified job execution. Required parameters include action = stop, restart.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionid")).type("integer")).format("int64")).parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("action")).type("string")).required(true))._enum(Arrays.asList("stop", "restart"))).parameter((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("reusePreviousParams")).type("boolean")).defaultValue("false")).parameter((Parameter)new BodyParameter().name("Put method body parameter").description("The job parameters passed into a restart. This field is only used when action=restart and is always optional").schema(this.getPutModel())).response(200, new Response().description("successful operation")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.reusablePath.set("put", operationPutJobExecutionId);
        this.swagger.path("/jobexecutions/{jobexecutionid}", this.reusablePath);
        this.swagger.path("/v1/jobexecutions/{jobexecutionid}", this.reusablePath);
        Operation operationJobExecutionIdJobLogs = new Operation().tag("Batch").summary("Get info about job logs").description("This URI returns a JSON array with REST links to all job log parts for the specified job execution. The URI takes in a optional \"type\" parameter which specifies the format the job log parts are returned as. Either as plain text (type=text) or in a compressed file (type=zip).").produces(Arrays.asList("application/json", "application/zip", "text/plain")).parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionid")).type("integer")).format("int64")).parameter((Parameter)((QueryParameter)new QueryParameter().name("part")).type("string")).parameter((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("type")).type("string"))._enum(Arrays.asList("text", "zip"))).response(200, new Response().description("successful operation")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.swagger.path("/jobexecutions/{jobexecutionid}/joblogs", new Path().set("get", operationJobExecutionIdJobLogs));
        this.swagger.path("/v1/jobexecutions/{jobexecutionid}/joblogs", new Path().set("get", operationJobExecutionIdJobLogs));
        Operation operationJobExecutionIdJobInstance = new Operation().tag("Batch").summary("Get information about a job instance").description("This URI returns detailed information about the job instance of a specified job execution.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionid")).type("integer")).format("int64")).response(200, new Response().description("successful operation"));
        this.swagger.path("/jobexecutions/{jobexecutionid}/jobinstance", new Path().set("get", operationJobExecutionIdJobInstance));
        this.swagger.path("/v1/jobexecutions/{jobexecutionid}/jobinstance", new Path().set("get", operationJobExecutionIdJobInstance));
        Operation operationJobInstancesIdJobExecutions = new Operation().tag("Batch").summary("Get job execution information about a job instance").description("This URI returns detailed information about job executions for a specified job instance ID.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).response(200, new Response().description("successful operation"));
        this.swagger.path("/jobinstances/{jobinstanceid}/jobexecutions", new Path().set("get", operationJobInstancesIdJobExecutions));
        this.swagger.path("/v1/jobinstances/{jobinstanceid}/jobexecutions", new Path().set("get", operationJobInstancesIdJobExecutions));
        Operation operationJobInstancesIdJobExecutionsNumber = new Operation().tag("Batch").summary("Get information about a job execution number").description("This URI returns detailed information about a specified job execution in relation to the specified job instance. This includes links to associated step executions and job logs. Note: The job execution number means the 0th, 1st, 2nd, etc. job execution related to the specified job instance.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionnumber")).type("integer")).format("int32")).response(200, new Response().description("sucessful operation"));
        this.swagger.path("/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", new Path().set("get", operationJobInstancesIdJobExecutionsNumber));
        this.swagger.path("/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}", new Path().set("get", operationJobInstancesIdJobExecutionsNumber));
        Operation operationJobInstancesIdJobExecutionsIdJobLogs = new Operation().tag("Batch").summary("Get info about job logs").description("This URI returns a JSON array with REST links to all job log parts for the specified job execution. The URI takes in a optional \"type\" parameter which specifies the format the job log parts are returned as. Either as plain text (type=text) or in a compressed file (type=zip).").produces(Arrays.asList("application/json", "application/zip", "text/plain")).parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionid")).type("integer")).format("int64")).parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).parameter((Parameter)((QueryParameter)new QueryParameter().name("part")).type("string")).parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("type")).type("string"))._enum(Arrays.asList("text", "zip"))).defaultValue("text")).response(200, new Response().description("successful operation")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.swagger.path("/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", new Path().set("get", operationJobInstancesIdJobExecutionsIdJobLogs));
        this.swagger.path("/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionid}/joblogs", new Path().set("get", operationJobInstancesIdJobExecutionsIdJobLogs));
    }

    private void populateJobInstancesDocument() {
        QueryParameter jobInstanceId = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("jobInstanceId")).type("string")).description("jobInstanceId=[instanceId]:[instanceId]: Returns job instances equal to and between the instanceId range.\r\njobInstanceId=>[instanceId]: Returns job instances equal to and greater than the provided instanceId.\r\njobInstanceId=<[instanceId]: Returns job instances equal to and less than the provided instanceId.\r\njobInstanceId=[instanceId],[instanceId],[instanceId]: Returns job instances specified.\r\n");
        QueryParameter createTime = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("createTime")).type("string")).description("createTime=[yyyy-MM-dd]:[yyy-MM-dd]: Returns job instances between the date range.\r\ncreateTime=[yyyy-MM-dd]: Returns job instances on the given date.\r\ncreateTime=>3d: Returns job instances created including and after 3 days ago UTC.\r\ncreateTime=<3d: Returns job instances created including and before 3 days ago UTC.");
        QueryParameter instanceState = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("instanceState")).type("string")).description("Returns job instances with the provided state. Valid instance states are SUBMITTED, JMS_QUEUED, JMS_CONSUMED, DISPATCHED, FAILED, STOPPED, COMPLETED, and ABANDONED. Multiple state values may be separated by a comma.");
        QueryParameter exitStatus = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("exitStatus")).type("string")).description("Returns job instances matching the exit status string.");
        QueryParameter exitStatusMulti = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("exitStatus")).type("array")).items((Property)new StringProperty())).collectionFormat("multi")).description("Returns job instances matching the exit status string.");
        QueryParameter lastUpdatedTime = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("lastUpdatedTime")).type("string")).description("lastUpdatedTime=[yyyy-MM-dd]: Returns job instances that were last updated on the given date. This time value is updated on transitions of instance state. For example, from SUBMITTED to DISPATCHED.\r\nlastUpdatedTime=[yyyy-MM-dd]:[yyy-MM-dd]: Returns job instances last updated within the date range.\r\ncreateTime=>3d: Returns job instances last updated including and after 3 days ago UTC.\r\ncreateTime=<3d: Returns job instances last updated including and before 3 days ago UTC.");
        QueryParameter jobParameter = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("jobParameter")).type("string")).description("jobParameter.[paramName]=[paramValue]: Returns job instances with executions that have the supplied name:value pair as a job parameter.");
        QueryParameter submitter = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("submitter")).type("array")).items((Property)new StringProperty())).collectionFormat("multi")).description("Returns all job instances that were submitted by the specified user.");
        QueryParameter appName = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("appName")).type("array")).items((Property)new StringProperty())).collectionFormat("multi")).description("Returns all job instances with the specified application name. This can be either the simple application name, or the full app-module-component name. For example, a search for either MyApp or MyApp#MyApp.war will return a job instance with an application name of MyApp and module name of MyApp.war.");
        QueryParameter jobName = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("jobName")).type("array")).items((Property)new StringProperty())).collectionFormat("multi")).description("Returns all job instances with the specified job name.");
        QueryParameter ignoreCase = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("ignoreCase")).type("boolean")).description("By default, all text matching is case-sensitive. Specifying ignoreCase=true changes all text search terms to not be case sensitive.");
        QueryParameter sort = (QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("sort")).type("string")).description("Specifies the parameter or parameters to sort the results by. Using the - character to prefix the parameter specifies that sorting will be done in descending order. For example,sort=submitter sorts the results by submitter in ascending order. Specifying sort=submitter,-lastUpdatedTime sorts the results first by submitter in ascending order, and then by lastUpdatedTime, in descending order.");
        QueryParameter page = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("page")).type("integer")).format("int32")).description("Indicates which page (subset of records) to return. The default is 0.");
        QueryParameter pageSize = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("pageSize")).type("integer")).format("int32")).description("Indicates the number of records per page. The default is 50.");
        QueryParameter purgeJobStoreOnly = (QueryParameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("purgeJobStoreOnly")).type("boolean")).defaultValue("false")).description("When purgeJobStoreOnly=true, no attempt is made to purge the job logs associated with this job instance. The default setting is purgeJobStoreOnly=false. This API returns an error if the job instance has active job executions.");
        Operation operationGetJobInstances = new Operation().tag("Batch").summary("Get a list of job instances").description("This URI returns a list of job instances.").produces("application/json").parameter((Parameter)page).parameter((Parameter)pageSize).response(200, new Response().description("successful operation"));
        this.reusablePath = new Path().set("get", operationGetJobInstances);
        Operation operationPostJobInstances = new Operation().tag("Batch").summary("Submit (start) a new job").description("This URI submits (starts) a new job. ").produces("application/json").parameter((Parameter)new BodyParameter().name("POST method body parameter").description("The parameters that are passed in when the job is submitted").schema(this.getPOSTModel())).response(201, new Response().description("successful operation"));
        this.reusablePath.set("post", operationPostJobInstances);
        this.swagger.path("/jobinstances", this.reusablePath);
        this.swagger.path("/v1/jobinstances", this.reusablePath);
        Operation operationGetJobInstancesId = new Operation().tag("Batch").summary("Get information about a job instance").description("This URI returns detailed information about the specified job instance such as all executions that are associated with a specified job instance. Results are returned in order from most recent to the oldest. The most recent result is displayed first in the list.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).response(200, new Response().description("successful operation"));
        this.reusablePath = new Path().set("get", operationGetJobInstancesId);
        Operation operationPutJobInstancesId = new Operation().tag("Batch").summary("Stop or restart a job instance").description("Use this URI to stop or restart the most recent job execution that is associated with this job instance. When action is 'stop', this API will stop the most recent job execution that is associated with this job instance if it is running or else the API returns an error if it is not running. When action is 'restart', this API will restart the most recent job execution that is associated with this job instance only if it is in STOPPED or FAILED state. If no job execution is associated with this instance, or the latest job execution is in COMPLETED state, the API returns an error. Note that reusePreviousParams is an optional setting and when its value is true, any job parameters that are submitted as part of the current restart request take precedence over any previous job parameters. Current parameters override previous parameters with the same job parameter key name. ").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).parameter((Parameter)((QueryParameter)((QueryParameter)((QueryParameter)new QueryParameter().name("action")).type("string")).required(true))._enum(Arrays.asList("stop", "restart"))).parameter((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("reusePreviousParams")).type("boolean")).defaultValue("false")).parameter((Parameter)new BodyParameter().name("Put method body parameter").description("The job parameters passed into a restart. This field is only used when action=restart and is always optional").schema(this.getPutModel())).response(200, new Response().description("successful operation")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.reusablePath.set("put", operationPutJobInstancesId);
        Operation operationDeleteJobInstancesId = new Operation().tag("Batch").summary("Delete related information of a job instance").description("This URI purges all database entries and job logs that are associated with this job instance. This API returns an error if the job instance has active job executions. If there is an error when you delete the job logs, then no attempt is made to delete the job instance data from the job store database. When purgeJobStoreOnly is true, no attempt is made to purge the job logs associated with this job instance. This API returns an error if the job instance has active job executions.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).parameter((Parameter)purgeJobStoreOnly).response(200, new Response().description("Successful operation.")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.reusablePath.set("delete", operationDeleteJobInstancesId);
        this.swagger.path("/jobinstances/{jobinstanceid}", this.reusablePath);
        this.swagger.path("/v1/jobinstances/{jobinstanceid}", this.reusablePath);
        Operation operationJobInstancesIdJobLogs = new Operation().tag("Batch").summary("Get info about job logs").description("This URI returns a JSON array with REST links to all job log parts for the specified job instance. The URI takes in a optional \"type\" parameter which specifies the format the job log parts are returned as. Either as plain text (type=text) or in a compressed file (type=zip).").produces(Arrays.asList("application/json", "application/zip", "text/plain")).parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).parameter((Parameter)((QueryParameter)((QueryParameter)new QueryParameter().name("type")).type("string"))._enum(Arrays.asList("text", "zip"))).response(200, new Response().description("successful operation")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.swagger.path("/jobinstances/{jobinstanceid}/joblogs", new Path().set("get", operationJobInstancesIdJobLogs));
        this.swagger.path("/v1/jobinstances/{jobinstanceid}/joblogs", new Path().set("get", operationJobInstancesIdJobLogs));
        Operation operationDeleteJobInstancesIdJobLogs = new Operation().tag("Batch").summary("Delete local job logs").description("This URI purges the local job logs for the given job instance id from this endpoint only.").produces(Arrays.asList("application/json")).parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).response(200, new Response().description("successful operation"));
        this.swagger.path("/jobinstances/{jobinstanceid}/joblogs", new Path().set("delete", operationDeleteJobInstancesIdJobLogs));
        this.swagger.path("/v1/jobinstances/{jobinstanceid}/joblogs", new Path().set("delete", operationDeleteJobInstancesIdJobLogs));
        Operation operationGetJobInstancesV2 = new Operation().tag("Batch").summary("Get the list of job instances").description("This URI returns a list of job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").parameter((Parameter)jobInstanceId).parameter((Parameter)createTime).parameter((Parameter)instanceState).parameter((Parameter)exitStatus).parameter((Parameter)page).parameter((Parameter)pageSize).produces("application/json").response(200, new Response().description("successful operation"));
        this.reusablePath = new Path().set("get", operationGetJobInstancesV2);
        Operation operationDeleteJobInstancesV2 = new Operation().tag("Batch").summary("Delete related info of the specified job instances").description("This URI purges all database entries and job logs associated with the job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").parameter((Parameter)jobInstanceId).parameter((Parameter)createTime).parameter((Parameter)instanceState).parameter((Parameter)exitStatus).parameter((Parameter)page).parameter((Parameter)pageSize).parameter((Parameter)purgeJobStoreOnly).produces("application/json").response(200, new Response().description("Successful operation. The response may contain one of the following purgeStatus values: COMPLETED (job purge completed successfully.), FAILED (job purge failed.), STILL_ACTIVE (job purge failed because it was still active.), JOBLOGS_ONLY (database purge failed, but that the job logs were successfully purged.), NOT_LOCAL (job purge failed because the job is not local).")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.reusablePath.set("delete", operationDeleteJobInstancesV2);
        this.swagger.path("/v2/jobinstances", this.reusablePath);
        Operation operationGetJobInstancesV3 = new Operation().tag("Batch").summary("Get the list of job instances").description("This URI returns a list of job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").parameter((Parameter)jobInstanceId).parameter((Parameter)createTime).parameter((Parameter)instanceState).parameter((Parameter)exitStatus).parameter((Parameter)lastUpdatedTime).parameter((Parameter)jobParameter).parameter((Parameter)sort).parameter((Parameter)page).parameter((Parameter)pageSize).produces("application/json").response(200, new Response().description("successful operation"));
        this.reusablePath = new Path().set("get", operationGetJobInstancesV3);
        Operation operationDeleteJobInstancesV3 = new Operation().tag("Batch").summary("Delete related info of the specified job instances").description("This URI purges all database entries and job logs associated with the job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").parameter((Parameter)jobInstanceId).parameter((Parameter)createTime).parameter((Parameter)instanceState).parameter((Parameter)exitStatus).parameter((Parameter)lastUpdatedTime).parameter((Parameter)jobParameter).parameter((Parameter)page).parameter((Parameter)pageSize).parameter((Parameter)purgeJobStoreOnly).produces("application/json").response(200, new Response().description("Successful operation. The response may contain one of the following purgeStatus values: COMPLETED (job purge completed successfully.), FAILED (job purge failed.), STILL_ACTIVE (job purge failed because it was still active.), JOBLOGS_ONLY (database purge failed, but that the job logs were successfully purged.), NOT_LOCAL (job purge failed because the job is not local).")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.reusablePath.set("delete", operationDeleteJobInstancesV3);
        this.swagger.path("/v3/jobinstances", this.reusablePath);
        Operation operationGetJobInstancesv4 = new Operation().tag("Batch").summary("Get the list of job instances").description("This URI returns a list of job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").parameter((Parameter)jobInstanceId).parameter((Parameter)createTime).parameter((Parameter)instanceState).parameter((Parameter)exitStatusMulti).parameter((Parameter)lastUpdatedTime).parameter((Parameter)jobParameter).parameter((Parameter)submitter).parameter((Parameter)appName).parameter((Parameter)jobName).parameter((Parameter)ignoreCase).parameter((Parameter)sort).parameter((Parameter)page).parameter((Parameter)pageSize).produces("application/json").response(200, new Response().description("successful operation"));
        this.reusablePath = new Path().set("get", operationGetJobInstancesv4);
        Operation operationDeleteJobInstancesv4 = new Operation().tag("Batch").summary("Delete related info of the specified job instances").description("This URI purges all database entries and job logs associated with the job instances, filtered by the query parameters. String criteria may use the wildcard(*) operator anywhere in the string.").parameter((Parameter)jobInstanceId).parameter((Parameter)createTime).parameter((Parameter)instanceState).parameter((Parameter)exitStatusMulti).parameter((Parameter)lastUpdatedTime).parameter((Parameter)jobParameter).parameter((Parameter)submitter).parameter((Parameter)appName).parameter((Parameter)jobName).parameter((Parameter)ignoreCase).parameter((Parameter)page).parameter((Parameter)pageSize).parameter((Parameter)purgeJobStoreOnly).produces("application/json").response(200, new Response().description("Successful operation. The response may contain one of the following purgeStatus values: COMPLETED (job purge completed successfully.), FAILED (job purge failed.), STILL_ACTIVE (job purge failed because it was still active.), JOBLOGS_ONLY (database purge failed, but that the job logs were successfully purged.), NOT_LOCAL (job purge failed because the job is not local).")).response(302, new Response().description("The request was redirected to the correct executor"));
        this.reusablePath.set("delete", operationDeleteJobInstancesv4);
        this.swagger.path("/v4/jobinstances", this.reusablePath);
    }

    private void populateStepExecutionsDocument() {
        Operation operationGetJobInstances = new Operation().tag("Batch").summary("Get a list of step executions").description("This URI returns a JSON array of all the step execution details for the specified job execution. If your job contains a partitioned step, the partition information will be returned listed within each step.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionid")).type("integer")).format("int64")).response(200, new Response().description("successful operation"));
        this.swagger.path("/jobexecutions/{jobexecutionid}/stepexecutions", new Path().set("get", operationGetJobInstances));
        this.swagger.path("/v1/jobexecutions/{jobexecutionid}/stepexecutions", new Path().set("get", operationGetJobInstances));
        Operation operationGetJobExecutionsIdStepExecutionsName = new Operation().tag("Batch").summary("Get info about a step execution").description("This URI returns a JSON array containing the step execution details for the specified job execution and step name.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionid")).type("integer")).format("int64")).parameter((Parameter)((PathParameter)new PathParameter().name("stepname")).type("string")).response(200, new Response().description("successful operation"));
        this.swagger.path("/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", new Path().set("get", operationGetJobExecutionsIdStepExecutionsName));
        this.swagger.path("/v1/jobexecutions/{jobexecutionid}/stepexecutions/{stepname}", new Path().set("get", operationGetJobExecutionsIdStepExecutionsName));
        Operation operationGetStepExecutionsId = new Operation().tag("Batch").summary("Get info about a step execution").description("This URI returns a JSON array containing the step execution details for the specified step execution.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("stepexecutionid")).type("integer")).format("int64")).response(200, new Response().description("successful operation"));
        this.swagger.path("/stepexecutions/{stepexecutionid}", new Path().set("get", operationGetStepExecutionsId));
        this.swagger.path("/v1/stepexecutions/{stepexecutionid}", new Path().set("get", operationGetStepExecutionsId));
        Operation operationGetJobInstancesIdJobExecutionsIdStepExecutionsId = new Operation().tag("Batch").summary("Get info about step executions").description("This URI returns a JSON array containing the step execution details for the specified job instance, job execution, and step name.").produces("application/json").parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobinstanceid")).type("integer")).format("int64")).parameter((Parameter)((PathParameter)((PathParameter)new PathParameter().name("jobexecutionnumber")).type("integer")).format("int32")).parameter((Parameter)((PathParameter)new PathParameter().name("stepname")).type("string")).response(200, new Response().description("successful operation"));
        this.swagger.path("/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", new Path().set("get", operationGetJobInstancesIdJobExecutionsIdStepExecutionsId));
        this.swagger.path("/v1/jobinstances/{jobinstanceid}/jobexecutions/{jobexecutionnumber}/stepexecutions/{stepname}", new Path().set("get", operationGetJobInstancesIdJobExecutionsIdStepExecutionsId));
    }

    private void populateBatchRoot() {
        HashMap<String, StringProperty> innerProperties = new HashMap<String, StringProperty>();
        innerProperties.put("rel", new StringProperty());
        innerProperties.put("href", new StringProperty());
        ArrayProperty arrayProperty = new ArrayProperty().items((Property)new ObjectProperty(innerProperties));
        ObjectProperty linksProperty = new ObjectProperty(Collections.singletonMap("_links", arrayProperty));
        Operation operation = new Operation().tag("Batch").summary("Get the list of resources").description("Returns a list of available resources.").produces(Arrays.asList("application/json")).response(200, new Response().description("successful operation").schema((Property)linksProperty));
        this.swagger.path("/", new Path().set("get", operation));
    }

    private Map getPropsMap() {
        HashMap<String, StringProperty> props = new HashMap<String, StringProperty>();
        props.put("prop1", new StringProperty().example("prop1value"));
        props.put("prop2", new StringProperty().example("prop2value"));
        return props;
    }

    private Model getPutModel() {
        ModelImpl putModel = new ModelImpl().description("Sample model").type("object").property("jobParameters", (Property)new ObjectProperty(this.getPropsMap()).description("The job parameters you wish to submit with your job. The jobParameters are not required."));
        return putModel;
    }

    private Model getPOSTModel() {
        ModelImpl postModel = new ModelImpl().description("Sample model").type("object").property("applicationName", new StringProperty().example("BonusPayout").description("The applicationName identifies the batch application. It is required unless moduleName is specified, in which case the applicationName is derived from the moduleName by trimming off the .war or .jar suffix of the moduleName.")).property("moduleName", new StringProperty().example("BonusPayout.war").description("The moduleName identifies the module within the batch application that contains the job artifacts, such as the JSL. The job is submitted under the module's component context. The moduleName is required unless applicationName is specified, in which case the moduleName is derived from the applicationName by appending .war to the applicationName. ")).property("componentName", new StringProperty().example(" ").description("The componentName identifies the EJB component within the batch application EJB module. If specified, the job is submitted under the EJB's component context. Note: The componentName is required only when the module is an EJB module. When the module is a WAR module, the componentName is not required. ")).property("jobXMLName", new StringProperty().example("BonusPayoutJob").description("The job XML name. Note: this field is required unless jobXML is specified since the job ID information in the inline JSL is used for the job name.")).property("jobXML", new StringProperty().example(" ").description("As an alternative to using the JSL job definition that is packaged within your batch application under META-INF/batch-jobs, you can pass your JSL inline as part of your REST job submission request. The JSL that is submitted inline always overrides any JSL that is packaged with the batch application.")).property("jobParameters", (Property)new ObjectProperty(this.getPropsMap()).description("The job parameters you wish to submit with your job. The jobParameters are not required."));
        return postModel;
    }
}

