/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.jmx;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={APIProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class JMXAPIProviderImpl
implements APIProvider {
    private static final String PREFIX = "file:///";
    private WsLocationAdmin locationAdminProvider;
    private static final TraceComponent tc = Tr.register(JMXAPIProviderImpl.class, (String)"JMXAPIProvider", (String)"com.ibm.ws.rest.api.discovery.jmx.resources.JMXAPIProviderImplMessages");
    static final long serialVersionUID = 3796950977909250998L;

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocument(APIProvider.DocType docType) {
        String path = null;
        if (docType == APIProvider.DocType.Swagger_20_JSON) {
            path = this.locationAdminProvider.resolveString("${server.output.dir}//workarea/jmxSwagger/swagger.json");
            File swaggerDoc = new File(path);
            if (!FileUtils.fileExists((File)swaggerDoc)) {
                try {
                    FileUtils.fileMkDirs((File)swaggerDoc.getParentFile());
                    FileUtils.fileCreate((File)swaggerDoc);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.jmx.JMXAPIProviderImpl", (String)"68", (Object)this, (Object[])new Object[]{docType});
                    Tr.warning((TraceComponent)tc, (String)"IO_CREATE_ERROR", (Object[])new Object[]{swaggerDoc});
                    return null;
                }
                InputStream inputStream = this.getClass().getResourceAsStream("/lib/swagger.json");
                if (inputStream != null) {
                    FileOutputStream outputStream = null;
                    try {
                        int len;
                        outputStream = FileUtils.getFileOutputStream((File)swaggerDoc);
                        byte[] buffer = new byte[2048];
                        while ((len = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, len);
                        }
                    }
                    catch (IOException buffer) {
                        FFDCFilter.processException((Throwable)buffer, (String)"com.ibm.ws.rest.api.discovery.jmx.JMXAPIProviderImpl", (String)"84", (Object)this, (Object[])new Object[]{docType});
                        FileUtils.fileDelete((File)swaggerDoc);
                        Tr.warning((TraceComponent)tc, (String)"IO_COPY_ERROR", (Object[])new Object[]{swaggerDoc});
                        String string = null;
                        return string;
                    }
                    finally {
                        FileUtils.tryToClose((Closeable)outputStream);
                        FileUtils.tryToClose((Closeable)inputStream);
                    }
                }
            }
            path = PREFIX + path;
        }
        return path;
    }
}

