/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.publicapi.internal;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIDiscoveryHandler;
import com.ibm.ws.rest.api.discovery.APIProviderAggregator;
import com.ibm.ws.rest.handler.helper.ServletRESTRequestImpl;
import com.ibm.ws.rest.handler.helper.ServletRESTResponseImpl;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import java.io.IOException;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PublicAPIDiscoveryHandlerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final TraceComponent tc = Tr.register(PublicAPIDiscoveryHandlerServlet.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.publicapi.internal.resources.PublicAPIDiscoveryMessages");
    private transient APIProviderAggregator apiProviderAggregator = null;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        APIProvider.DocType docType = APIDiscoveryHandler.calculateDocType((RESTRequest)new ServletRESTRequestImpl(request));
        Set rootSet = APIDiscoveryHandler.processMultiCardinalityQueryParam((String[])request.getParameterValues("root"));
        boolean compact = Boolean.valueOf(request.getParameter("compact"));
        boolean displayPorts = Boolean.parseBoolean(request.getParameter("displayPorts"));
        if ("GET".equals(request.getMethod())) {
            ServletRESTResponseImpl restResponse = new ServletRESTResponseImpl(response);
            ServletRESTRequestImpl restRequest = new ServletRESTRequestImpl(request);
            boolean isSuccess = this.getAPIProviderAggregator(false).getPublicDocumentation(docType, rootSet, compact, displayPorts, (RESTRequest)restRequest, (RESTResponse)restResponse);
            if (!isSuccess) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"Couldn't get public API documentation. Retry after resetting the aggregator.", (Object[])new Object[0]);
                }
                this.getAPIProviderAggregator(true).getPublicDocumentation(docType, rootSet, compact, displayPorts, (RESTRequest)restRequest, (RESTResponse)restResponse);
            }
        }
    }

    private synchronized APIProviderAggregator getAPIProviderAggregator(boolean resetAggregator) throws ServletException {
        if (this.apiProviderAggregator == null || resetAggregator) {
            this.setAPIProviderAggregator();
        }
        return this.apiProviderAggregator;
    }

    private void setAPIProviderAggregator() throws ServletException {
        BundleContext bundleContext = (BundleContext)this.getServletContext().getAttribute("osgi-bundlecontext");
        ServiceReference apiProviderAggregatorRef = bundleContext.getServiceReference(APIProviderAggregator.class);
        if (apiProviderAggregatorRef == null) {
            throw new ServletException(TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.rest.api.discovery.publicapi.internal.resources.PublicAPIDiscoveryMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"APIProviderAggregator"}, (String)"CWWKO1400E: The {0} OSGi service is not available."));
        }
        this.apiProviderAggregator = (APIProviderAggregator)bundleContext.getService(apiProviderAggregatorRef);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("apiProviderAggregator=" + this.apiProviderAggregator), (Object[])new Object[0]);
        }
        if (this.apiProviderAggregator == null) {
            throw new ServletException(TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.rest.api.discovery.publicapi.internal.resources.PublicAPIDiscoveryMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"APIProviderAggregator"}, (String)"CWWKO1400E: The {0} OSGi service is not available."));
        }
    }
}

