/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.subscription.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.subscription.internal.WebSocketFeedProvider;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerOSGiError;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;

@ServerEndpoint(value="/{clientID}")
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WebSocket {
    private static final TraceComponent tc = Tr.register(WebSocket.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.subscription.internal.resources.RESTAPISubscriptionMessages");
    private static WebSocketFeedProvider wsFeedProvider;
    static final long serialVersionUID = 8552438327615043457L;

    @OnOpen
    public void onOpen(@PathParam(value="clientID") String clientID, Session session, EndpointConfig ec) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("New websocket connection (" + session.getId() + ") from user " + clientID), (Object[])new Object[0]);
        }
        WebSocket.getWsFeedProvider().openedConnection(clientID, session);
    }

    @OnMessage
    public void onMessage(@PathParam(value="clientID") String clientID, String message, Session session) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Websocket connection (" + session.getId() + ") received message: " + message), (Object[])new Object[0]);
        }
    }

    @OnError
    public void onError(@PathParam(value="clientID") String clientID, Session session, Throwable t) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Collective REST API WebSocket connection (" + session.getId() + ") encountered an error. Throwable: " + t.getMessage()), (Object[])new Object[0]);
        }
        WebSocket.getWsFeedProvider().closedConnection(clientID);
    }

    @OnClose
    public void onClose(@PathParam(value="clientID") String clientID, Session session, CloseReason cr) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("WebSocket connection (" + session.getId() + ") closed. Close code: " + cr.getCloseCode() + " with reason phrase: " + cr.getReasonPhrase()), (Object[])new Object[0]);
        }
        WebSocket.getWsFeedProvider().closedConnection(clientID);
    }

    public static void setWsFeedProvider(WebSocketFeedProvider feedProvider) {
        wsFeedProvider = feedProvider;
    }

    public static WebSocketFeedProvider getWsFeedProvider() {
        if (wsFeedProvider == null) {
            throw new RESTHandlerOSGiError("FeedProvider");
        }
        return wsFeedProvider;
    }
}

