/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery.subscription.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIDiscoveryConfig;
import com.ibm.ws.rest.api.discovery.APIDocPublisher;
import com.ibm.ws.rest.api.discovery.APIProviderAggregator;
import com.ibm.ws.rest.api.discovery.FeedProvider;
import com.ibm.ws.rest.api.discovery.subscription.internal.WebSocket;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerInternalError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerOSGiError;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.websocket.Session;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={FeedProvider.class, APIDocPublisher.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class WebSocketFeedProvider
implements FeedProvider,
APIDocPublisher {
    private static final TraceComponent tc = Tr.register(WebSocketFeedProvider.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.subscription.internal.resources.RESTAPISubscriptionMessages");
    private static final String FEED_TYPE = "websocket";
    private final String KEY_API_PROVIDER_AGGREGATOR = "apiProviderAggregator";
    private final AtomicServiceReference<APIProviderAggregator> apiProviderAggregatorRef = new AtomicServiceReference("apiProviderAggregator");
    private final String KEY_API_DISCOVERY_CONFIG = "apiDiscoveryConfig";
    private final AtomicServiceReference<APIDiscoveryConfig> apiDiscoveryConfigRef = new AtomicServiceReference("apiDiscoveryConfig");
    private static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final Map<String, APIProvider.DocType> docTypeMap;
    private final Map<String, Session> sessionMap;
    private final AtomicBoolean processPendingApiProvidersCalled = new AtomicBoolean(false);
    static final long serialVersionUID = 7421774137420808998L;

    public WebSocketFeedProvider() {
        this.docTypeMap = new ConcurrentHashMap<String, APIProvider.DocType>();
        this.sessionMap = new ConcurrentHashMap<String, Session>();
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.executorServiceRef.activate(context);
        this.apiProviderAggregatorRef.activate(context);
        this.apiDiscoveryConfigRef.activate(context);
        WebSocket.setWsFeedProvider(this);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        WebSocket.setWsFeedProvider(null);
        this.executorServiceRef.deactivate(context);
        this.apiProviderAggregatorRef.deactivate(context);
        this.apiDiscoveryConfigRef.deactivate(context);
    }

    /*
     * WARNING - void declaration
     */
    public void openedConnection(String clientID, Session session) {
        if (this.docTypeMap.get(clientID) == null) {
            block4: {
                try {
                    session.close();
                }
                catch (IOException iOException) {
                    void e;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.subscription.internal.WebSocketFeedProvider", (String)"90", (Object)this, (Object[])new Object[]{clientID, session});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)("IOException during session close " + e.getMessage()), (Object[])new Object[0]);
                }
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Associating clientID " + clientID + " with session " + session.getId()), (Object[])new Object[0]);
        }
        this.sessionMap.put(clientID, session);
    }

    public synchronized void closedConnection(String clientID) {
        this.docTypeMap.remove(clientID);
        this.sessionMap.remove(clientID);
        this.getAPIDiscoveryConfig().returnSubscription();
    }

    public String getFeedType() {
        return FEED_TYPE;
    }

    public String getFeedURL(APIProvider.DocType docType) {
        return this.getNewClientURL(this.getNewClientID(docType));
    }

    /*
     * WARNING - void declaration
     */
    public void publishRESTAPIDoc(APIProvider.DocType docType, String doc) {
        if (!this.docTypeMap.isEmpty()) {
            Set<Map.Entry<String, APIProvider.DocType>> entrySet = this.docTypeMap.entrySet();
            for (Map.Entry<String, APIProvider.DocType> entry : entrySet) {
                Session session;
                if (entry.getValue() != docType) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Publishing doc to clientID: " + entry.getKey()), (Object[])new Object[0]);
                }
                if ((session = this.sessionMap.get(entry.getKey())) == null) continue;
                int bufferSize = session.getMaxTextMessageBufferSize();
                if (bufferSize == -1) {
                    bufferSize = doc.length();
                }
                int beginPos = 0;
                int endPos = 0;
                while (beginPos < doc.length()) {
                    block7: {
                        endPos = beginPos + bufferSize > doc.length() ? doc.length() : beginPos + bufferSize;
                        String chunk = doc.substring(beginPos, endPos);
                        try {
                            session.getBasicRemote().sendText(chunk, endPos == doc.length());
                        }
                        catch (IOException iOException) {
                            void e;
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.subscription.internal.WebSocketFeedProvider", (String)"148", (Object)this, (Object[])new Object[]{docType, doc});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                            Tr.debug((TraceComponent)tc, (String)("IOException during sendText " + e.getMessage()), (Object[])new Object[0]);
                        }
                    }
                    beginPos = endPos;
                }
            }
        }
    }

    private String getNewClientURL(String clientID) {
        return "wss://" + this.getApiProviderAggregator().getHostPort() + "/ibm/api/docs/subscription/websocket/" + clientID;
    }

    private synchronized String getNewClientID(APIProvider.DocType docType) {
        block4: {
            if (!this.getAPIDiscoveryConfig().newSubscription()) {
                throw new RESTHandlerInternalError(Tr.formatMessage((TraceComponent)tc, (String)"REACHED_SUBSCRIPTION_LIMIT", (Object[])new Object[0]));
            }
            if (this.processPendingApiProvidersCalled.compareAndSet(false, true)) {
                final APIProviderAggregator apiProviderAggregator = this.getApiProviderAggregator();
                ScheduledExecutorService executorService = this.getExecutorService();
                try {
                    executorService.execute(new Runnable(){
                        static final long serialVersionUID = 3032567452366369764L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public void run() {
                            apiProviderAggregator.processPendingApiProviders();
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Processed pending API providers on first new subscription.", (Object[])new Object[0]);
                            }
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.subscription.internal.resources.RESTAPISubscriptionMessages");
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    FFDCFilter.processException((Throwable)rejectedExecutionException, (String)"com.ibm.ws.rest.api.discovery.subscription.internal.WebSocketFeedProvider", (String)"186", (Object)this, (Object[])new Object[]{docType});
                    apiProviderAggregator.processPendingApiProviders();
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                    Tr.debug((TraceComponent)tc, (String)"Processed pending API providers on first new subscription.", (Object[])new Object[0]);
                }
            }
        }
        String clientID = UUID.randomUUID().toString();
        this.docTypeMap.put(clientID, docType);
        return clientID;
    }

    protected APIProviderAggregator getApiProviderAggregator() {
        APIProviderAggregator apiProviderAggregator = (APIProviderAggregator)this.apiProviderAggregatorRef.getService();
        if (apiProviderAggregator == null) {
            throw new RESTHandlerOSGiError("APIProviderAggregator");
        }
        return apiProviderAggregator;
    }

    @Reference(service=APIProviderAggregator.class, name="apiProviderAggregator")
    protected void setAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.setReference(apiProviderAggregator);
    }

    protected void unsetAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.unsetReference(apiProviderAggregator);
    }

    protected APIDiscoveryConfig getAPIDiscoveryConfig() {
        APIDiscoveryConfig apiDiscoveryConfig = (APIDiscoveryConfig)this.apiDiscoveryConfigRef.getService();
        if (apiDiscoveryConfig == null) {
            throw new RESTHandlerOSGiError("APIDiscoveryConfig");
        }
        return apiDiscoveryConfig;
    }

    @Reference(service=APIDiscoveryConfig.class, name="apiDiscoveryConfig")
    protected void setAPIDiscoveryConfig(ServiceReference<APIDiscoveryConfig> apiDiscoveryConfig) {
        this.apiDiscoveryConfigRef.setReference(apiDiscoveryConfig);
    }

    protected void unsetAPIDiscoveryConfig(ServiceReference<APIDiscoveryConfig> apiDiscoveryConfig) {
        this.apiDiscoveryConfigRef.unsetReference(apiDiscoveryConfig);
    }

    protected ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService executorService = (ScheduledExecutorService)this.executorServiceRef.getService();
        if (executorService == null) {
            throw new RESTHandlerOSGiError("ScheduledExecutorService");
        }
        return executorService;
    }

    @Reference(service=ScheduledExecutorService.class, name="executorService")
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }
}

