(function(){ 
  'use strict';
  SwaggerUi.Views.HeaderView = Backbone.View.extend({
    events: {
      'click #filter'                : 'filterAPI',
          'keydown #input_filter' : 'filterAPIOnKeyup',
    },

      initialize : function() {
      },

    filterAPIOnKeyup: function(e){
      if (e.keyCode === 13) {
          this.filterAPI(e);
          return false;
      }
    },

    filterAPI: function(e){
      if (e) {
        e.preventDefault();
      }
      
      if (countFilterRequests > 0) {
    	  return;
      }
      
      var newUrl = "/ibm/api/docs";
      var filter = $('#input_filter').val();
      
      if (filter) {
        newUrl = newUrl + "?compact=true";
        var params = this.parseFilter(filter);
        
        for (var i=0; i < params.length; i++) {
          if(params[i][0] != '/'){
            params[i] = '/' + params[i];
          }
          newUrl = newUrl + "&root=" + encodeURIComponent(params[i]);

        }
        
        	  this.trigger('update-swagger-ui', {
                url: newUrl
            });
        } else {
          newUrl = newUrl + "?compact=true";
            this.trigger('update-swagger-ui', {
              url: newUrl
           });
        }
    },
    
    parseFilter : function(filter) {
      var quoteChar = "";
      var buffer = "";
      var res = [];
      for (var i=0; i<filter.length; i++) {
        var c = filter.charAt(i);
        if (quoteChar) {
          if (c == quoteChar ) {
            quoteChar = "";
            if (buffer) {
              res.push(buffer);
            }
            buffer = "";
          } else {
            buffer = buffer + c;
          }
        } else {
          if ((c == "'") || (c == '"')) {
            quoteChar = c;
          } else if (c == ',') {
            if (buffer) {
              res.push(buffer);
              buffer = "";
            }
          } else {
            buffer = buffer + c;
          }
        }
      }
      if ((!quoteChar) && (buffer)) {
        res.push(buffer);
        buffer = "";
      }       
      return res;
    },
    
      update: function(url, apiKey, trigger){
        if (trigger === undefined) {
          trigger = false;
        }
  
        $('#input_baseUrl').val(url);
        //$('#input_apiKey').val(apiKey);
        if (trigger) {
          this.trigger('update-swagger-ui', {
            url : url
          });
        }
      }
});
}).call(this);