/** loads JavaScript file and adds to DOM dynamically **/
function loadUIJs(jsFile) {
      var scriptEle = document.createElement("script");
      scriptEle.type = "application/javascript";
      scriptEle.src = jsFile;
      document.body.appendChild(scriptEle);
}

/** Creates a new Swagger Object and loads it **/
function loadSwaggerUI(url, dom_id, isCollective) {
    // Pre load translate...
    if(window.SwaggerTranslator) {
      window.SwaggerTranslator.translate();
    }
    
    window.swaggerUi = new SwaggerUi({
      url: url,
      collective: isCollective,
      validatorUrl: null,
      dom_id: dom_id,
      useJQuery: false,
      enableCookies: true,
      supportedSubmitMethods: ['get', 'post', 'put', 'delete', 'patch'],
      onComplete: function(swaggerApi, swaggerUi){
        if(typeof initOAuth == "function") {
          initOAuth({
            clientId: "your-client-id",
            clientSecret: "your-client-secret",
            realm: "your-realms",
            appName: "your-app-name", 
            scopeSeparator: ","
          });
        }
        
        $('pre code').each(function(i, e) {
            hljs.highlightBlock(e)
          });

        if(window.SwaggerTranslator) {
          window.SwaggerTranslator.translate();
        }
      },
      onFailure: function(data) {
        log("Unable to Load SwaggerUI");
      },
      docExpansion: "none",
      apisSorter: "alpha",
      showRequestHeaders: false
    });
    

    function addApiKeyAuthorization(){
      var key = encodeURIComponent($('#input_apiKey')[0].value);
      if(key && key.trim() != "") {
          var apiKeyAuth = new SwaggerClient.ApiKeyAuthorization("api_key", key, "query");
          window.swaggerUi.api.clientAuthorizations.add("api_key", apiKeyAuth);
          log("added key " + key);
      }
    }

    $('#input_apiKey').change(addApiKeyAuthorization);

    window.swaggerUi.load();
    
    setTimeout(function() {
      countFilterRequests = 0;
     }, 100);

    function log() {
      if ('console' in window) {
        console.log.apply(console, arguments);
      }
    }
 }
