/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIProviderAggregator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerInternalError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerInvalidInputValue;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMissingRequiredHeader;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMissingRequiredParam;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerOSGiError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.Path;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.auth.ApiKeyAuthDefinition;
import v2.io.swagger.models.auth.In;
import v2.io.swagger.models.auth.SecuritySchemeDefinition;
import v2.io.swagger.parser.SwaggerParser;
import v2.io.swagger.util.Json;
import v2.io.swagger.util.Yaml;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.security=true", "com.ibm.wsspi.rest.handler.root=/docs/apiconnect"})
public class APIConnectHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(APIConnectHandler.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    public static final String LEGACY_QUERY_ROOT = "apiRoot";
    public static final String QUERY_ROOT = "root";
    private static final String QUERY_ORG = "organization";
    private static final String QUERY_CATALOG = "catalog";
    private static final String QUERY_SERVER = "server";
    private static final String QUERY_STAGE_ONLY = "stageOnly";
    public static final String MIME_YAML = "application/yaml";
    public static final String MIME_JSON = "application/json";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    private static final String HEADER_APIM_AUTHENTICATION = "X-APIM-Authorization";
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String FIELD_X_IBM_NAME = "x-ibm-name";
    private static final String FIELD_X_IBM_CONFIGURATION = "x-ibm-configuration";
    private static final String FIELD_DISPLAY_NAME = "displayName";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_SHORT_NAME = "shortName";
    private static final String FIELD_APIS = "apis";
    private static final String FIELD_ID = "id";
    private static final String FIELD_PRODUCT = "product";
    private static final String FIELD_INFO = "info";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_DOCUMENT = "document";
    private static final String FIELD_VISIBILITY = "visibility";
    private static final String FIELD_HOST = "host";
    private static final String VALUE_CATALOG_HOST_VARIABLE = "$(catalog.host)";
    private static final String FIELD_API_KEY = "api_key";
    private static final String FIELD_CLIENT_ID = "client_id";
    private static final String FIELD_TARGET_URL = "target-url";
    private static final String GATEWAY_TARGET_VARIABLE = "${gateway.target}";
    private static final String VALUE_X_IBM_CONFIGURATION = "{\"phase\":\"realized\",\"testable\":true,\"enforced\":true,\"cors\":{\"enabled\":true},\"assembly\":{\"execute\":[{\"invoke\":{\"description\":\"Invoking back-end service\",\"title\":\"Invocation\",\"target-url\":\"${gateway.target}$(request.path)\"}}]}}";
    private final String KEY_API_PROVIDER_AGGREGATOR = "apiProviderAggregator";
    private final AtomicServiceReference<APIProviderAggregator> apiProviderAggregatorRef = new AtomicServiceReference("apiProviderAggregator");
    private static SSLContext defaultSSLContext;
    static final long serialVersionUID = -5755896547067761421L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.apiProviderAggregatorRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.apiProviderAggregatorRef.deactivate(context);
    }

    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        boolean isYaml;
        Set<String> rootSet = APIConnectHandler.processMultiCardinalityQueryParam(request.getParameterValues(QUERY_ROOT));
        if (rootSet == null) {
            rootSet = APIConnectHandler.processMultiCardinalityQueryParam(request.getParameterValues(LEGACY_QUERY_ROOT));
        }
        APIProvider.DocType docType = (isYaml = MIME_YAML.equals(request.getHeader(HEADER_CONTENT_TYPE))) ? APIProvider.DocType.Swagger_20_YAML : APIProvider.DocType.Swagger_20_JSON;
        String apiString = this.getApiProviderAggregator().getApps(docType, rootSet);
        if ("POST".equals(request.getMethod())) {
            APIConnectHandler.coreHandleRequest(request, response, Collections.singletonList(apiString), tc);
        } else if ("GET".equals(request.getMethod())) {
            ObjectMapper objectMapper = isYaml ? Yaml.mapper() : Json.mapper();
            JsonNode api = (JsonNode)objectMapper.readValue(apiString, JsonNode.class);
            APIConnectHandler.processXIBMConfiguration(api, VALUE_X_IBM_CONFIGURATION, objectMapper);
            APIConnectHandler.serialize(api, response, false);
        }
    }

    private static void processXIBMConfiguration(JsonNode api, String ibmConfigString, ObjectMapper objectMapper) throws JsonParseException, JsonMappingException, IOException {
        if (ibmConfigString.contains(FIELD_TARGET_URL)) {
            String hostValue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"found target-url", (Object[])new Object[0]);
            }
            if ((hostValue = api.get(FIELD_HOST).textValue()) != null) {
                hostValue = "https://" + hostValue;
                ibmConfigString = ibmConfigString.replace(GATEWAY_TARGET_VARIABLE, hostValue);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("x-ibm-configuration from product after replacement: " + ibmConfigString), (Object[])new Object[0]);
                }
            }
            ((ObjectNode)api).put(FIELD_HOST, VALUE_CATALOG_HOST_VARIABLE);
        }
        ((ObjectNode)api).set(FIELD_X_IBM_CONFIGURATION, (JsonNode)objectMapper.readValue(ibmConfigString, JsonNode.class));
    }

    public static void coreHandleRequest(RESTRequest request, RESTResponse response, List<String> apis, TraceComponent tc) throws IOException {
        String contentType = request.getHeader(HEADER_CONTENT_TYPE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Content-Type: " + contentType), (Object[])new Object[0]);
        }
        ObjectMapper objectMapper = null;
        objectMapper = MIME_YAML.equals(contentType) ? Yaml.mapper() : Json.mapper();
        String apimAuthentication = request.getHeader(HEADER_APIM_AUTHENTICATION);
        if (apimAuthentication == null || apimAuthentication.isEmpty()) {
            throw new RESTHandlerMissingRequiredHeader(HEADER_APIM_AUTHENTICATION);
        }
        if (!apimAuthentication.startsWith("Basic")) {
            apimAuthentication = "Basic " + Base64Coder.base64Encode((String)apimAuthentication);
        }
        String serverQuery = APIConnectHandler.getRequiredParam(request, QUERY_SERVER);
        String orgQuery = APIConnectHandler.getRequiredParam(request, QUERY_ORG);
        String catalogQuery = APIConnectHandler.getRequiredParam(request, QUERY_CATALOG);
        boolean stageOnly = Boolean.parseBoolean(request.getParameter(QUERY_STAGE_ONLY));
        if (serverQuery.endsWith("/")) {
            serverQuery = serverQuery.substring(0, serverQuery.length() - 1);
        }
        if (!serverQuery.startsWith("http")) {
            serverQuery = "http://" + serverQuery;
        }
        InputStream in = request.getInputStream();
        JsonNode requestProduct = (JsonNode)objectMapper.readValue(in, JsonNode.class);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Input product: " + objectMapper.writeValueAsString((Object)requestProduct)), (Object[])new Object[0]);
        }
        JsonNode orgs = APIConnectHandler.connect(APIConnectHandler.buildOrgQueryURL(serverQuery), "GET", apimAuthentication, null, tc);
        String organizationID = null;
        int orgsSize = orgs.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Size of orgs array: " + orgsSize), (Object[])new Object[0]);
        }
        for (int i = 0; i < orgsSize; ++i) {
            JsonNode org = orgs.get(i);
            if (!orgQuery.equals(org.get(FIELD_NAME).textValue()) && !orgQuery.equals(org.get(FIELD_DISPLAY_NAME).textValue())) continue;
            organizationID = org.get(FIELD_ID).textValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("organizationID: " + organizationID), (Object[])new Object[0]);
        }
        if (organizationID == null) {
            throw new RESTHandlerInvalidInputValue(QUERY_ORG);
        }
        JsonNode catalogs = APIConnectHandler.connect(APIConnectHandler.buildCatalogQueryURL(serverQuery, organizationID), "GET", apimAuthentication, null, tc);
        String catalogID = null;
        int catalogsSize = catalogs.size();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Size of catalogs array: " + catalogsSize), (Object[])new Object[0]);
        }
        for (int i = 0; i < catalogsSize; ++i) {
            JsonNode catalog = catalogs.get(i);
            if (!catalogQuery.equals(catalog.get(FIELD_NAME).textValue()) && !catalogQuery.equals(catalog.get(FIELD_SHORT_NAME).textValue())) continue;
            catalogID = catalog.get(FIELD_ID).textValue();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("catalogID: " + catalogID), (Object[])new Object[0]);
        }
        if (catalogID == null) {
            throw new RESTHandlerInvalidInputValue(QUERY_CATALOG);
        }
        JsonNode productAPIs = requestProduct.get(FIELD_APIS);
        String apiLocalName = (String)productAPIs.fieldNames().next();
        JsonNode productAPIObject = productAPIs.get(apiLocalName);
        String apiReference = productAPIObject.get(FIELD_NAME).textValue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("apiReference: " + apiReference), (Object[])new Object[0]);
        }
        String[] apiRefSplit = apiReference.split(":");
        String apiName = apiRefSplit[0];
        String apiVersion = apiRefSplit[1];
        JsonNode xIBMConfigurationFromProduct = ((ObjectNode)productAPIObject).remove(FIELD_X_IBM_CONFIGURATION);
        ArrayNode apiArray = Json.mapper().createArrayNode();
        for (int i = 0; i < apis.size(); ++i) {
            JsonNode api = (JsonNode)objectMapper.readValue(apis.get(i), JsonNode.class);
            ObjectNode infoNode = (ObjectNode)api.get(FIELD_INFO);
            infoNode.put(FIELD_VERSION, apiVersion);
            if (xIBMConfigurationFromProduct != null) {
                APIConnectHandler.processXIBMConfiguration(api, objectMapper.writeValueAsString((Object)xIBMConfigurationFromProduct), objectMapper);
            } else {
                JsonNode xIBMConfigurationFromAPINode = api.get(FIELD_X_IBM_CONFIGURATION);
                String xIBMConfigurationFromAPI = xIBMConfigurationFromAPINode == null ? VALUE_X_IBM_CONFIGURATION : objectMapper.writeValueAsString((Object)xIBMConfigurationFromAPINode);
                APIConnectHandler.processXIBMConfiguration(api, xIBMConfigurationFromAPI, objectMapper);
            }
            if (i == 0) {
                infoNode.put(FIELD_X_IBM_NAME, apiName);
            } else {
                String apiName_dynamic = apiName + "_" + i;
                infoNode.put(FIELD_X_IBM_NAME, apiName_dynamic);
                ObjectNode name = Json.mapper().createObjectNode();
                name.put(FIELD_NAME, apiName_dynamic + ":" + apiVersion);
                ((ObjectNode)productAPIs).set(apiLocalName + "_" + i, (JsonNode)name);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("current product api: " + Json.mapper().writeValueAsString((Object)productAPIs)), (Object[])new Object[0]);
                }
            }
            if (apis.size() > 1) {
                Swagger apiSwagger = new SwaggerParser().parse(Json.mapper().writeValueAsString((Object)api));
                ApiKeyAuthDefinition securityDef = new ApiKeyAuthDefinition(FIELD_CLIENT_ID, In.QUERY);
                apiSwagger.addSecurityDefinition(FIELD_API_KEY, (SecuritySchemeDefinition)securityDef);
                Map paths = apiSwagger.getPaths();
                if (paths != null) {
                    for (Path path : paths.values()) {
                        for (Operation oper : path.getOperations()) {
                            oper.addSecurity(FIELD_API_KEY, Collections.emptyList());
                        }
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no paths found", (Object[])new Object[0]);
                }
                api = (JsonNode)objectMapper.readValue(Json.mapper().writeValueAsString((Object)apiSwagger), JsonNode.class);
            }
            apiArray.add(api);
        }
        ObjectNode catalogProduct = Json.mapper().createObjectNode();
        catalogProduct.set(FIELD_PRODUCT, requestProduct);
        catalogProduct.set(FIELD_APIS, (JsonNode)apiArray);
        JsonNode returnResponse = APIConnectHandler.connect(APIConnectHandler.buildProductStageURL(serverQuery, organizationID, catalogID), "POST", apimAuthentication, Json.mapper().writeValueAsString((Object)catalogProduct), tc);
        if (!stageOnly) {
            String productID = returnResponse.get(FIELD_ID).textValue();
            JsonNode visibility = returnResponse.get(FIELD_DOCUMENT).get(FIELD_VISIBILITY);
            ObjectNode visibilityContainer = Json.mapper().createObjectNode();
            visibilityContainer.set(FIELD_VISIBILITY, visibility);
            returnResponse = APIConnectHandler.connect(APIConnectHandler.buildProductPublishURL(serverQuery, organizationID, catalogID, productID), "POST", apimAuthentication, Json.mapper().writeValueAsString((Object)visibilityContainer), tc);
        }
        APIConnectHandler.serialize(returnResponse, response, true);
    }

    private static void serialize(JsonNode responseNode, RESTResponse response, boolean compact) throws IOException {
        response.setContentType(MIME_JSON);
        response.setCharacterEncoding("UTF-8");
        Writer writer = response.getWriter();
        if (compact) {
            writer.write(Json.mapper().writeValueAsString((Object)responseNode));
        } else {
            writer.write(Json.pretty().writeValueAsString((Object)responseNode));
        }
        writer.close();
    }

    public static Set<String> processMultiCardinalityQueryParam(String[] params) {
        HashSet<String> resultSet = null;
        if (params != null) {
            resultSet = new HashSet<String>();
            for (String param : params) {
                resultSet.add(param);
            }
        }
        return resultSet;
    }

    protected APIProviderAggregator getApiProviderAggregator() {
        APIProviderAggregator apiProviderAggregator = (APIProviderAggregator)this.apiProviderAggregatorRef.getService();
        if (apiProviderAggregator == null) {
            throw new RESTHandlerOSGiError("APIProviderAggregator");
        }
        return apiProviderAggregator;
    }

    @Reference(service=APIProviderAggregator.class, name="apiProviderAggregator")
    protected void setAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.setReference(apiProviderAggregator);
    }

    protected void unsetAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.unsetReference(apiProviderAggregator);
    }

    /*
     * WARNING - void declaration
     */
    private static JsonNode connect(String url, String method, @Sensitive String authorizationHeader, String payload, TraceComponent tc) {
        try {
            HttpURLConnection connection = APIConnectHandler.getConnection(url, tc);
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            connection.setDoOutput(method.equals("POST") || method.equals("PUT"));
            connection.setRequestProperty(HEADER_ACCEPT, MIME_JSON);
            connection.setRequestProperty(HEADER_AUTHORIZATION, authorizationHeader);
            if (payload != null) {
                connection.setRequestProperty(HEADER_CONTENT_TYPE, MIME_JSON);
                try (OutputStreamWriter w = new OutputStreamWriter(connection.getOutputStream(), "UTF-8");){
                    w.write(payload);
                }
            }
            int responseCode = connection.getResponseCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ResponseCode: " + responseCode), (Object[])new Object[0]);
            }
            if (responseCode == 200 || responseCode == 201) {
                ObjectMapper objMapper = new ObjectMapper();
                return (JsonNode)objMapper.readValue(connection.getInputStream(), JsonNode.class);
            }
            InputStream stream = connection.getErrorStream();
            stream = stream != null ? stream : connection.getInputStream();
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[128];
            int charsRead = 0;
            while ((charsRead = reader.read(buffer)) > 0) {
                sb.append(buffer, 0, charsRead);
            }
            RESTHandlerInternalError error = new RESTHandlerInternalError(sb.toString());
            error.setStatusCode(responseCode);
            throw error;
        }
        catch (IOException connection) {
            void e1;
            Object[] objectArray = new Object[5];
            objectArray[0] = url;
            objectArray[1] = method;
            objectArray[2] = "<sensitive java.lang.String>";
            objectArray[3] = payload;
            objectArray[4] = tc;
            FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.rest.api.discovery.APIConnectHandler", (String)"566", null, (Object[])objectArray);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("IOException: " + e1.getMessage()), (Object[])new Object[0]);
            }
            throw new RESTHandlerInternalError((Exception)e1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static HttpURLConnection getConnection(String path, TraceComponent tc) {
        block10: {
            try {
                URL url = new URL(path);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                try {
                    if (connection instanceof HttpsURLConnection) {
                        ((HttpsURLConnection)connection).setSSLSocketFactory(APIConnectHandler.createDefaultSSLSocketFactory());
                    }
                    return connection;
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.rest.api.discovery.APIConnectHandler", (String)"587", null, (Object[])new Object[]{path, tc});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        void e;
                        Tr.event((TraceComponent)tc, (String)("NoSuchAlgorithmException: " + e), (Object[])new Object[0]);
                    }
                }
                catch (KeyManagementException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.rest.api.discovery.APIConnectHandler", (String)"591", null, (Object[])new Object[]{path, tc});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("KeyManagementException: " + e), (Object[])new Object[0]);
                    }
                }
            }
            catch (MalformedURLException url) {
                FFDCFilter.processException((Throwable)url, (String)"com.ibm.ws.rest.api.discovery.APIConnectHandler", (String)"597", null, (Object[])new Object[]{path, tc});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    void mfe;
                    Tr.event((TraceComponent)tc, (String)("MalformedURLException: " + mfe.getMessage()), (Object[])new Object[0]);
                }
            }
            catch (IOException mfe) {
                void e1;
                FFDCFilter.processException((Throwable)mfe, (String)"com.ibm.ws.rest.api.discovery.APIConnectHandler", (String)"601", null, (Object[])new Object[]{path, tc});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block10;
                Tr.event((TraceComponent)tc, (String)("IOException: " + e1.getMessage()), (Object[])new Object[0]);
            }
        }
        return null;
    }

    public static SSLSocketFactory createDefaultSSLSocketFactory() throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = APIConnectHandler.createDefaultSSLContext();
        return sslContext.getSocketFactory();
    }

    public static SSLContext createDefaultSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        if (defaultSSLContext == null) {
            defaultSSLContext = APIConnectHandler.isIBMJVM() ? APIConnectHandler.newSSLContext("SSL", "TLSv1.1") : APIConnectHandler.newSSLContext("TLSv1.2", "TLSv1.1");
        }
        return defaultSSLContext;
    }

    private static SSLContext newSSLContext(String primaryProtocol, String defaultProtocol) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance(primaryProtocol);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.rest.api.discovery.APIConnectHandler", (String)"638", null, (Object[])new Object[]{primaryProtocol, defaultProtocol});
            sslContext = SSLContext.getInstance(defaultProtocol);
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){
            static final long serialVersionUID = -7608684974023788861L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
            }
        }};
        sslContext.init(null, trustAllCerts, new SecureRandom());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SSLContext protocol: " + sslContext.getProtocol()), (Object[])new Object[0]);
        }
        return sslContext;
    }

    private static boolean isIBMJVM() {
        return JavaInfo.vendor() == JavaInfo.Vendor.IBM;
    }

    private static String getRequiredParam(RESTRequest request, String paramName) {
        String param = request.getParameter(paramName);
        if (param == null) {
            throw new RESTHandlerMissingRequiredParam(paramName);
        }
        return param;
    }

    private static String buildOrgQueryURL(String server) {
        return server + "/v1/me/orgs";
    }

    private static String buildCatalogQueryURL(String server, String orgId) {
        return server + "/v1/orgs/" + orgId + "/environments";
    }

    private static String buildProductStageURL(String server, String orgId, String catalogId) {
        return server + "/v1/orgs/" + orgId + "/environments/" + catalogId + "/products";
    }

    private static String buildProductPublishURL(String server, String orgId, String catalogId, String productId) {
        return server + "/v1/orgs/" + orgId + "/environments/" + catalogId + "/products/" + productId + "/publish";
    }
}

