/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={APIProvider.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class APIDiscoveryAPIProviderImpl
implements APIProvider {
    private static final String PREFIX = "file:///";
    private WsLocationAdmin locationAdminProvider;
    private static final TraceComponent tc = Tr.register(APIDiscoveryAPIProviderImpl.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    static final long serialVersionUID = 1453974741027566903L;

    @Reference(service=WsLocationAdmin.class)
    protected void setLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = provider;
    }

    protected void unsetLocationAdmin(WsLocationAdmin provider) {
        this.locationAdminProvider = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public String getDocument(APIProvider.DocType docType) {
        String path = null;
        if (docType == APIProvider.DocType.Swagger_20_JSON) {
            path = this.locationAdminProvider.resolveString("${server.output.dir}//workarea/api.discovery.doc/swagger.json");
            File swaggerDoc = new File(path);
            if (!FileUtils.fileExists((File)swaggerDoc)) {
                try {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("File doesn't exist : " + path), (Object[])new Object[0]);
                    }
                    FileUtils.fileMkDirs((File)swaggerDoc.getParentFile());
                    FileUtils.fileCreate((File)swaggerDoc);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryAPIProviderImpl", (String)"71", (Object)this, (Object[])new Object[]{docType});
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        void e;
                        Tr.event((TraceComponent)tc, (String)("IOException occurred while creating file/folder. e=" + e), (Object[])new Object[0]);
                    }
                    return null;
                }
                InputStream inputStream = this.getClass().getResourceAsStream("/lib/swagger.json");
                if (inputStream != null) {
                    FileOutputStream outputStream = null;
                    try {
                        int len;
                        outputStream = FileUtils.getFileOutputStream((File)swaggerDoc);
                        byte[] buffer = new byte[2048];
                        while ((len = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, len);
                        }
                    }
                    catch (IOException buffer) {
                        FFDCFilter.processException((Throwable)buffer, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryAPIProviderImpl", (String)"89", (Object)this, (Object[])new Object[]{docType});
                        FileUtils.fileDelete((File)swaggerDoc);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            void ioe;
                            Tr.event((TraceComponent)tc, (String)("IOException occurred while copying file contents. ioe" + ioe), (Object[])new Object[0]);
                        }
                        String string = null;
                        return string;
                    }
                    finally {
                        FileUtils.tryToClose((Closeable)outputStream);
                        FileUtils.tryToClose((Closeable)inputStream);
                    }
                }
            }
            path = PREFIX + path;
        }
        return path;
    }
}

