/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIProviderAggregator;
import com.ibm.ws.rest.api.discovery.internal.mbean.APIDiscovery;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.wab.configure.WABConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={APIDiscoveryConfig.class}, configurationPid={"com.ibm.ws.rest.api.discovery"}, configurationPolicy=ConfigurationPolicy.OPTIONAL, immediate=true, property={"service.vendor=IBM"})
public class APIDiscoveryConfig {
    public static final TraceComponent tc = Tr.register(APIDiscoveryConfig.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private final String KEY_API_PROVIDER_AGGREGATOR = "apiProviderAggregator";
    private final AtomicServiceReference<APIProviderAggregator> apiProviderAggregatorRef = new AtomicServiceReference("apiProviderAggregator");
    private final String KEY_API_DISCOVERY = "apiDiscovery";
    private final AtomicServiceReference<APIDiscovery> apiDiscoveryRef = new AtomicServiceReference("apiDiscovery");
    private static final String PUBLIC_DISCOVERY_DOCS_URL_NAME = "publicDiscoveryDocsURL";
    private static final String PUBLIC_DISCOVERY_EXPLORER_URL_NAME = "publicDiscoveryExplorerURL";
    private static final String COLLECTIVE_PUBLIC_DISCOVERY_DOCS_URL_NAME = "collectivePublicDiscoveryDocsURL";
    private static final String COLLECTIVE_PUBLIC_DISCOVERY_EXPLORER_URL_NAME = "collectivePublicDiscoveryExplorerURL";
    private static final String COLLECTIVE_PUBLIC_DISCOVERY_REGISTRY_URL_NAME = "collectivePublicDiscoveryRegistryURL";
    private static final String DOCS_CONTEXT_PATH_SUFFIX = "/docs";
    private static final String EXPLORER_CONTEXT_PATH_SUFFIX = "/explorer";
    private static final String COLLECTIVE_DOCS_CONTEXT_PATH_SUFFIX = "/collective/docs";
    private static final String COLLECTIVE_EXPLORER_CONTEXT_PATH_SUFFIX = "/collective/explorer";
    private static final String COLLECTIVE_REGISTRY_CONTEXT_PATH_SUFFIX = "/collective/registry";
    private static final String CONFIG_MAX_SUBSCRIPTIONS = "maxSubscriptions";
    private static final String CONFIG_API_NAME = "apiName";
    private static final String CONFIG_PUBLIC_URL = "publicURL";
    private static final String CONFIG_SWAGGER_DEFINITION = "swaggerDefinition";
    private static final int DEFAULT_MAX_SUBSCRIPTIONS = 20;
    private static final String DEFAULT_PUBLIC_URL = "/api";
    private static final String RESERVED_URL = "/ibm/api";
    private int maxSubscriptions;
    private String apiName;
    private String swaggerDefinition;
    private String publicURL;
    private final List<APIDiscoveryWABConfigManager> wabConfigMgrs;
    private int currentSubscriptions = 0;
    static final long serialVersionUID = 345397556660599814L;

    public APIDiscoveryConfig() {
        this.setDefaults(false);
        this.wabConfigMgrs = new ArrayList<APIDiscoveryWABConfigManager>();
        this.wabConfigMgrs.add(new APIDiscoveryWABConfigManager(PUBLIC_DISCOVERY_DOCS_URL_NAME, DOCS_CONTEXT_PATH_SUFFIX));
        this.wabConfigMgrs.add(new APIDiscoveryWABConfigManager(PUBLIC_DISCOVERY_EXPLORER_URL_NAME, EXPLORER_CONTEXT_PATH_SUFFIX));
        this.wabConfigMgrs.add(new APIDiscoveryWABConfigManager(COLLECTIVE_PUBLIC_DISCOVERY_DOCS_URL_NAME, COLLECTIVE_DOCS_CONTEXT_PATH_SUFFIX));
        this.wabConfigMgrs.add(new APIDiscoveryWABConfigManager(COLLECTIVE_PUBLIC_DISCOVERY_EXPLORER_URL_NAME, COLLECTIVE_EXPLORER_CONTEXT_PATH_SUFFIX));
        this.wabConfigMgrs.add(new APIDiscoveryWABConfigManager(COLLECTIVE_PUBLIC_DISCOVERY_REGISTRY_URL_NAME, COLLECTIVE_REGISTRY_CONTEXT_PATH_SUFFIX));
    }

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.apiProviderAggregatorRef.activate(context);
        this.apiDiscoveryRef.activate(context);
        this.processConfig(context, properties);
    }

    @Modified
    protected void modified(ComponentContext context, Map<String, Object> properties) throws IOException {
        this.processConfig(context, properties);
    }

    private synchronized void setDefaults(boolean processConfig) {
        this.maxSubscriptions = 20;
        this.apiName = null;
        this.swaggerDefinition = null;
        this.publicURL = processConfig ? DEFAULT_PUBLIC_URL : null;
    }

    private synchronized void processConfig(ComponentContext context, Map<String, Object> properties) {
        String apiName_old = this.apiName;
        String swaggerDefinition_old = this.swaggerDefinition;
        String publicURL_old = this.publicURL;
        if (properties == null) {
            this.setDefaults(true);
        } else {
            Integer maxSubscriptionsObj = (Integer)properties.get(CONFIG_MAX_SUBSCRIPTIONS);
            if (maxSubscriptionsObj != null) {
                this.maxSubscriptions = maxSubscriptionsObj;
            }
            this.apiName = (String)properties.get(CONFIG_API_NAME);
            this.swaggerDefinition = (String)properties.get(CONFIG_SWAGGER_DEFINITION);
            String publicURLObj = (String)properties.get(CONFIG_PUBLIC_URL);
            if (publicURLObj != null) {
                if (!publicURLObj.startsWith("/")) {
                    publicURLObj = '/' + publicURLObj;
                }
                if (publicURLObj.endsWith("/") && !publicURLObj.equals("/")) {
                    publicURLObj = publicURLObj.substring(0, publicURLObj.length() - 1);
                }
                if (RESERVED_URL.equals(publicURLObj)) {
                    Tr.warning((TraceComponent)tc, (String)"PUBLIC_URL_INVALID", (Object[])new Object[]{RESERVED_URL});
                    publicURLObj = publicURL_old;
                }
            } else {
                publicURLObj = DEFAULT_PUBLIC_URL;
            }
            this.publicURL = publicURLObj;
        }
        if (this.valueChanged(apiName_old, this.apiName) || this.valueChanged(swaggerDefinition_old, this.swaggerDefinition)) {
            this.getApiProviderAggregator().setAPIName(this.apiName);
            this.getApiProviderAggregator().setSwaggerDefinition(this.swaggerDefinition);
        }
        if (this.valueChanged(publicURL_old, this.publicURL)) {
            this.getApiDiscovery().setPublicURL(this.publicURL);
            this.getApiProviderAggregator().setPublicURL(this.publicURL);
            for (APIDiscoveryWABConfigManager wabConfigMgr : this.wabConfigMgrs) {
                wabConfigMgr.updateWABConfiguration(context, this.publicURL);
            }
        }
    }

    private boolean valueChanged(Object oldValue, Object newValue) {
        return oldValue == null ? newValue != null : !oldValue.equals(newValue);
    }

    protected APIProviderAggregator getApiProviderAggregator() {
        APIProviderAggregator apiProviderAggregator = (APIProviderAggregator)this.apiProviderAggregatorRef.getService();
        if (apiProviderAggregator == null) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"APIProviderAggregator"}));
        }
        return apiProviderAggregator;
    }

    @Reference(service=APIProviderAggregator.class, name="apiProviderAggregator")
    protected void setAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.setReference(apiProviderAggregator);
    }

    protected void unsetAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.unsetReference(apiProviderAggregator);
    }

    protected APIDiscovery getApiDiscovery() {
        APIDiscovery apiDiscovery = (APIDiscovery)this.apiDiscoveryRef.getService();
        if (apiDiscovery == null) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{"APIDiscovery"}));
        }
        return apiDiscovery;
    }

    @Reference(service=APIDiscovery.class, name="apiDiscovery")
    protected void setAPIDiscovery(ServiceReference<APIDiscovery> apiDiscovery) {
        this.apiDiscoveryRef.setReference(apiDiscovery);
    }

    protected void unsetAPIDiscovery(ServiceReference<APIDiscovery> apiDiscovery) {
        this.apiDiscoveryRef.unsetReference(apiDiscovery);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.apiDiscoveryRef.deactivate(context);
        this.apiProviderAggregatorRef.deactivate(context);
        for (APIDiscoveryWABConfigManager wabConfigMgr : this.wabConfigMgrs) {
            wabConfigMgr.deactivate();
        }
    }

    public synchronized boolean newSubscription() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("currentSubscriptions=" + this.currentSubscriptions + ", maxSubscriptions=" + this.maxSubscriptions), (Object[])new Object[0]);
        }
        if (this.currentSubscriptions + 1 > this.maxSubscriptions) {
            return false;
        }
        ++this.currentSubscriptions;
        return true;
    }

    public synchronized void returnSubscription() {
        if (this.currentSubscriptions > 0) {
            --this.currentSubscriptions;
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class APIDiscoveryWABConfigManager {
        private final String contextName;
        private final String contextPathSuffix;
        private ServiceRegistration<WABConfiguration> wabConfigReg;
        static final long serialVersionUID = 2830933742125625052L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public APIDiscoveryWABConfigManager(String contextName, String contextPathSuffix) {
            this.contextName = contextName;
            this.contextPathSuffix = contextPathSuffix;
        }

        public void updateWABConfiguration(ComponentContext context, String publicURL) {
            BundleContext bundleContext = context.getBundleContext();
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("contextName", this.contextName);
            ((Dictionary)props).put("contextPath", publicURL + this.contextPathSuffix);
            if (this.wabConfigReg == null) {
                this.wabConfigReg = bundleContext.registerService(WABConfiguration.class, (Object)new WABConfiguration(){
                    static final long serialVersionUID = -1082608192230585236L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
                    }
                }, props);
            } else {
                this.wabConfigReg.setProperties(props);
            }
        }

        public void deactivate() {
            if (this.wabConfigReg != null) {
                this.wabConfigReg.unregister();
                this.wabConfigReg = null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(APIDiscoveryWABConfigManager.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
        }
    }
}

