/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.rest.api.discovery.APIProviderAggregator;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.rest.api.discovery.APIProvider;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerOSGiError;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.security=true", "com.ibm.wsspi.rest.handler.root=/docs"})
public class APIDiscoveryHandler
implements RESTHandler {
    public static final String QUERY_ROOT = "root";
    public static final String QUERY_SERVICE = "service";
    public static final String QUERY_FORMAT = "format";
    public static final String QUERY_COMPACT = "compact";
    public static final String QUERY_PORTS = "displayPorts";
    public static final String FORMAT_SWAGGER_20 = "Swagger2.0";
    public static final String FORMAT_RAML = "RAML";
    public static final String FORMAT_API_BLUEPRINT = "APIBlueprint";
    public static final String MIME_JSON = "application/json";
    public static final String MIME_YAML = "application/yaml";
    public static final TraceComponent tc = Tr.register(APIDiscoveryHandler.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    private final String KEY_API_PROVIDER_AGGREGATOR = "apiProviderAggregator";
    private final AtomicServiceReference<APIProviderAggregator> apiProviderAggregatorRef = new AtomicServiceReference("apiProviderAggregator");
    static final long serialVersionUID = 8986930475668774255L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.apiProviderAggregatorRef.activate(context);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.apiProviderAggregatorRef.deactivate(context);
    }

    public void handleRequest(RESTRequest request, RESTResponse response) throws IOException {
        if (!"GET".equals(request.getMethod())) {
            throw new RESTHandlerMethodNotAllowedError("GET");
        }
        APIProvider.DocType docType = APIDiscoveryHandler.calculateDocType(request);
        Set<String> rootSet = APIDiscoveryHandler.processMultiCardinalityQueryParam(request.getParameterValues(QUERY_ROOT));
        boolean compact = Boolean.parseBoolean(request.getParameter(QUERY_COMPACT));
        boolean displayPorts = Boolean.parseBoolean(request.getParameter(QUERY_PORTS));
        this.getApiProviderAggregator().getDocumentation(docType, rootSet, compact, displayPorts, request, response);
    }

    public static Set<String> processMultiCardinalityQueryParam(String[] params) {
        HashSet<String> resultSet = null;
        if (params != null) {
            resultSet = new HashSet<String>();
            for (String param : params) {
                resultSet.add(param);
            }
        }
        return resultSet;
    }

    public static APIProvider.DocType calculateDocType(RESTRequest request) {
        String accept = request.getHeader("Accept");
        String format = request.getParameter(QUERY_FORMAT);
        if (format == null) {
            format = FORMAT_SWAGGER_20;
        }
        if (accept == null) {
            accept = MIME_JSON;
        }
        APIProvider.DocType docType = APIProvider.DocType.Swagger_20_JSON;
        if (format.equalsIgnoreCase(FORMAT_SWAGGER_20) && accept.contains(MIME_YAML)) {
            docType = APIProvider.DocType.Swagger_20_YAML;
        } else if (format.equalsIgnoreCase(FORMAT_RAML)) {
            docType = APIProvider.DocType.RAML_YAML;
        } else if (format.equalsIgnoreCase(FORMAT_API_BLUEPRINT)) {
            docType = APIProvider.DocType.API_BLUEPRINT_JSON;
        }
        return docType;
    }

    protected APIProviderAggregator getApiProviderAggregator() {
        APIProviderAggregator apiProviderAggregator = (APIProviderAggregator)this.apiProviderAggregatorRef.getService();
        if (apiProviderAggregator == null) {
            throw new RESTHandlerOSGiError("APIProviderAggregator");
        }
        return apiProviderAggregator;
    }

    @Reference(service=APIProviderAggregator.class, name="apiProviderAggregator")
    protected void setAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.setReference(apiProviderAggregator);
    }

    protected void unsetAPIProviderAggregator(ServiceReference<APIProviderAggregator> apiProviderAggregator) {
        this.apiProviderAggregatorRef.unsetReference(apiProviderAggregator);
    }
}

