/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rest.api.discovery;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.SwaggerException;
import v2.io.swagger.parser.SwaggerParser;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class APIDiscoveryUtils {
    private static final TraceComponent tc = Tr.register(APIDiscoveryUtils.class, (String)"RESTAPIDiscovery", (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages");
    static final long serialVersionUID = 9188473539614259351L;

    /*
     * WARNING - void declaration
     */
    public static String getSwaggerDocumentFromURL(String url) {
        try {
            URL urlDoc = new URL(url);
            HttpURLConnection connection = (HttpURLConnection)urlDoc.openConnection();
            connection.setRequestMethod("GET");
            String acceptValue = url.endsWith("yaml") ? "application/yaml" : "application/json";
            connection.setRequestProperty("Accept", acceptValue);
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                return APIDiscoveryUtils.getSwaggerDocFromStream(connection.getInputStream());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Did not find swagger document in " + url + ".  ResponseCode: " + responseCode), (Object[])new Object[0]);
            }
        }
        catch (MalformedURLException urlDoc) {
            FFDCFilter.processException((Throwable)urlDoc, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"52", null, (Object[])new Object[]{url});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void mfe;
                Tr.event((TraceComponent)tc, (String)("Exception: " + mfe.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        catch (IOException mfe) {
            FFDCFilter.processException((Throwable)mfe, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"57", null, (Object[])new Object[]{url});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void ioe;
                Tr.event((TraceComponent)tc, (String)("Exception: " + ioe.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
        return null;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    public static String getSwaggerDocFromStream(InputStream is) {
        String string;
        block11: {
            string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            try {
                is.close();
            }
            catch (IOException iOException) {
                void ioe;
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"76", null, (Object[])new Object[]{is});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block11;
                Tr.event((TraceComponent)tc, (String)("Exception when closing: " + ioe.getMessage()), (Object[])new Object[0]);
            }
        }
        return string;
        catch (IOException iOException) {
            block12: {
                try {
                    void ioe;
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"69", null, (Object[])new Object[]{is});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block12;
                    Tr.event((TraceComponent)tc, (String)("Exception when reading: " + ioe.getMessage()), (Object[])new Object[0]);
                }
                catch (Throwable throwable) {
                    block14: {
                        try {
                            is.close();
                        }
                        catch (IOException iOException2) {
                            void ioe;
                            FFDCFilter.processException((Throwable)iOException2, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"76", null, (Object[])new Object[]{is});
                            if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block14;
                            Tr.event((TraceComponent)tc, (String)("Exception when closing: " + ioe.getMessage()), (Object[])new Object[0]);
                        }
                    }
                    throw throwable;
                }
            }
            try {
                is.close();
            }
            catch (IOException ioe) {
                FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"76", null, (Object[])new Object[]{is});
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Exception when closing: " + ioe.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getSwaggerDocFromFile(File file) {
        try {
            return FileUtils.readFileToString((File)file, (String)"UTF-8");
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"88", null, (Object[])new Object[]{file});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                void ioe;
                Tr.event((TraceComponent)tc, (String)("Exception when reading: " + ioe.getMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    public static Swagger parseSwagger(String swagger) {
        return APIDiscoveryUtils.parseSwagger(swagger, true);
    }

    /*
     * WARNING - void declaration
     */
    public static Swagger parseSwagger(String swagger, boolean verify) {
        Swagger sw;
        block2: {
            sw = null;
            try {
                sw = !verify ? new SwaggerParser().parse(swagger, null, false) : new SwaggerParser().parse(swagger);
            }
            catch (SwaggerException swaggerException) {
                void se;
                FFDCFilter.processException((Throwable)swaggerException, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"109", null, (Object[])new Object[]{swagger, verify});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block2;
                Tr.event((TraceComponent)tc, (String)("SwaggerException occurred while trying to read document : \n exception=" + se), (Object[])new Object[0]);
            }
        }
        return sw;
    }

    public static String normalizeContextRoot(String contextRoot) {
        if (contextRoot != null && !contextRoot.trim().isEmpty()) {
            if ("/*".equals(contextRoot)) {
                contextRoot = "/";
            } else if (contextRoot.endsWith("/*")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - 2);
            } else if (contextRoot.endsWith("/")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - 1);
            }
        }
        return contextRoot;
    }

    /*
     * WARNING - void declaration
     */
    public static int getPortFromVendorExtensions(Swagger swagger, String portKey) {
        int port;
        block3: {
            Object value;
            port = 0;
            if (swagger != null && (value = swagger.getVendorExtensions().get(portKey)) != null) {
                try {
                    port = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    void nfe;
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.rest.api.discovery.APIDiscoveryUtils", (String)"138", null, (Object[])new Object[]{swagger, portKey});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("NumberFormatException : portKey=" + portKey + " : message=" + nfe.getMessage()), (Object[])new Object[0]);
                }
            }
        }
        return port;
    }

    public static String getOsgiServiceErrorMessage(Class aClass, String serviceName) {
        return TraceNLS.getFormattedMessage((Class)aClass, (String)"com.ibm.ws.rest.api.discovery.internal.resources.RESTAPIDiscoveryMessages", (String)"OSGI_SERVICE_ERROR", (Object[])new Object[]{serviceName}, (String)"CWWKO1100E: The {0} OSGi service is not available.");
    }
}

